/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.spellchecker.dictionary.Loader;
import com.intellij.util.Consumer;
import java.io.BufferedReader;
import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import org.jetbrains.annotations.NotNull;

public class StreamLoader
implements Loader {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.spellchecker.StreamLoader");
    private static final String ENCODING = "UTF-8";
    private final InputStream stream;
    private final String name;

    public StreamLoader(InputStream stream, String name) {
        this.stream = stream;
        this.name = name;
    }

    @Override
    public String getName() {
        return this.name;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load(@NotNull Consumer<String> consumer) {
        if (consumer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/spellchecker/StreamLoader", "load"));
        }
        DataInputStream in = new DataInputStream(this.stream);
        BufferedReader br = null;
        try {
            String strLine;
            br = new BufferedReader(new InputStreamReader((InputStream)in, ENCODING));
            while ((strLine = br.readLine()) != null) {
                consumer.consume((Object)strLine);
            }
        }
        catch (Exception e) {
            LOG.error((Throwable)e);
        }
        finally {
            try {
                br.close();
            }
            catch (IOException ignored) {}
        }
    }
}

