/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.spellchecker.inspections.IdentifierSplitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class PsiTypeTokenizer
extends Tokenizer<PsiTypeElement> {
    @Override
    public void tokenize(@NotNull PsiTypeElement element, TokenConsumer consumer) {
        boolean isInSource;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/spellchecker/PsiTypeTokenizer", "tokenize"));
        }
        PsiType type = element.getType();
        if (type instanceof PsiDisjunctionType) {
            this.tokenizeComplexType(element, consumer);
            return;
        }
        PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)type);
        if (psiClass == null || psiClass.getContainingFile() == null || psiClass.getContainingFile().getVirtualFile() == null) {
            return;
        }
        VirtualFile virtualFile = psiClass.getContainingFile().getVirtualFile();
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)element.getProject()).getFileIndex();
        boolean bl = isInSource = virtualFile != null && fileIndex.isInContent(virtualFile);
        if (isInSource) {
            consumer.consumeToken((PsiElement)element, element.getText(), true, 0, PsiTypeTokenizer.getRangeToCheck(element.getText(), psiClass.getName()), IdentifierSplitter.getInstance());
        }
    }

    private void tokenizeComplexType(PsiTypeElement element, TokenConsumer consumer) {
        List subTypes = PsiTreeUtil.getChildrenOfTypeAsList((PsiElement)element, PsiTypeElement.class);
        for (PsiTypeElement subType : subTypes) {
            this.tokenize(subType, consumer);
        }
    }

    @NotNull
    private static TextRange getRangeToCheck(@NotNull String text, @NotNull String name) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/spellchecker/PsiTypeTokenizer", "getRangeToCheck"));
        }
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/spellchecker/PsiTypeTokenizer", "getRangeToCheck"));
        }
        int i = text.indexOf(name);
        TextRange textRange = new TextRange(i, i + name.length());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/spellchecker/PsiTypeTokenizer", "getRangeToCheck"));
        }
        return textRange;
    }
}

