/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.spellchecker.PsiIdentifierTokenizer;
import com.intellij.spellchecker.PsiTypeTokenizer;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import org.jetbrains.annotations.NotNull;

public class NamedElementTokenizer<T extends PsiNamedElement>
extends Tokenizer<T> {
    private final Tokenizer<PsiIdentifier> myIdentifierTokenizer = new PsiIdentifierTokenizer();
    private final PsiTypeTokenizer myTypeTokenizer = new PsiTypeTokenizer();

    @Override
    public void tokenize(@NotNull T element, TokenConsumer consumer) {
        String type;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/spellchecker/NamedElementTokenizer", "tokenize"));
        }
        PsiIdentifier psiIdentifier = (PsiIdentifier)PsiTreeUtil.getChildOfType(element, PsiIdentifier.class);
        PsiTypeElement psiType = (PsiTypeElement)PsiTreeUtil.getChildOfType(element, PsiTypeElement.class);
        if (psiIdentifier == null) {
            return;
        }
        String identifier = psiIdentifier.getText();
        String string = type = psiType == null ? null : psiType.getText();
        if (identifier == null) {
            return;
        }
        if (type == null || !type.equalsIgnoreCase(identifier)) {
            this.myIdentifierTokenizer.tokenize(psiIdentifier, consumer);
        }
        if (psiType != null) {
            this.myTypeTokenizer.tokenize(psiType, consumer);
        }
    }
}

