/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.spellchecker;

import com.intellij.psi.PsiElement;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.spellchecker.inspections.CommentSplitter;
import com.intellij.spellchecker.tokenizer.TokenConsumer;
import com.intellij.spellchecker.tokenizer.Tokenizer;
import com.intellij.util.containers.ContainerUtil;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class DocCommentTokenizer
extends Tokenizer<PsiDocComment> {
    private static final Set<String> excludedTags = ContainerUtil.immutableSet((Object[])new String[]{"author", "see", "by", "link"});

    @Override
    public void tokenize(@NotNull PsiDocComment comment, TokenConsumer consumer) {
        if (comment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/spellchecker/DocCommentTokenizer", "tokenize"));
        }
        CommentSplitter splitter = CommentSplitter.getInstance();
        for (PsiElement el : comment.getChildren()) {
            if (el instanceof PsiDocTag) {
                PsiDocTag tag = (PsiDocTag)el;
                if (excludedTags.contains(tag.getName())) continue;
                for (PsiElement data : tag.getDataElements()) {
                    consumer.consumeToken(data, splitter);
                }
                continue;
            }
            consumer.consumeToken(el, splitter);
        }
    }
}

