/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util.ssh;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.notification.Notification;
import com.intellij.notification.NotificationListener;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.options.UnnamedConfigurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.MessageType;
import com.intellij.openapi.ui.Messages;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.ServerConfiguration;
import com.intellij.remoteServer.impl.configuration.RemoteServerImpl;
import com.intellij.remoteServer.runtime.ServerConnection;
import com.intellij.remoteServer.runtime.ServerConnectionManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.log.LoggingHandler;
import com.intellij.remoteServer.runtime.ui.RemoteServersView;
import com.intellij.remoteServer.util.CloudConnectionTask;
import com.intellij.remoteServer.util.CloudNotifier;
import com.intellij.remoteServer.util.CloudRuntimeTask;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.remoteServer.util.ssh.PublicSshKeyDialog;
import com.intellij.remoteServer.util.ssh.SshKeyAwareServerRuntime;
import com.intellij.ui.HyperlinkLabel;
import com.intellij.util.ParameterizedRunnable;
import java.io.File;
import javax.swing.JComponent;
import javax.swing.event.HyperlinkEvent;
import javax.swing.event.HyperlinkListener;
import org.jetbrains.annotations.NotNull;

public class SshKeyChecker {
    private static boolean isSshKeyErrorMessage(String errorMessage) {
        return errorMessage.contains("Could not read from remote repository") || errorMessage.contains("The remote end hung up unexpectedly");
    }

    public void checkServerError(String errorMessage, CloudNotifier notifier, Project project, CloudConnectionTask connectionTask) {
        if (SshKeyChecker.isSshKeyErrorMessage(errorMessage)) {
            new ServerHandler(notifier, project, connectionTask).handle(errorMessage);
        } else {
            notifier.showMessage(errorMessage, MessageType.ERROR);
        }
    }

    public void checkDeploymentError(String errorMessage, SshKeyAwareServerRuntime serverRuntime, DeploymentLogManager logManager, DeploymentTask deploymentTask) {
        if (SshKeyChecker.isSshKeyErrorMessage(errorMessage) && logManager != null) {
            new DeploymentHandler(serverRuntime, logManager.getMainLoggingHandler(), deploymentTask).handle();
        }
    }

    public <C extends ServerConfiguration> void setupUploadLabel(HyperlinkLabel label, UnnamedConfigurable serverConfigurable, C serverConfiguration, ServerType<C> serverType) {
        new ConfigurableHandler(this, label, serverConfigurable, serverConfiguration, serverType);
    }

    private static abstract class HandlerBase {
        private HandlerBase() {
        }

        protected void chooseKey() {
            PublicSshKeyDialog dialog = new PublicSshKeyDialog(this.getProject());
            if (dialog.showAndGet()) {
                this.uploadKey(dialog.getSshKey());
            }
        }

        protected abstract void uploadKey(File var1);

        protected abstract Project getProject();
    }

    private static class ConfigurableHandler<C extends ServerConfiguration>
    extends HandlerBase
    implements HyperlinkListener {
        private final UnnamedConfigurable myServerConfigurable;
        private final C myServerConfiguration;
        private final ServerType<C> myServerType;
        private final HyperlinkLabel myLabel;
        final /* synthetic */ SshKeyChecker this$0;

        public ConfigurableHandler(HyperlinkLabel label, UnnamedConfigurable serverConfigurable, C serverConfiguration, ServerType<C> serverType) {
            this.this$0 = var1_1;
            this.myServerConfigurable = serverConfigurable;
            this.myServerConfiguration = serverConfiguration;
            this.myServerType = serverType;
            label.setHyperlinkText("Upload Public SSH Key");
            label.addHyperlinkListener((HyperlinkListener)this);
            this.myLabel = label;
        }

        @Override
        public void hyperlinkUpdate(HyperlinkEvent e) {
            this.chooseKey();
        }

        @Override
        protected void uploadKey(final File sskKey) {
            try {
                this.myServerConfigurable.apply();
            }
            catch (ConfigurationException e) {
                Messages.showErrorDialog((String)("Cannot upload SSH key: " + e.getMessage()), (String)e.getTitle());
                return;
            }
            RemoteServerImpl<C> server = new RemoteServerImpl<C>("<temp server to upload ssh key>", this.myServerType, this.myServerConfiguration);
            CloudConnectionTask task = new CloudConnectionTask(null, "Uploading SSH key", server){

                @Override
                protected Object run(CloudServerRuntimeInstance serverRuntime) throws ServerRuntimeException {
                    ((SshKeyAwareServerRuntime)((Object)serverRuntime)).addSshKey(sskKey);
                    return null;
                }
            };
            task.performSync();
            task.showMessageDialog((JComponent)this.myLabel, "SSH key was uploaded", "Public SSH Key");
        }

        @Override
        protected Project getProject() {
            return null;
        }
    }

    private class DeploymentHandler
    extends HandlerBase {
        private final SshKeyAwareServerRuntime myServerRuntime;
        private final DeploymentTask myDeploymentTask;
        private final LoggingHandler myLoggingHandler;

        private DeploymentHandler(SshKeyAwareServerRuntime serverRuntime, LoggingHandler loggingHandler, DeploymentTask deploymentTask) {
            this.myServerRuntime = serverRuntime;
            this.myDeploymentTask = deploymentTask;
            this.myLoggingHandler = loggingHandler;
        }

        @Override
        protected Project getProject() {
            return this.myDeploymentTask.getProject();
        }

        public void handle() {
            this.myLoggingHandler.print("You may need to ");
            this.myLoggingHandler.printHyperlink("upload SSH public key", new HyperlinkInfo(){

                public void navigate(Project project) {
                    DeploymentHandler.this.chooseKey();
                }
            });
            this.myLoggingHandler.print("\n");
        }

        @Override
        protected void uploadKey(final File sskKey) {
            new CloudRuntimeTask(this.getProject(), "Uploading SSH key"){

                protected CloudServerRuntimeInstance getServerRuntime() {
                    return DeploymentHandler.this.myServerRuntime.asCloudServerRuntime();
                }

                protected Object run(CloudServerRuntimeInstance serverRuntimeInstance) throws ServerRuntimeException {
                    DeploymentHandler.this.myServerRuntime.addSshKey(sskKey);
                    DeploymentHandler.this.myLoggingHandler.print("SSH key was uploaded, you may ");
                    DeploymentHandler.this.myLoggingHandler.printHyperlink("redeploy", new HyperlinkInfo(){

                        public void navigate(Project project) {
                            DeploymentHandler.this.redeploy();
                        }
                    });
                    DeploymentHandler.this.myLoggingHandler.print("\n");
                    return null;
                }

                @Override
                protected void runtimeErrorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/ssh/SshKeyChecker$DeploymentHandler$2", "runtimeErrorOccurred"));
                    }
                    DeploymentHandler.this.myLoggingHandler.print("Unable to upload SSH key: " + errorMessage + "\n");
                }
            }.performSync();
        }

        private void redeploy() {
            final ServerConnection connection = ServerConnectionManager.getInstance().getOrCreateConnection(this.myServerRuntime.getServer());
            final RemoteServersView view = RemoteServersView.getInstance(this.myDeploymentTask.getProject());
            view.showServerConnection(connection);
            connection.deploy(this.myDeploymentTask, (ParameterizedRunnable)new ParameterizedRunnable<String>(){

                public void run(String s) {
                    view.showDeployment(connection, s);
                }
            });
        }
    }

    private class ServerHandler
    extends HandlerBase {
        private final CloudNotifier myNotifier;
        private final Project myProject;
        private final CloudConnectionTask myConnectionTask;
        private Notification myErrorNotification;

        public ServerHandler(CloudNotifier notifier, Project project, CloudConnectionTask connectionTask) {
            this.myNotifier = notifier;
            this.myProject = project;
            this.myConnectionTask = connectionTask;
        }

        @Override
        public Project getProject() {
            return this.myProject;
        }

        public void handle(String errorMessage) {
            this.myNotifier.showMessage(errorMessage + "<br/>You may need to <a href=\"#\">upload SSH public key</a>", MessageType.ERROR, new NotificationListener(){

                public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                    if (notification == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/ssh/SshKeyChecker$ServerHandler$1", "hyperlinkUpdate"));
                    }
                    if (event == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/remoteServer/util/ssh/SshKeyChecker$ServerHandler$1", "hyperlinkUpdate"));
                    }
                    ServerHandler.this.myErrorNotification = notification;
                    ServerHandler.this.chooseKey();
                }
            });
        }

        @Override
        protected void uploadKey(final File sskKey) {
            new CloudConnectionTask(this.myProject, "Uploading SSH key", this.myConnectionTask.getServer()){

                @Override
                protected Object run(CloudServerRuntimeInstance serverRuntime) throws ServerRuntimeException {
                    ((SshKeyAwareServerRuntime)((Object)serverRuntime)).addSshKey(sskKey);
                    ServerHandler.this.myErrorNotification.expire();
                    ServerHandler.this.myNotifier.showMessage("SSH key was uploaded, you may <a href=\"#\">reconnect</a>", MessageType.INFO, new NotificationListener(){

                        public void hyperlinkUpdate(@NotNull Notification notification, @NotNull HyperlinkEvent event) {
                            if (notification == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/ssh/SshKeyChecker$ServerHandler$2$1", "hyperlinkUpdate"));
                            }
                            if (event == null) {
                                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/remoteServer/util/ssh/SshKeyChecker$ServerHandler$2$1", "hyperlinkUpdate"));
                            }
                            notification.expire();
                            ServerHandler.this.reconnect();
                        }
                    });
                    return null;
                }

                @Override
                protected void runtimeErrorOccurred(@NotNull String errorMessage) {
                    if (errorMessage == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/ssh/SshKeyChecker$ServerHandler$2", "runtimeErrorOccurred"));
                    }
                    ServerHandler.this.myNotifier.showMessage(errorMessage, MessageType.ERROR);
                }
            }.performSync();
        }

        private void reconnect() {
            this.myConnectionTask.performAsync();
        }
    }
}

