/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.agent.RemoteAgentManager;
import com.intellij.remoteServer.agent.util.CloudAgentConfigBase;
import com.intellij.remoteServer.agent.util.CloudAgentLogger;
import com.intellij.remoteServer.agent.util.CloudGitAgent;
import com.intellij.remoteServer.agent.util.DeploymentData;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.runtime.RemoteOperationCallback;
import com.intellij.remoteServer.runtime.ServerConnector;
import com.intellij.remoteServer.runtime.ServerTaskExecutor;
import com.intellij.remoteServer.runtime.deployment.DeploymentLogManager;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import com.intellij.remoteServer.runtime.deployment.ServerRuntimeInstance;
import com.intellij.remoteServer.util.AgentTaskExecutor;
import com.intellij.remoteServer.util.CallbackWrapper;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.remoteServer.util.CloudDeploymentConfiguratorBase;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.remoteServer.util.CloudDeploymentNameProvider;
import com.intellij.remoteServer.util.CloudDeploymentRuntime;
import com.intellij.remoteServer.util.CloudDeploymentRuntimeProvider;
import com.intellij.remoteServer.util.CloudServerRuntimeInstance;
import com.intellij.remoteServer.util.ServerRuntimeException;
import com.intellij.util.ThrowableRunnable;
import java.io.File;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CloudMultiSourceServerRuntimeInstance<DC extends CloudDeploymentNameConfiguration, AC extends CloudAgentConfigBase, A extends CloudGitAgent<AC, ?>, SC extends AC>
extends CloudServerRuntimeInstance<DC> {
    private static final Logger LOG = Logger.getInstance((String)("#" + CloudMultiSourceServerRuntimeInstance.class.getName()));
    private final A myAgent;
    private final AgentTaskExecutor myAgentTaskExecutor;
    private final ServerType<?> myServerType;
    private final SC myConfiguration;
    private final ServerTaskExecutor myTasksExecutor;

    public CloudMultiSourceServerRuntimeInstance(ServerType<?> serverType, SC configuration, ServerTaskExecutor tasksExecutor, List<File> libraries, List<Class<?>> commonJarClasses, String specificsModuleName, String specificJarPath, Class<A> agentInterface, String agentClassName) throws Exception {
        this.myServerType = serverType;
        this.myConfiguration = configuration;
        this.myTasksExecutor = tasksExecutor;
        RemoteAgentManager agentManager = RemoteAgentManager.getInstance();
        this.myAgent = (CloudGitAgent)agentManager.createAgent(agentManager.createReflectiveThreadProxyFactory(((Object)((Object)this)).getClass().getClassLoader()), libraries, commonJarClasses, specificsModuleName, specificJarPath, agentInterface, agentClassName, ((Object)((Object)this)).getClass());
        this.myAgentTaskExecutor = new AgentTaskExecutor();
    }

    @NotNull
    public String getDeploymentName(@NotNull DeploymentSource source) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance", "getDeploymentName"));
        }
        String string = CloudDeploymentNameProvider.DEFAULT_NAME_PROVIDER.getDeploymentName(source);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance", "getDeploymentName"));
        }
        return string;
    }

    public void connect(final ServerConnector.ConnectionCallback<DC> callback) {
        this.myAgentTaskExecutor.execute(new Computable(){

            public Object compute() {
                CloudMultiSourceServerRuntimeInstance.this.doConnect(CloudMultiSourceServerRuntimeInstance.this.myConfiguration, new CloudAgentLogger(){

                    public void debugEx(Exception e) {
                        LOG.debug((Throwable)e);
                    }

                    public void debug(String message) {
                        LOG.debug(message);
                    }
                });
                return null;
            }
        }, new CallbackWrapper(){

            public void onSuccess(Object result) {
                callback.connected((ServerRuntimeInstance)CloudMultiSourceServerRuntimeInstance.this);
            }

            @Override
            public void onError(String message) {
                callback.errorOccurred(message);
            }
        });
    }

    public void deploy(final @NotNull DeploymentTask<DC> task, final @NotNull DeploymentLogManager logManager, final @NotNull ServerRuntimeInstance.DeploymentOperationCallback callback) {
        if (task == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance", "deploy"));
        }
        if (logManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance", "deploy"));
        }
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance", "deploy"));
        }
        this.myTasksExecutor.submit((ThrowableRunnable)new ThrowableRunnable<Exception>(){

            public void run() throws Exception {
                CloudMultiSourceServerRuntimeInstance.this.createDeploymentRuntime(task, logManager).deploy(callback);
            }
        }, (RemoteOperationCallback)callback);
    }

    public void computeDeployments(final @NotNull ServerRuntimeInstance.ComputeDeploymentsCallback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance", "computeDeployments"));
        }
        this.myTasksExecutor.submit((ThrowableRunnable)new ThrowableRunnable<Exception>(){

            public void run() throws Exception {
                CloudMultiSourceServerRuntimeInstance.this.myAgentTaskExecutor.execute(new Computable<DeploymentData[]>(){

                    public DeploymentData[] compute() {
                        return CloudMultiSourceServerRuntimeInstance.this.myAgent.getDeployments();
                    }
                }, new CallbackWrapper<DeploymentData[]>(){

                    @Override
                    public void onSuccess(DeploymentData[] deployments) {
                        for (DeploymentData deployment : deployments) {
                            callback.addDeployment(deployment.getName());
                        }
                        callback.succeeded();
                    }

                    @Override
                    public void onError(String message) {
                        callback.errorOccurred(message);
                    }
                });
            }
        }, (RemoteOperationCallback)callback);
    }

    public void disconnect() {
        this.myTasksExecutor.submit(new Runnable(){

            @Override
            public void run() {
                CloudMultiSourceServerRuntimeInstance.this.myAgent.disconnect();
            }
        });
    }

    @Override
    public ServerTaskExecutor getTaskExecutor() {
        return this.myTasksExecutor;
    }

    protected final A getAgent() {
        return this.myAgent;
    }

    protected final AgentTaskExecutor getAgentTaskExecutor() {
        return this.myAgentTaskExecutor;
    }

    public CloudDeploymentRuntime createDeploymentRuntime(DeployToServerRunConfiguration<?, DC> runConfiguration) throws ServerRuntimeException {
        return this.createDeploymentRuntime(runConfiguration.getDeploymentSource(), (CloudDeploymentNameConfiguration)runConfiguration.getDeploymentConfiguration(), runConfiguration.getProject());
    }

    public CloudDeploymentRuntime createDeploymentRuntime(final DeploymentSource source, DC configuration, Project project) throws ServerRuntimeException {
        return this.createDeploymentRuntime(new DeploymentTask<DC>((CloudDeploymentNameConfiguration)configuration, project){
            final /* synthetic */ CloudDeploymentNameConfiguration val$configuration;
            final /* synthetic */ Project val$project;
            {
                this.val$configuration = cloudDeploymentNameConfiguration;
                this.val$project = project;
            }

            @NotNull
            public DeploymentSource getSource() {
                DeploymentSource deploymentSource = source;
                if (deploymentSource == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance$6", "getSource"));
                }
                return deploymentSource;
            }

            @NotNull
            public DC getConfiguration() {
                CloudDeploymentNameConfiguration cloudDeploymentNameConfiguration = this.val$configuration;
                if (cloudDeploymentNameConfiguration == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance$6", "getConfiguration"));
                }
                return cloudDeploymentNameConfiguration;
            }

            @NotNull
            public Project getProject() {
                Project project = this.val$project;
                if (project == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/util/CloudMultiSourceServerRuntimeInstance$6", "getProject"));
                }
                return project;
            }

            public boolean isDebugMode() {
                return false;
            }
        }, null);
    }

    private CloudDeploymentRuntime createDeploymentRuntime(DeploymentTask<DC> deploymentTask, @Nullable DeploymentLogManager logManager) throws ServerRuntimeException {
        DeploymentSource source = deploymentTask.getSource();
        for (CloudDeploymentRuntimeProvider provider : CloudDeploymentConfiguratorBase.getDeploymentRuntimeProviders(this.myServerType)) {
            CloudDeploymentRuntime result = provider.createDeploymentRuntime(source, this, deploymentTask, logManager);
            if (result == null) continue;
            return result;
        }
        throw new ServerRuntimeException("Unknown deployment source");
    }

    public CloudConfigurationBase getConfiguration() {
        return (CloudConfigurationBase)((Object)this.myConfiguration);
    }

    protected abstract void doConnect(SC var1, CloudAgentLogger var2);
}

