/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.util;

import com.intellij.execution.RunManagerEx;
import com.intellij.execution.RunnerAndConfigurationSettings;
import com.intellij.execution.configurations.ConfigurationType;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModulePointer;
import com.intellij.openapi.module.ModulePointerManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.remoteServer.ServerType;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.configuration.deployment.DeploymentSource;
import com.intellij.remoteServer.impl.configuration.RemoteServerConfigurable;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerConfigurationType;
import com.intellij.remoteServer.impl.configuration.deployment.DeployToServerRunConfiguration;
import com.intellij.remoteServer.impl.configuration.deployment.ModuleDeploymentSourceImpl;
import com.intellij.remoteServer.util.CloudBundle;
import com.intellij.remoteServer.util.CloudConfigurationBase;
import com.intellij.remoteServer.util.CloudDeploymentNameConfiguration;
import com.intellij.uiDesigner.core.GridConstraints;
import com.intellij.uiDesigner.core.GridLayoutManager;
import com.intellij.uiDesigner.core.Spacer;
import com.intellij.util.text.UniqueNameGenerator;
import java.awt.Component;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public class CloudAccountSelectionEditor<SC extends CloudConfigurationBase, DC extends CloudDeploymentNameConfiguration, ST extends ServerType<SC>>
implements Disposable {
    private static final Logger LOG = Logger.getInstance((String)("#" + CloudAccountSelectionEditor.class.getName()));
    private JComboBox myServerComboBox;
    private JPanel myServerConfigurablePanel;
    private JPanel myMainPanel;
    private final ST myCloudType;
    private RemoteServer<SC> myNewServer;
    private RemoteServerConfigurable myServerConfigurable;

    protected CloudAccountSelectionEditor(ST cloudType) {
        this.myCloudType = cloudType;
        this.$$$setupUI$$$();
    }

    private void createUIComponents() {
        this.myServerConfigurablePanel = this.createServerConfigurablePanel();
    }

    public void initUI() {
        this.myServerComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                CloudAccountSelectionEditor.this.onAccountSelectionChanged();
            }
        });
        for (RemoteServer server : RemoteServersManager.getInstance().getServers(this.myCloudType)) {
            this.myServerComboBox.addItem(new ServerItem(server));
        }
        this.myServerComboBox.addItem(new ServerItem(this.myNewServer));
    }

    private void onAccountSelectionChanged() {
        this.myServerConfigurablePanel.setVisible(this.getSelectedServerItem().isNew());
    }

    protected JPanel createServerConfigurablePanel() {
        this.myNewServer = RemoteServersManager.getInstance().createServer(this.myCloudType, this.generateServerName());
        this.myServerConfigurable = new RemoteServerConfigurable(this.myNewServer, null, true);
        this.myServerConfigurablePanel = (JPanel)this.myServerConfigurable.createComponent();
        return this.myServerConfigurablePanel;
    }

    private String generateServerName() {
        return UniqueNameGenerator.generateUniqueName((String)this.myCloudType.getPresentableName(), (Condition)new Condition<String>(){

            public boolean value(String s) {
                for (RemoteServer server : RemoteServersManager.getInstance().getServers()) {
                    if (!server.getName().equals(s)) continue;
                    return false;
                }
                return true;
            }
        });
    }

    public DeployToServerRunConfiguration<SC, DC> createRunConfiguration(Module module, DC deploymentConfiguration) {
        Project project = module.getProject();
        RemoteServer<SC> server = this.getServer();
        if (server == null) {
            return null;
        }
        if (this.getSelectedServerItem().isNew()) {
            RemoteServersManager.getInstance().addServer(server);
            this.myNewServer = null;
        }
        String serverName = server.getName();
        String name = this.generateRunConfigurationName(serverName, module.getName());
        RunManagerEx runManager = RunManagerEx.getInstanceEx(project);
        RunnerAndConfigurationSettings runSettings = runManager.createRunConfiguration(name, this.getRunConfigurationType().getConfigurationFactories()[0]);
        DeployToServerRunConfiguration result = (DeployToServerRunConfiguration)runSettings.getConfiguration();
        runManager.addConfiguration(runSettings, false);
        runManager.setSelectedConfiguration(runSettings);
        result.setServerName(serverName);
        ModulePointer modulePointer = ModulePointerManager.getInstance((Project)project).create(module);
        result.setDeploymentSource((DeploymentSource)new ModuleDeploymentSourceImpl(modulePointer));
        result.setDeploymentConfiguration(deploymentConfiguration);
        return result;
    }

    protected String generateRunConfigurationName(String serverName, String moduleName) {
        return CloudBundle.getText("run.configuration.name", serverName, moduleName);
    }

    protected void handleError(ConfigurationException e) {
        LOG.info((Throwable)e);
    }

    public RemoteServer<SC> getServer() {
        try {
            return this.doGetServer();
        }
        catch (ConfigurationException e) {
            this.handleError(e);
            return null;
        }
    }

    private RemoteServer<SC> doGetServer() throws ConfigurationException {
        ServerItem serverItem = this.getSelectedServerItem();
        if (serverItem.isNew()) {
            this.myServerConfigurable.apply();
            this.myNewServer.setName(this.myServerConfigurable.getDisplayName());
        }
        return serverItem.getServer();
    }

    public void validate() throws ConfigurationException {
        this.doGetServer();
    }

    private ServerItem getSelectedServerItem() {
        return (ServerItem)this.myServerComboBox.getSelectedItem();
    }

    private DeployToServerConfigurationType getRunConfigurationType() {
        String id = DeployToServerConfigurationType.getId(this.myCloudType);
        for (ConfigurationType configurationType : (ConfigurationType[])ConfigurationType.CONFIGURATION_TYPE_EP.getExtensions()) {
            DeployToServerConfigurationType deployConfigurationType;
            if (!(configurationType instanceof DeployToServerConfigurationType) || !(deployConfigurationType = (DeployToServerConfigurationType)configurationType).getId().equals(id)) continue;
            return deployConfigurationType;
        }
        return null;
    }

    public JPanel getMainPanel() {
        return this.myMainPanel;
    }

    public void dispose() {
        this.myServerConfigurable.disposeUIResources();
    }

    private /* synthetic */ void $$$setupUI$$$() {
        JComboBox jComboBox;
        JPanel jPanel;
        this.createUIComponents();
        this.myMainPanel = jPanel = new JPanel();
        jPanel.setLayout((LayoutManager)new GridLayoutManager(3, 1, new Insets(0, 0, 0, 0), -1, -1, false, false));
        this.myServerComboBox = jComboBox = new JComboBox();
        jPanel.add(jComboBox, new GridConstraints(0, 0, 1, 1, 8, 1, 2, 0, null, null, null));
        JPanel jPanel2 = this.myServerConfigurablePanel;
        jPanel.add((Component)jPanel2, new GridConstraints(1, 0, 1, 1, 0, 3, 3, 3, null, null, null));
        Spacer spacer = new Spacer();
        jPanel.add((Component)spacer, new GridConstraints(2, 0, 1, 1, 0, 2, 1, 6, null, null, null));
    }

    public /* synthetic */ JComponent $$$getRootComponent$$$() {
        return this.myMainPanel;
    }

    private class ServerItem {
        private final RemoteServer<SC> myServer;

        public ServerItem(RemoteServer<SC> server) {
            this.myServer = server;
        }

        public boolean isNew() {
            return this.myServer == CloudAccountSelectionEditor.this.myNewServer;
        }

        public RemoteServer<SC> getServer() {
            return this.myServer;
        }

        public String toString() {
            return this.isNew() ? "New account..." : this.myServer.getName();
        }
    }
}

