/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui.tree.actions;

import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.remoteServer.impl.runtime.ui.tree.DeploymentNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.ServerNode;
import com.intellij.remoteServer.impl.runtime.ui.tree.actions.ServersTreeActionBase;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class EditConfigurationAction
extends ServersTreeActionBase {
    public EditConfigurationAction() {
        super("Edit Configuration", "Edit configuration of the selected server", AllIcons.Actions.EditSource);
    }

    @Override
    protected void doActionPerformed(@NotNull ServersToolWindowContent content, AnActionEvent e) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/EditConfigurationAction", "doActionPerformed"));
        }
        Set<DeploymentNode> deploymentNodes = content.getSelectedDeploymentNodes();
        Set<ServerNode> serverNodes = content.getSelectedServerNodes();
        if (deploymentNodes.size() == 1) {
            deploymentNodes.iterator().next().editConfiguration();
        } else {
            serverNodes.iterator().next().editConfiguration();
        }
    }

    @Override
    protected boolean isEnabled(@NotNull ServersToolWindowContent content, AnActionEvent e) {
        if (content == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/runtime/ui/tree/actions/EditConfigurationAction", "isEnabled"));
        }
        Set<DeploymentNode> deploymentNodes = content.getSelectedDeploymentNodes();
        Set<ServerNode> serverNodes = content.getSelectedServerNodes();
        if (deploymentNodes.size() + serverNodes.size() != 1) {
            return false;
        }
        if (deploymentNodes.size() == 1) {
            return deploymentNodes.iterator().next().isEditConfigurationActionEnabled();
        }
        return true;
    }
}

