/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.ui;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.remoteServer.configuration.RemoteServer;
import com.intellij.remoteServer.configuration.RemoteServerListener;
import com.intellij.remoteServer.configuration.RemoteServersManager;
import com.intellij.remoteServer.impl.runtime.ui.RemoteServersViewContributor;
import com.intellij.remoteServer.impl.runtime.ui.ServersToolWindowContent;
import com.intellij.ui.content.Content;
import com.intellij.ui.content.ContentFactory;
import icons.RemoteServersIcons;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class ServersToolWindow {
    public static final String ID = "Application Servers";
    private final Project myProject;
    private final ToolWindow myToolWindow;

    public ServersToolWindow(Project project) {
        this.myProject = project;
        for (RemoteServersViewContributor contributor : (RemoteServersViewContributor[])RemoteServersViewContributor.EP_NAME.getExtensions()) {
            contributor.setupAvailabilityListener(project, new Runnable(){

                @Override
                public void run() {
                    ServersToolWindow.this.updateWindowAvailable(true);
                }
            });
        }
        this.myProject.getMessageBus().connect().subscribe(RemoteServerListener.TOPIC, (Object)new RemoteServerListener(){

            public void serverAdded(@NotNull RemoteServer<?> server) {
                if (server == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindow$2", "serverAdded"));
                }
                ServersToolWindow.this.updateWindowAvailable(true);
            }

            public void serverRemoved(@NotNull RemoteServer<?> server) {
                if (server == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/runtime/ui/ServersToolWindow$2", "serverRemoved"));
                }
                ServersToolWindow.this.updateWindowAvailable(false);
            }
        });
        this.myToolWindow = ToolWindowManager.getInstance((Project)project).registerToolWindow(ID, false, ToolWindowAnchor.BOTTOM);
        this.myToolWindow.setIcon(RemoteServersIcons.ServersToolWindow);
        ContentFactory contentFactory = ContentFactory.SERVICE.getInstance();
        ServersToolWindowContent serversContent = new ServersToolWindowContent(project);
        Content content = contentFactory.createContent((JComponent)serversContent.getMainPanel(), null, false);
        Disposer.register((Disposable)content, (Disposable)serversContent);
        this.myToolWindow.getContentManager().addContent(content);
        this.updateWindowAvailable(false);
    }

    private void updateWindowAvailable(boolean showIfAvailable) {
        boolean doShow;
        boolean available = this.isAvailable();
        boolean bl = doShow = !this.myToolWindow.isAvailable() && available;
        if (this.myToolWindow.isAvailable() && !available) {
            this.myToolWindow.hide(null);
        }
        this.myToolWindow.setAvailable(available, null);
        if (showIfAvailable && doShow) {
            this.myToolWindow.show(null);
        }
    }

    private boolean isAvailable() {
        if (!RemoteServersManager.getInstance().getServers().isEmpty()) {
            return true;
        }
        for (RemoteServersViewContributor contributor : (RemoteServersViewContributor[])RemoteServersViewContributor.EP_NAME.getExtensions()) {
            if (!contributor.canContribute(this.myProject)) continue;
            return true;
        }
        return false;
    }
}

