/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.runtime.deployment;

import com.intellij.remoteServer.runtime.Deployment;
import com.intellij.remoteServer.runtime.deployment.DeploymentRuntime;
import com.intellij.remoteServer.runtime.deployment.DeploymentStatus;
import com.intellij.remoteServer.runtime.deployment.DeploymentTask;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DeploymentImpl
implements Deployment {
    private final String myName;
    private final DeploymentTask<?> myDeploymentTask;
    private volatile DeploymentState myState;

    public DeploymentImpl(@NotNull String name, @NotNull DeploymentStatus status, @Nullable String statusText, @Nullable DeploymentRuntime runtime, @Nullable DeploymentTask<?> deploymentTask) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "<init>"));
        }
        if (status == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "<init>"));
        }
        this.myName = name;
        this.myDeploymentTask = deploymentTask;
        this.myState = new DeploymentState(status, statusText, runtime);
    }

    @NotNull
    public String getName() {
        String string = this.myName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "getName"));
        }
        return string;
    }

    @NotNull
    public DeploymentStatus getStatus() {
        DeploymentStatus deploymentStatus = this.myState.getStatus();
        if (deploymentStatus == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "getStatus"));
        }
        return deploymentStatus;
    }

    @NotNull
    public String getStatusText() {
        String statusText = this.myState.getStatusText();
        String string = statusText != null ? statusText : this.getStatus().getPresentableText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "getStatusText"));
        }
        return string;
    }

    public DeploymentRuntime getRuntime() {
        return this.myState.getRuntime();
    }

    @Nullable
    public DeploymentTask<?> getDeploymentTask() {
        return this.myDeploymentTask;
    }

    public boolean changeState(@NotNull DeploymentStatus oldStatus, @NotNull DeploymentStatus newStatus, @Nullable String statusText, @Nullable DeploymentRuntime runtime) {
        if (oldStatus == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "changeState"));
        }
        if (newStatus == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl", "changeState"));
        }
        if (this.myState.getStatus() == oldStatus) {
            this.myState = new DeploymentState(newStatus, statusText, runtime);
            return true;
        }
        return false;
    }

    private static class DeploymentState {
        private final DeploymentStatus myStatus;
        private final String myStatusText;
        private final DeploymentRuntime myRuntime;

        private DeploymentState(@NotNull DeploymentStatus status, @Nullable String statusText, @Nullable DeploymentRuntime runtime) {
            if (status == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl$DeploymentState", "<init>"));
            }
            this.myStatus = status;
            this.myStatusText = statusText;
            this.myRuntime = runtime;
        }

        @NotNull
        public DeploymentStatus getStatus() {
            DeploymentStatus deploymentStatus = this.myStatus;
            if (deploymentStatus == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/runtime/deployment/DeploymentImpl$DeploymentState", "getStatus"));
            }
            return deploymentStatus;
        }

        @Nullable
        public String getStatusText() {
            return this.myStatusText;
        }

        @Nullable
        public DeploymentRuntime getRuntime() {
            return this.myRuntime;
        }
    }
}

