/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remoteServer.impl.configuration.deployment;

import com.intellij.execution.configurations.RunConfiguration;
import com.intellij.openapi.project.Project;
import com.intellij.packaging.artifacts.Artifact;
import com.intellij.packaging.artifacts.ArtifactPointerManager;
import com.intellij.packaging.impl.run.BuildArtifactsBeforeRunTaskProvider;
import com.intellij.remoteServer.configuration.deployment.ArtifactDeploymentSource;
import com.intellij.remoteServer.configuration.deployment.DeploymentSourceType;
import com.intellij.remoteServer.impl.configuration.deployment.ArtifactDeploymentSourceImpl;
import javax.swing.JComponent;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;

public class ArtifactDeploymentSourceType
extends DeploymentSourceType<ArtifactDeploymentSource> {
    private static final String NAME_ATTRIBUTE = "name";

    public ArtifactDeploymentSourceType() {
        super("artifact");
    }

    @NotNull
    public ArtifactDeploymentSource load(@NotNull Element tag, @NotNull Project project) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/configuration/deployment/ArtifactDeploymentSourceType", "load"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/remoteServer/impl/configuration/deployment/ArtifactDeploymentSourceType", "load"));
        }
        ArtifactDeploymentSourceImpl artifactDeploymentSourceImpl = new ArtifactDeploymentSourceImpl(ArtifactPointerManager.getInstance((Project)project).createPointer(tag.getAttributeValue(NAME_ATTRIBUTE)));
        if (artifactDeploymentSourceImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remoteServer/impl/configuration/deployment/ArtifactDeploymentSourceType", "load"));
        }
        return artifactDeploymentSourceImpl;
    }

    public void save(@NotNull ArtifactDeploymentSource source, @NotNull Element tag) {
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/configuration/deployment/ArtifactDeploymentSourceType", "save"));
        }
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/remoteServer/impl/configuration/deployment/ArtifactDeploymentSourceType", "save"));
        }
        tag.setAttribute(NAME_ATTRIBUTE, source.getArtifactPointer().getArtifactName());
    }

    public void setBuildBeforeRunTask(@NotNull RunConfiguration configuration, @NotNull ArtifactDeploymentSource source) {
        if (configuration == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/configuration/deployment/ArtifactDeploymentSourceType", "setBuildBeforeRunTask"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/remoteServer/impl/configuration/deployment/ArtifactDeploymentSourceType", "setBuildBeforeRunTask"));
        }
        Artifact artifact = source.getArtifact();
        if (artifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRun(configuration.getProject(), configuration, artifact);
        }
    }

    public void updateBuildBeforeRunOption(@NotNull JComponent runConfigurationEditorComponent, @NotNull Project project, @NotNull ArtifactDeploymentSource source, boolean select) {
        if (runConfigurationEditorComponent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remoteServer/impl/configuration/deployment/ArtifactDeploymentSourceType", "updateBuildBeforeRunOption"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/remoteServer/impl/configuration/deployment/ArtifactDeploymentSourceType", "updateBuildBeforeRunOption"));
        }
        if (source == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/remoteServer/impl/configuration/deployment/ArtifactDeploymentSourceType", "updateBuildBeforeRunOption"));
        }
        Artifact artifact = source.getArtifact();
        if (artifact != null) {
            BuildArtifactsBeforeRunTaskProvider.setBuildArtifactBeforeRunOption(runConfigurationEditorComponent, project, artifact, select);
        }
    }
}

