/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.intellij.openapi.util.JDOMExternalizer;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.remote.RemoteSdkProperties;
import java.util.List;
import java.util.Set;
import org.jdom.Element;

public class RemoteSdkPropertiesHolder
implements RemoteSdkProperties {
    private static final String INTERPRETER_PATH = "INTERPRETER_PATH";
    private static final String HELPERS_PATH = "HELPERS_PATH";
    private static final String REMOTE_ROOTS = "REMOTE_ROOTS";
    private static final String REMOTE_PATH = "REMOTE_PATH";
    private static final String INITIALIZED = "INITIALIZED";
    private String mySdkId;
    private String myInterpreterPath;
    private String myHelpersPath;
    private final String myHelpersDefaultDirName;
    private boolean myHelpersVersionChecked = false;
    private Set<String> myRemoteRoots = Sets.newTreeSet();
    private boolean myInitialized = false;

    public RemoteSdkPropertiesHolder(String name) {
        this.myHelpersDefaultDirName = name;
    }

    @Override
    public String getInterpreterPath() {
        return this.myInterpreterPath;
    }

    @Override
    public void setInterpreterPath(String interpreterPath) {
        this.myInterpreterPath = interpreterPath;
    }

    @Override
    public String getHelpersPath() {
        return this.myHelpersPath;
    }

    @Override
    public void setHelpersPath(String helpersPath) {
        this.myHelpersPath = helpersPath;
    }

    @Override
    public String getDefaultHelpersName() {
        return this.myHelpersDefaultDirName;
    }

    @Override
    public void addRemoteRoot(String remoteRoot) {
        this.myRemoteRoots.add(remoteRoot);
    }

    @Override
    public void clearRemoteRoots() {
        this.myRemoteRoots.clear();
    }

    @Override
    public List<String> getRemoteRoots() {
        return Lists.newArrayList(this.myRemoteRoots);
    }

    @Override
    public void setRemoteRoots(List<String> remoteRoots) {
        this.myRemoteRoots = Sets.newTreeSet(remoteRoots);
    }

    @Override
    public boolean isHelpersVersionChecked() {
        return this.myHelpersVersionChecked;
    }

    @Override
    public void setHelpersVersionChecked(boolean helpersVersionChecked) {
        this.myHelpersVersionChecked = helpersVersionChecked;
    }

    @Override
    public void setSdkId(String sdkId) {
        this.mySdkId = sdkId;
    }

    @Override
    public String getSdkId() {
        return this.mySdkId;
    }

    @Override
    public boolean isInitialized() {
        return this.myInitialized;
    }

    @Override
    public void setInitialized(boolean initialized) {
        this.myInitialized = initialized;
    }

    public void copyTo(RemoteSdkProperties copy) {
        copy.setInterpreterPath(this.getInterpreterPath());
        copy.setHelpersPath(this.getHelpersPath());
        copy.setHelpersVersionChecked(this.isHelpersVersionChecked());
        copy.setRemoteRoots(this.getRemoteRoots());
        copy.setInitialized(this.isInitialized());
    }

    public void save(Element rootElement) {
        rootElement.setAttribute(INTERPRETER_PATH, StringUtil.notNullize((String)this.getInterpreterPath()));
        rootElement.setAttribute(HELPERS_PATH, StringUtil.notNullize((String)this.getHelpersPath()));
        rootElement.setAttribute(INITIALIZED, Boolean.toString(this.isInitialized()));
        for (String remoteRoot : this.getRemoteRoots()) {
            Element child = new Element(REMOTE_ROOTS);
            child.setAttribute(REMOTE_PATH, remoteRoot);
            rootElement.addContent(child);
        }
    }

    public void load(Element element) {
        this.setInterpreterPath(StringUtil.nullize((String)element.getAttributeValue(INTERPRETER_PATH)));
        this.setHelpersPath(StringUtil.nullize((String)element.getAttributeValue(HELPERS_PATH)));
        this.setRemoteRoots(JDOMExternalizer.loadStringsList((Element)element, (String)REMOTE_ROOTS, (String)REMOTE_PATH));
        this.setInitialized(StringUtil.parseBoolean((String)element.getAttributeValue(INITIALIZED), (boolean)true));
    }
}

