/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkCredentials;
import com.intellij.remote.RemoteSdkPropertiesHolder;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RemoteSdkCredentialsHolder
extends RemoteCredentialsHolder
implements RemoteSdkCredentials {
    @NotNull
    private final RemoteSdkPropertiesHolder myRemoteSdkProperties;

    public RemoteSdkCredentialsHolder(@NotNull String defaultHelpersDirName) {
        if (defaultHelpersDirName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remote/RemoteSdkCredentialsHolder", "<init>"));
        }
        this.myRemoteSdkProperties = new RemoteSdkPropertiesHolder(defaultHelpersDirName);
    }

    public static String constructSshCredentialsSdkFullPath(@NotNull RemoteSdkCredentials cred) {
        if (cred == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/remote/RemoteSdkCredentialsHolder", "constructSshCredentialsSdkFullPath"));
        }
        return RemoteSdkCredentialsHolder.getCredentialsString(cred) + cred.getInterpreterPath();
    }

    public static String getInterpreterPathFromFullPath(String fullPath) {
        int index;
        if (fullPath.startsWith("ssh://") && (index = (fullPath = fullPath.substring("ssh://".length())).indexOf(":")) != -1 && index < fullPath.length()) {
            fullPath = fullPath.substring(index + 1);
            for (index = 0; index < fullPath.length() && Character.isDigit(fullPath.charAt(index)); ++index) {
            }
            if (index < fullPath.length()) {
                return fullPath.substring(index);
            }
        }
        return fullPath;
    }

    @NotNull
    public RemoteSdkPropertiesHolder getRemoteSdkProperties() {
        RemoteSdkPropertiesHolder remoteSdkPropertiesHolder = this.myRemoteSdkProperties;
        if (remoteSdkPropertiesHolder == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/remote/RemoteSdkCredentialsHolder", "getRemoteSdkProperties"));
        }
        return remoteSdkPropertiesHolder;
    }

    @Override
    public String getInterpreterPath() {
        return this.myRemoteSdkProperties.getInterpreterPath();
    }

    @Override
    public void setInterpreterPath(String interpreterPath) {
        this.myRemoteSdkProperties.setInterpreterPath(interpreterPath);
    }

    @Override
    public String getHelpersPath() {
        return this.myRemoteSdkProperties.getHelpersPath();
    }

    @Override
    public void setHelpersPath(String helpersPath) {
        this.myRemoteSdkProperties.setHelpersPath(helpersPath);
    }

    @Override
    public String getDefaultHelpersName() {
        return this.myRemoteSdkProperties.getDefaultHelpersName();
    }

    @Override
    public void addRemoteRoot(String remoteRoot) {
        this.myRemoteSdkProperties.addRemoteRoot(remoteRoot);
    }

    @Override
    public void clearRemoteRoots() {
        this.myRemoteSdkProperties.clearRemoteRoots();
    }

    @Override
    public List<String> getRemoteRoots() {
        return this.myRemoteSdkProperties.getRemoteRoots();
    }

    @Override
    public void setRemoteRoots(List<String> remoteRoots) {
        this.myRemoteSdkProperties.setRemoteRoots(remoteRoots);
    }

    @Override
    public boolean isHelpersVersionChecked() {
        return this.myRemoteSdkProperties.isHelpersVersionChecked();
    }

    @Override
    public void setHelpersVersionChecked(boolean helpersVersionChecked) {
        this.myRemoteSdkProperties.setHelpersVersionChecked(helpersVersionChecked);
    }

    @Override
    public String getFullInterpreterPath() {
        return RemoteSdkCredentialsHolder.constructSshCredentialsSdkFullPath(this);
    }

    @Override
    public void setSdkId(String sdkId) {
        this.myRemoteSdkProperties.setSdkId(sdkId);
    }

    @Override
    public String getSdkId() {
        return this.myRemoteSdkProperties.getSdkId();
    }

    @Override
    public boolean isInitialized() {
        return this.myRemoteSdkProperties.isInitialized();
    }

    @Override
    public void setInitialized(boolean initialized) {
        this.myRemoteSdkProperties.setInitialized(initialized);
    }

    public static boolean isRemoteSdk(@Nullable String path) {
        if (path != null) {
            return path.startsWith("ssh://") || path.startsWith("vagrant://") || path.startsWith("sftp://");
        }
        return false;
    }

    @Override
    public void load(Element element) {
        super.load(element);
        this.myRemoteSdkProperties.load(element);
    }

    @Override
    public void save(Element rootElement) {
        super.save(rootElement);
        this.myRemoteSdkProperties.save(rootElement);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteSdkCredentialsHolder holder = (RemoteSdkCredentialsHolder)o;
        if (this.isAnonymous() != holder.isAnonymous()) {
            return false;
        }
        if (this.getPort() != holder.getPort()) {
            return false;
        }
        if (this.isStorePassphrase() != holder.isStorePassphrase()) {
            return false;
        }
        if (this.isStorePassword() != holder.isStorePassword()) {
            return false;
        }
        if (this.isUseKeyPair() != holder.isUseKeyPair()) {
            return false;
        }
        if (this.getHost() != null ? !this.getHost().equals(holder.getHost()) : holder.getHost() != null) {
            return false;
        }
        if (this.getKnownHostsFile() != null ? !this.getKnownHostsFile().equals(holder.getKnownHostsFile()) : holder.getKnownHostsFile() != null) {
            return false;
        }
        if (this.getPassphrase() != null ? !this.getPassphrase().equals(holder.getPassphrase()) : holder.getPassphrase() != null) {
            return false;
        }
        if (this.getPassword() != null ? !this.getPassword().equals(holder.getPassword()) : holder.getPassword() != null) {
            return false;
        }
        if (this.getPrivateKeyFile() != null ? !this.getPrivateKeyFile().equals(holder.getPrivateKeyFile()) : holder.getPrivateKeyFile() != null) {
            return false;
        }
        if (this.getUserName() != null ? !this.getUserName().equals(holder.getUserName()) : holder.getUserName() != null) {
            return false;
        }
        return this.myRemoteSdkProperties.equals(holder.myRemoteSdkProperties);
    }

    public int hashCode() {
        int result = this.getHost() != null ? this.getHost().hashCode() : 0;
        result = 31 * result + this.getPort();
        result = 31 * result + (this.isAnonymous() ? 1 : 0);
        result = 31 * result + (this.getUserName() != null ? this.getUserName().hashCode() : 0);
        result = 31 * result + (this.getPassword() != null ? this.getPassword().hashCode() : 0);
        result = 31 * result + (this.isUseKeyPair() ? 1 : 0);
        result = 31 * result + (this.getPrivateKeyFile() != null ? this.getPrivateKeyFile().hashCode() : 0);
        result = 31 * result + (this.getKnownHostsFile() != null ? this.getKnownHostsFile().hashCode() : 0);
        result = 31 * result + (this.getPassphrase() != null ? this.getPassphrase().hashCode() : 0);
        result = 31 * result + (this.isStorePassword() ? 1 : 0);
        result = 31 * result + (this.isStorePassphrase() ? 1 : 0);
        result = 31 * result + this.myRemoteSdkProperties.hashCode();
        return result;
    }

    public String toString() {
        return "RemoteSdkDataHolder{getHost()='" + this.getHost() + '\'' + ", getPort()=" + this.getPort() + ", isAnonymous()=" + this.isAnonymous() + ", getUserName()='" + this.getUserName() + '\'' + ", myInterpreterPath='" + this.getInterpreterPath() + '\'' + ", myHelpersPath='" + this.getHelpersPath() + '\'' + '}';
    }

    public void copyRemoteSdkCredentialsTo(RemoteSdkCredentialsHolder to) {
        super.copyRemoteCredentialsTo(to);
        this.myRemoteSdkProperties.copyTo(to.getRemoteSdkProperties());
    }
}

