/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.remote;

import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.remote.RemoteCredentials;
import com.intellij.remote.RemoteCredentialsHolder;
import com.intellij.remote.RemoteSdkConnectionAcceptor;
import com.intellij.remote.VagrantBasedCredentialsHolder;
import com.intellij.remote.WebDeploymentCredentialsHolder;
import org.jdom.Element;

public class RemoteConnectionCredentialsWrapper {
    public static final String VAGRANT_PREFIX = "vagrant://";
    public static final String SFTP_DEPLOYMENT_PREFIX = "sftp://";
    public final Key<VagrantBasedCredentialsHolder> VAGRANT_BASED_CREDENTIALS = Key.create((String)"VAGRANT_BASED_CREDENTIALS");
    public final Key<WebDeploymentCredentialsHolder> WEB_DEPLOYMENT_BASED_CREDENTIALS = Key.create((String)"WEB_DEPLOYMENT_BASED_CREDENTIALS");
    public final Key<RemoteCredentialsHolder> PLAIN_SSH_CREDENTIALS = Key.create((String)"PLAIN_SSH_CREDENTIALS");
    private UserDataHolderBase myCredentialsTypeHolder = new UserDataHolderBase();

    public void setVagrantConnectionType(VagrantBasedCredentialsHolder vagrantBasedCredentials) {
        this.myCredentialsTypeHolder.putUserData(this.VAGRANT_BASED_CREDENTIALS, (Object)vagrantBasedCredentials);
    }

    private VagrantBasedCredentialsHolder getVagrantCredentials() {
        return (VagrantBasedCredentialsHolder)this.myCredentialsTypeHolder.getUserData(this.VAGRANT_BASED_CREDENTIALS);
    }

    public void setPlainSshCredentials(RemoteCredentialsHolder credentials) {
        this.myCredentialsTypeHolder.putUserData(this.PLAIN_SSH_CREDENTIALS, (Object)credentials);
    }

    private RemoteCredentialsHolder getPlainSshCredentials() {
        return (RemoteCredentialsHolder)this.myCredentialsTypeHolder.getUserData(this.PLAIN_SSH_CREDENTIALS);
    }

    public void setWebDeploymentCredentials(WebDeploymentCredentialsHolder webDeploymentCredentials) {
        this.myCredentialsTypeHolder.putUserData(this.WEB_DEPLOYMENT_BASED_CREDENTIALS, (Object)webDeploymentCredentials);
    }

    private WebDeploymentCredentialsHolder getWebDeploymentCredentials() {
        return (WebDeploymentCredentialsHolder)this.myCredentialsTypeHolder.getUserData(this.WEB_DEPLOYMENT_BASED_CREDENTIALS);
    }

    private boolean isVagrantConnection() {
        return this.getVagrantCredentials() != null;
    }

    private boolean isPlainSshConnection() {
        return this.getPlainSshCredentials() != null;
    }

    private boolean isWebDeploymentConnection() {
        return this.getWebDeploymentCredentials() != null;
    }

    public Object getConnectionKey() {
        if (this.isVagrantConnection()) {
            return this.getVagrantCredentials();
        }
        if (this.isPlainSshConnection()) {
            return this.getPlainSshCredentials();
        }
        if (this.isWebDeploymentConnection()) {
            return this.getWebDeploymentCredentials();
        }
        throw RemoteConnectionCredentialsWrapper.unknownConnectionType();
    }

    public void save(final Element rootElement) {
        this.switchType(new RemoteSdkConnectionAcceptor(){

            @Override
            public void ssh(RemoteCredentialsHolder cred) {
                cred.save(rootElement);
            }

            @Override
            public void vagrant(VagrantBasedCredentialsHolder cred) {
                cred.save(rootElement);
            }

            @Override
            public void deployment(WebDeploymentCredentialsHolder cred) {
                cred.save(rootElement);
            }
        });
    }

    public static IllegalStateException unknownConnectionType() {
        return new IllegalStateException("Unknown connection type");
    }

    public void copyTo(RemoteConnectionCredentialsWrapper copy) {
        copy.myCredentialsTypeHolder = new UserDataHolderBase();
        copy.setPlainSshCredentials(this.getPlainSshCredentials());
        copy.setVagrantConnectionType(this.getVagrantCredentials());
        copy.setWebDeploymentCredentials(this.getWebDeploymentCredentials());
    }

    public String getId() {
        if (this.isVagrantConnection()) {
            VagrantBasedCredentialsHolder cred = this.getVagrantCredentials();
            return VAGRANT_PREFIX + cred.getVagrantFolder();
        }
        if (this.isPlainSshConnection()) {
            RemoteCredentialsHolder cred = this.getPlainSshCredentials();
            return RemoteConnectionCredentialsWrapper.constructSshCredentialsFullPath(cred);
        }
        if (this.isWebDeploymentConnection()) {
            WebDeploymentCredentialsHolder cred = this.getWebDeploymentCredentials();
            return RemoteConnectionCredentialsWrapper.constructSftpCredentialsFullPath(cred.getSshCredentials());
        }
        throw RemoteConnectionCredentialsWrapper.unknownConnectionType();
    }

    private static String constructSftpCredentialsFullPath(RemoteCredentials cred) {
        return SFTP_DEPLOYMENT_PREFIX + cred.getUserName() + "@" + cred.getHost() + ":" + cred.getPort();
    }

    public static String constructSshCredentialsFullPath(RemoteCredentials cred) {
        return "ssh://" + cred.getUserName() + "@" + cred.getHost() + ":" + cred.getPort();
    }

    public void switchType(RemoteSdkConnectionAcceptor acceptor) {
        if (this.isVagrantConnection()) {
            acceptor.vagrant(this.getVagrantCredentials());
        } else if (this.isPlainSshConnection()) {
            acceptor.ssh(this.getPlainSshCredentials());
        } else if (this.isWebDeploymentConnection()) {
            acceptor.deployment(this.getWebDeploymentCredentials());
        } else {
            throw RemoteConnectionCredentialsWrapper.unknownConnectionType();
        }
    }

    public boolean equals(Object obj) {
        if (obj instanceof RemoteConnectionCredentialsWrapper) {
            return this.getId().equals(((RemoteConnectionCredentialsWrapper)obj).getId());
        }
        return false;
    }
}

