/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration.ui;

import com.intellij.find.FindSettings;
import com.intellij.ide.util.scopeChooser.ScopeChooserCombo;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.help.HelpManager;
import com.intellij.openapi.options.ConfigurationException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.LabeledComponent;
import com.intellij.openapi.util.Disposer;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.JavaCodeFragmentFactory;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCodeFragment;
import com.intellij.psi.PsiWildcardType;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.changeSignature.ChangeSignatureUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.TypeMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.ui.RefactoringDialog;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.ui.EditorComboBox;
import com.intellij.util.VisibilityUtil;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TypeMigrationDialog
extends RefactoringDialog {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.typeMigration.ui.TypeMigrationDialog");
    public static final String REFACTORING_NAME = "Type Migration";
    private final EditorComboBox myToTypeEditor;
    private final PsiElement myRoot;
    private TypeMigrationRules myRules;
    private final PsiTypeCodeFragment myTypeCodeFragment;
    private final ScopeChooserCombo myScopeChooserCombo;

    public TypeMigrationDialog(@NotNull Project project, PsiElement root, TypeMigrationRules rules) {
        String[] stringArray;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/typeMigration/ui/TypeMigrationDialog", "<init>"));
        }
        super(project, false);
        this.myRoot = root;
        this.myRules = rules;
        PsiType migrationRootType = rules != null ? rules.getMigrationRootType() : null;
        PsiType rootType = this.getRootType();
        String text = migrationRootType != null ? migrationRootType.getCanonicalText(true) : (rootType != null ? rootType.getCanonicalText(true) : "");
        int flags = 0;
        if (root instanceof PsiParameter) {
            PsiElement scope = ((PsiParameter)root).getDeclarationScope();
            if (scope instanceof PsiMethod) {
                flags |= 2;
            } else if (scope instanceof PsiCatchSection && PsiUtil.getLanguageLevel((PsiElement)root).isAtLeast(LanguageLevel.JDK_1_7)) {
                flags |= 4;
            }
        }
        this.myTypeCodeFragment = JavaCodeFragmentFactory.getInstance((Project)project).createTypeCodeFragment(text, root, true, flags);
        final PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)project);
        final Document document = documentManager.getDocument((PsiFile)this.myTypeCodeFragment);
        assert (document != null);
        this.myToTypeEditor = new EditorComboBox(document, project, (FileType)StdFileTypes.JAVA);
        String[] types = this.getValidTypes(project, root);
        if (types != null) {
            stringArray = types;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = document.getText();
        }
        this.myToTypeEditor.setHistory(stringArray);
        document.addDocumentListener((DocumentListener)new DocumentAdapter(){

            public void documentChanged(DocumentEvent e) {
                documentManager.commitDocument(document);
                TypeMigrationDialog.this.validateButtons();
            }
        });
        this.myScopeChooserCombo = new ScopeChooserCombo(project, false, true, FindSettings.getInstance().getDefaultScopeName());
        Disposer.register((Disposable)this.myDisposable, (Disposable)this.myScopeChooserCombo);
        ((JComboBox)this.myScopeChooserCombo.getChildComponent()).addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                TypeMigrationDialog.this.validateButtons();
            }
        });
        this.init();
        this.setTitle(REFACTORING_NAME);
    }

    public PsiElement getRoot() {
        return this.myRoot;
    }

    @Nullable
    public PsiType getMigrationType() {
        try {
            return this.myTypeCodeFragment.getType();
        }
        catch (PsiTypeCodeFragment.TypeSyntaxException e) {
            LOG.info((Throwable)e);
            return null;
        }
        catch (PsiTypeCodeFragment.NoTypeException e) {
            LOG.info((Throwable)e);
            return null;
        }
    }

    @Nullable
    private String[] getValidTypes(Project project, PsiElement root) {
        PsiModifierList modifierList;
        if ((root instanceof PsiField || root instanceof PsiMethod) && VisibilityUtil.compare((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)(modifierList = ((PsiModifierListOwner)root).getModifierList())), (String)"private") < 0) {
            return null;
        }
        ArrayList<PsiExpression> expressions = new ArrayList<PsiExpression>();
        for (PsiReference reference : ReferencesSearch.search((PsiElement)root, (SearchScope)GlobalSearchScope.fileScope((PsiFile)root.getContainingFile()))) {
            PsiElement element = reference.getElement();
            PsiExpression expr = (PsiExpression)PsiTreeUtil.getParentOfType((PsiElement)element, PsiExpression.class, (boolean)false);
            if (expr == null) continue;
            expressions.add(expr);
        }
        try {
            PsiExpression[] occurrences = expressions.toArray(new PsiExpression[expressions.size()]);
            PsiType[] psiTypes = new TypeSelectorManagerImpl(project, this.myTypeCodeFragment.getType(), occurrences).getTypesForAll();
            if (psiTypes.length > 0) {
                String[] history = new String[psiTypes.length];
                for (int i = 0; i < psiTypes.length; ++i) {
                    PsiType psiType = psiTypes[i];
                    history[i] = psiType.getCanonicalText(true);
                }
                return history;
            }
        }
        catch (PsiTypeCodeFragment.TypeSyntaxException e) {
            LOG.info((Throwable)e);
            return null;
        }
        catch (PsiTypeCodeFragment.NoTypeException e) {
            LOG.info((Throwable)e);
            return null;
        }
        return null;
    }

    @Override
    protected void canRun() throws ConfigurationException {
        if (!TypeMigrationDialog.checkType(this.getMigrationType())) {
            throw new ConfigurationException("'" + this.myTypeCodeFragment.getText() + "' is invalid type");
        }
        if (this.myScopeChooserCombo.getSelectedScope() == null) {
            throw new ConfigurationException("Scope is not chosen");
        }
    }

    private static boolean checkType(PsiType type) {
        if (type == null) {
            return false;
        }
        if (!type.isValid()) {
            return false;
        }
        if (type instanceof PsiClassType) {
            PsiType[] types;
            PsiClassType psiClassType = (PsiClassType)type;
            if (psiClassType.resolve() == null) {
                return false;
            }
            for (PsiType paramType : types = psiClassType.getParameters()) {
                if (paramType instanceof PsiPrimitiveType || paramType instanceof PsiWildcardType && ((PsiWildcardType)paramType).getBound() instanceof PsiPrimitiveType) {
                    return false;
                }
                if (TypeMigrationDialog.checkType(paramType)) continue;
                return false;
            }
        }
        if (type instanceof PsiArrayType) {
            return TypeMigrationDialog.checkType(type.getDeepComponentType());
        }
        return true;
    }

    @Override
    protected void doAction() {
        FindSettings.getInstance().setDefaultScopeName(this.myScopeChooserCombo.getSelectedScopeName());
        PsiType rootType = this.getRootType();
        PsiType migrationType = this.getMigrationType();
        if (migrationType == null || ChangeSignatureUtil.deepTypeEqual(rootType, migrationType)) {
            this.close(0);
            return;
        }
        if (this.myRules == null) {
            this.myRules = new TypeMigrationRules(rootType);
            this.myRules.setMigrationRootType(migrationType);
            this.myRules.setBoundScope(this.myScopeChooserCombo.getSelectedScope());
        }
        this.invokeRefactoring(new TypeMigrationProcessor(this.myProject, this.myRoot, this.myRules));
    }

    @Nullable
    private PsiType getRootType() {
        return TypeMigrationLabeler.getElementType(this.myRoot);
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new GridBagLayout());
        GridBagConstraints gc = new GridBagConstraints(0, -1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 0, 0), 0, 0);
        PsiType type = this.getRootType();
        String typeText = type != null ? type.getPresentableText() : "<unknown>";
        panel.add((Component)new JLabel("Migrate " + TypeMigrationDialog.getElementPresentation(this.myRoot) + " \"" + typeText + "\" to"), gc);
        panel.add((Component)this.myToTypeEditor, gc);
        LabeledComponent scopeChooserComponent = new LabeledComponent();
        scopeChooserComponent.setComponent((JComponent)((Object)this.myScopeChooserCombo));
        scopeChooserComponent.setText("Choose scope where change signature may occur");
        panel.add((Component)scopeChooserComponent, gc);
        return panel;
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myToTypeEditor;
    }

    private static String getElementPresentation(PsiElement element) {
        if (element instanceof PsiMethod) {
            return "return type of method " + ((PsiMethod)element).getName();
        }
        if (element instanceof PsiField) {
            return "type of field " + ((PsiField)element).getName();
        }
        if (element instanceof PsiLocalVariable) {
            return "type of variable " + ((PsiLocalVariable)element).getName();
        }
        if (element instanceof PsiReferenceParameterList) {
            return "class type arguments ";
        }
        if (element instanceof PsiParameter) {
            PsiParameter param = (PsiParameter)element;
            String result = "type of parameter " + param.getName();
            if (param.getParent() instanceof PsiParameterList) {
                PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)param, PsiMethod.class);
                assert (method != null);
                result = result + " of method " + method.getName();
            }
            return result;
        }
        return element.toString();
    }

    protected void doHelpAction() {
        HelpManager.getInstance().invokeHelp("reference.typeMigrationDialog");
    }
}

