/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiType;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeMigrationLabeler;
import com.intellij.refactoring.typeMigration.rules.DisjunctionTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.RootTypeConversionRule;
import com.intellij.refactoring.typeMigration.rules.TypeConversionRule;
import com.intellij.util.containers.ContainerUtil;
import java.util.LinkedList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.Nullable;

public class TypeMigrationRules {
    private final LinkedList<TypeConversionRule> myConversionRules = new LinkedList();
    private final PsiType myRootType;
    private PsiType myMigrationRootType;
    private SearchScope mySearchScope;

    public TypeMigrationRules(PsiType root) {
        this.myRootType = root;
        this.myConversionRules.add(new RootTypeConversionRule());
        this.myConversionRules.add(new DisjunctionTypeConversionRule());
        ContainerUtil.addAll(this.myConversionRules, (Object[])Extensions.getExtensions(TypeConversionRule.EP_NAME));
    }

    public void setMigrationRootType(PsiType migrationRootType) {
        this.myMigrationRootType = migrationRootType;
    }

    public PsiType getRootType() {
        return this.myRootType;
    }

    public PsiType getMigrationRootType() {
        return this.myMigrationRootType;
    }

    public void addConversionDescriptor(TypeConversionRule rule) {
        this.myConversionRules.add(rule);
    }

    @NonNls
    @Nullable
    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, boolean isCovariantPosition, TypeMigrationLabeler labeler) {
        TypeConversionDescriptorBase conversion = this.findConversion(from, to, member, context, labeler);
        if (conversion != null) {
            return conversion;
        }
        if (isCovariantPosition) {
            if (to instanceof PsiEllipsisType && TypeConversionUtil.isAssignable((PsiType)((PsiEllipsisType)to).getComponentType(), (PsiType)from)) {
                return new TypeConversionDescriptorBase();
            }
            if (TypeConversionUtil.isAssignable((PsiType)to, (PsiType)from)) {
                return new TypeConversionDescriptorBase();
            }
        }
        return !isCovariantPosition && TypeConversionUtil.isAssignable((PsiType)from, (PsiType)to) ? new TypeConversionDescriptorBase() : null;
    }

    @Nullable
    public TypeConversionDescriptorBase findConversion(PsiType from, PsiType to, PsiMember member, PsiExpression context, TypeMigrationLabeler labeler) {
        for (TypeConversionRule descriptor : this.myConversionRules) {
            TypeConversionDescriptorBase conversion = descriptor.findConversion(from, to, member, context, labeler);
            if (conversion == null) continue;
            return conversion;
        }
        return null;
    }

    public void setBoundScope(SearchScope searchScope) {
        this.mySearchScope = searchScope;
    }

    public SearchScope getSearchScope() {
        return this.mySearchScope;
    }

    @Nullable
    public Pair<PsiType, PsiType> bindTypeParameters(PsiType from, PsiType to, PsiMethod method, PsiExpression context, TypeMigrationLabeler labeler) {
        for (TypeConversionRule conversionRule : this.myConversionRules) {
            Pair<PsiType, PsiType> typePair = conversionRule.bindTypeParameters(from, to, method, context, labeler);
            if (typePair == null) continue;
            return typePair;
        }
        return null;
    }
}

