/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.typeMigration;

import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnchor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCapturedWildcardType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.javadoc.PsiDocTagValue;
import com.intellij.psi.search.PsiSearchScopeUtil;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.typeMigration.ClassTypeArgumentMigrationProcessor;
import com.intellij.refactoring.typeMigration.TypeConversionDescriptorBase;
import com.intellij.refactoring.typeMigration.TypeEvaluator;
import com.intellij.refactoring.typeMigration.TypeMigrationReplacementUtil;
import com.intellij.refactoring.typeMigration.TypeMigrationRules;
import com.intellij.refactoring.typeMigration.TypeMigrationStatementProcessor;
import com.intellij.refactoring.typeMigration.Util;
import com.intellij.refactoring.typeMigration.usageInfo.OverridenUsageInfo;
import com.intellij.refactoring.typeMigration.usageInfo.OverriderUsageInfo;
import com.intellij.refactoring.typeMigration.usageInfo.TypeMigrationUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.Query;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.Nullable;

public class TypeMigrationLabeler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.typeMigration.TypeMigrationLabeler");
    private boolean myShowWarning = true;
    private MigrateException myException;
    private final TypeMigrationRules myRules;
    private TypeEvaluator myTypeEvaluator;
    private final LinkedHashMap<PsiElement, Object> myConversions;
    private final HashSet<Pair<PsiAnchor, PsiType>> myFailedConversions;
    private LinkedList<Pair<TypeMigrationUsageInfo, PsiType>> myMigrationRoots;
    private final LinkedHashMap<TypeMigrationUsageInfo, PsiType> myNewExpressionTypeChange;
    private final LinkedHashMap<TypeMigrationUsageInfo, PsiClassType> myClassTypeArgumentsChange;
    private TypeMigrationUsageInfo[] myMigratedUsages = null;
    private TypeMigrationUsageInfo myCurrentRoot;
    private final Map<TypeMigrationUsageInfo, HashSet<Pair<TypeMigrationUsageInfo, PsiType>>> myRootsTree = new HashMap<TypeMigrationUsageInfo, HashSet<Pair<TypeMigrationUsageInfo, PsiType>>>();
    private final Map<Pair<TypeMigrationUsageInfo, TypeMigrationUsageInfo>, Set<PsiElement>> myRootUsagesTree = new HashMap<Pair<TypeMigrationUsageInfo, TypeMigrationUsageInfo>, Set<PsiElement>>();
    private final Set<TypeMigrationUsageInfo> myProcessedRoots = new HashSet<TypeMigrationUsageInfo>();

    public TypeMigrationRules getRules() {
        return this.myRules;
    }

    public TypeMigrationLabeler(TypeMigrationRules rules) {
        this.myRules = rules;
        this.myConversions = new LinkedHashMap();
        this.myFailedConversions = new HashSet();
        this.myNewExpressionTypeChange = new LinkedHashMap();
        this.myClassTypeArgumentsChange = new LinkedHashMap();
    }

    public boolean hasFailedConversions() {
        return this.myFailedConversions.size() > 0;
    }

    public String[] getFailedConversionsReport() {
        String[] report = new String[this.myFailedConversions.size()];
        int j = 0;
        for (Pair<PsiAnchor, PsiType> p : this.myFailedConversions) {
            PsiElement element = ((PsiAnchor)p.getFirst()).retrieve();
            LOG.assertTrue(element != null);
            PsiType type = ((PsiExpression)element).getType();
            report[j++] = "Cannot convert type of expression <b>" + StringUtil.escapeXml((String)element.getText()) + "</b>" + (type != null ? " from <b>" + StringUtil.escapeXml((String)type.getCanonicalText()) + "</b>" + " to <b>" + StringUtil.escapeXml((String)((PsiType)p.getSecond()).getCanonicalText()) + "</b>" : "") + "<br>";
        }
        return report;
    }

    public UsageInfo[] getFailedUsages() {
        ArrayList<1> usages = new ArrayList<1>(this.myFailedConversions.size());
        for (final Pair<PsiAnchor, PsiType> p : this.myFailedConversions) {
            final PsiExpression expr = (PsiExpression)((PsiAnchor)p.getFirst()).retrieve();
            if (expr == null) continue;
            usages.add(new UsageInfo((PsiElement)expr){

                @Nullable
                public String getTooltipText() {
                    PsiType type;
                    PsiType psiType = type = expr.isValid() ? expr.getType() : null;
                    if (type == null) {
                        return null;
                    }
                    return "Cannot convert type of the expression from " + type.getCanonicalText() + " to " + ((PsiType)p.getSecond()).getCanonicalText();
                }
            });
        }
        return usages.toArray(new UsageInfo[usages.size()]);
    }

    public TypeMigrationUsageInfo[] getMigratedUsages() {
        LinkedList<Pair<TypeMigrationUsageInfo, PsiType>> declarations = this.getTypeEvaluator().getMigratedDeclarations();
        TypeMigrationUsageInfo[] usages = new TypeMigrationUsageInfo[declarations.size() + this.myConversions.size() + this.myNewExpressionTypeChange.size() + this.myClassTypeArgumentsChange.size()];
        int j = 0;
        ArrayList<PsiElement> conversionExprs = new ArrayList<PsiElement>(this.myConversions.keySet());
        Collections.sort(conversionExprs, new Comparator<PsiElement>(){

            @Override
            public int compare(PsiElement e1, PsiElement e2) {
                return e2.getTextRange().getStartOffset() - e1.getTextRange().getStartOffset();
            }
        });
        for (final PsiElement psiElement : conversionExprs) {
            final Object conv = this.myConversions.get(psiElement);
            usages[j++] = new TypeMigrationUsageInfo(psiElement){

                public String getTooltipText() {
                    if (conv instanceof String) {
                        String conversion = (String)conv;
                        return "Replaced with " + conversion.replaceAll("\\$", psiElement.getText());
                    }
                    return "Replaced with " + conv.toString();
                }

                @Override
                public boolean isExcluded() {
                    if (conv instanceof TypeConversionDescriptorBase) {
                        return ((TypeConversionDescriptorBase)conv).getRoot().isExcluded();
                    }
                    return super.isExcluded();
                }
            };
        }
        for (Pair pair : declarations) {
            TypeMigrationUsageInfo element = (TypeMigrationUsageInfo)((Object)pair.getFirst());
            usages[j++] = element;
        }
        for (TypeMigrationUsageInfo typeMigrationUsageInfo : this.myClassTypeArgumentsChange.keySet()) {
            usages[j++] = typeMigrationUsageInfo;
        }
        for (TypeMigrationUsageInfo typeMigrationUsageInfo : this.myNewExpressionTypeChange.keySet()) {
            usages[j++] = typeMigrationUsageInfo;
        }
        return usages;
    }

    public void change(TypeMigrationUsageInfo usageInfo) {
        PsiElement element = usageInfo.getElement();
        if (element == null) {
            return;
        }
        Project project = element.getProject();
        if (element instanceof PsiExpression) {
            Object conversion;
            PsiExpression expression = (PsiExpression)element;
            if (element instanceof PsiNewExpression) {
                for (Map.Entry<TypeMigrationUsageInfo, PsiType> info : this.myNewExpressionTypeChange.entrySet()) {
                    PsiElement expressionToReplace = info.getKey().getElement();
                    if (!expression.equals(expressionToReplace)) continue;
                    TypeMigrationReplacementUtil.replaceNewExpressionType(project, (PsiNewExpression)expressionToReplace, info);
                }
            }
            if ((conversion = this.myConversions.get(element)) != null) {
                this.myConversions.remove(element);
                TypeMigrationReplacementUtil.replaceExpression(expression, project, conversion);
            }
        } else if (element instanceof PsiReferenceParameterList) {
            for (Map.Entry<TypeMigrationUsageInfo, PsiClassType> entry : this.myClassTypeArgumentsChange.entrySet()) {
                if (!element.equals(entry.getKey().getElement())) continue;
                PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
                try {
                    element.getParent().replace((PsiElement)factory.createReferenceElementByType(entry.getValue()));
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        } else {
            TypeMigrationReplacementUtil.migratePsiMemberType(element, project, this.getTypeEvaluator().getType(usageInfo));
        }
    }

    @Nullable
    Object getConversion(PsiElement element) {
        return this.myConversions.get(element);
    }

    public TypeMigrationUsageInfo[] getMigratedUsages(boolean autoMigrate, PsiElement ... roots) {
        if (this.myMigratedUsages == null) {
            this.myShowWarning = autoMigrate;
            this.migrate(autoMigrate, roots);
            this.myMigratedUsages = this.getMigratedUsages();
        }
        return this.myMigratedUsages;
    }

    @Nullable
    public Set<PsiElement> getTypeUsages(TypeMigrationUsageInfo element, TypeMigrationUsageInfo currentRoot) {
        return this.myRootUsagesTree.get(Pair.create((Object)((Object)element), (Object)((Object)currentRoot)));
    }

    void convertExpression(PsiExpression expr, PsiType toType, PsiType fromType, boolean isCovariantPosition) {
        TypeConversionDescriptorBase conversion = this.myRules.findConversion(fromType, toType, (PsiMember)(expr instanceof PsiMethodCallExpression ? ((PsiMethodCallExpression)expr).resolveMethod() : null), expr, isCovariantPosition, this);
        if (conversion == null) {
            this.markFailedConversion((Pair<PsiType, PsiType>)new Pair((Object)fromType, (Object)toType), expr);
        } else {
            this.setConversionMapping(expr, conversion);
        }
    }

    public void migrateExpressionType(PsiExpression expr, PsiType migrationType, PsiElement place, boolean alreadyProcessed, boolean isCovariant) {
        PsiType originalType = expr.getType();
        if (originalType == null || originalType.equals(migrationType)) {
            return;
        }
        if (originalType.equals(PsiType.NULL)) {
            if (migrationType instanceof PsiPrimitiveType) {
                this.markFailedConversion((Pair<PsiType, PsiType>)new Pair((Object)originalType, (Object)migrationType), expr);
            }
            return;
        }
        if (!(expr instanceof PsiConditionalExpression)) {
            if (expr instanceof PsiClassObjectAccessExpression) {
                if (!TypeConversionUtil.isAssignable((PsiType)migrationType, (PsiType)expr.getType())) {
                    this.markFailedConversion((Pair<PsiType, PsiType>)new Pair((Object)expr.getType(), (Object)migrationType), expr);
                    return;
                }
            } else {
                if (expr instanceof PsiArrayInitializerExpression && migrationType instanceof PsiArrayType) {
                    PsiExpression[] initializers;
                    for (PsiExpression initializer : initializers = ((PsiArrayInitializerExpression)expr).getInitializers()) {
                        this.migrateExpressionType(initializer, ((PsiArrayType)migrationType).getComponentType(), (PsiElement)expr, alreadyProcessed, true);
                    }
                    this.getTypeEvaluator().setType(new TypeMigrationUsageInfo((PsiElement)expr), migrationType);
                    return;
                }
                if (expr instanceof PsiArrayAccessExpression) {
                    this.migrateExpressionType(((PsiArrayAccessExpression)expr).getArrayExpression(), (PsiType)migrationType.createArrayType(), place, alreadyProcessed, isCovariant);
                    return;
                }
                if (expr instanceof PsiReferenceExpression) {
                    PsiElement resolved = ((PsiReferenceExpression)expr).resolve();
                    if (resolved != null && !this.addMigrationRoot(resolved, migrationType, place, alreadyProcessed, !isCovariant)) {
                        this.convertExpression(expr, migrationType, this.getTypeEvaluator().evaluateType(expr), isCovariant);
                    }
                    return;
                }
                if (expr instanceof PsiMethodCallExpression) {
                    PsiMethod resolved = ((PsiMethodCallExpression)expr).resolveMethod();
                    if (resolved != null && !this.addMigrationRoot((PsiElement)resolved, migrationType, place, alreadyProcessed, !isCovariant)) {
                        this.convertExpression(expr, migrationType, this.getTypeEvaluator().evaluateType(expr), isCovariant);
                    }
                    return;
                }
                if (expr instanceof PsiNewExpression && originalType.getArrayDimensions() == migrationType.getArrayDimensions()) {
                    if (migrationType.getArrayDimensions() > 0) {
                        PsiType elemenType = ((PsiArrayType)migrationType).getComponentType();
                        PsiArrayInitializerExpression arrayInitializer = ((PsiNewExpression)expr).getArrayInitializer();
                        if (arrayInitializer != null) {
                            PsiExpression[] initializers = arrayInitializer.getInitializers();
                            for (int i = initializers.length - 1; i >= 0; --i) {
                                this.migrateExpressionType(initializers[i], elemenType, place, alreadyProcessed, true);
                            }
                        }
                        if (TypeMigrationLabeler.isGenericsArrayType(elemenType)) {
                            this.markFailedConversion((Pair<PsiType, PsiType>)new Pair((Object)originalType, (Object)migrationType), expr);
                            return;
                        }
                        this.myNewExpressionTypeChange.put(new TypeMigrationUsageInfo((PsiElement)expr), migrationType);
                        this.getTypeEvaluator().setType(new TypeMigrationUsageInfo((PsiElement)expr), migrationType);
                        return;
                    }
                    if (migrationType instanceof PsiClassType && originalType instanceof PsiClassType && ((PsiClassType)migrationType).rawType().isAssignableFrom((PsiType)((PsiClassType)originalType).rawType())) {
                        PsiType type;
                        PsiClass originalClass = PsiUtil.resolveClassInType((PsiType)originalType);
                        if (originalClass instanceof PsiAnonymousClass) {
                            originalType = ((PsiAnonymousClass)originalClass).getBaseClassType();
                        }
                        if ((type = TypeEvaluator.substituteType(migrationType, originalType, true, ((PsiClassType)originalType).resolveGenerics().getElement(), (PsiType)JavaPsiFacade.getElementFactory((Project)expr.getProject()).createType(((PsiClassType)originalType).resolve(), PsiSubstitutor.EMPTY))) != null) {
                            this.myNewExpressionTypeChange.put(new TypeMigrationUsageInfo((PsiElement)expr), type);
                            this.getTypeEvaluator().setType(new TypeMigrationUsageInfo((PsiElement)expr), type);
                            return;
                        }
                    }
                }
            }
        }
        this.convertExpression(expr, migrationType, originalType, isCovariant);
    }

    private static boolean isGenericsArrayType(PsiType elemenType) {
        if (elemenType instanceof PsiClassType && ((PsiClassType)elemenType).hasParameters()) {
            return true;
        }
        if (elemenType instanceof PsiArrayType) {
            PsiType componentType = ((PsiArrayType)elemenType).getComponentType();
            return TypeMigrationLabeler.isGenericsArrayType(componentType);
        }
        return false;
    }

    boolean addMigrationRoot(PsiElement element, PsiType type, PsiElement place, boolean alreadyProcessed, boolean isContraVariantPosition) {
        return this.addMigrationRoot(element, type, place, alreadyProcessed, isContraVariantPosition, false);
    }

    boolean addMigrationRoot(PsiElement element, PsiType type, PsiElement place, boolean alreadyProcessed, boolean isContraVariantPosition, boolean userDefinedType) {
        if (type.equals(PsiType.NULL)) {
            return false;
        }
        PsiElement resolved = Util.normalizeElement(element);
        SearchScope searchScope = this.myRules.getSearchScope();
        if (!resolved.isPhysical() || !PsiSearchScopeUtil.isInScope((SearchScope)searchScope, (PsiElement)resolved)) {
            return false;
        }
        PsiType originalType = TypeMigrationLabeler.getElementType(resolved);
        LOG.assertTrue(originalType != null);
        PsiType psiType = type = userDefinedType ? type : TypeEvaluator.substituteType(type, originalType, isContraVariantPosition);
        if (!userDefinedType && TypeMigrationLabeler.typeContainsTypeParameters(originalType)) {
            return false;
        }
        if (type instanceof PsiCapturedWildcardType) {
            return false;
        }
        if (resolved instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)resolved;
            PsiMethod[] methods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method, (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY);
            OverridenUsageInfo overridenUsageInfo = new OverridenUsageInfo((PsiElement)method);
            OverriderUsageInfo[] overriders = new OverriderUsageInfo[methods.length];
            for (int i = -1; i < methods.length; ++i) {
                TypeMigrationUsageInfo m;
                if (i < 0) {
                    m = overridenUsageInfo;
                } else {
                    overriders[i] = new OverriderUsageInfo((PsiElement)methods[i], method);
                    m = overriders[i];
                }
                alreadyProcessed = this.addRoot(m, type, place, alreadyProcessed);
            }
            overridenUsageInfo.setOverriders(overriders);
            return !alreadyProcessed;
        }
        if (resolved instanceof PsiParameter && ((PsiParameter)resolved).getDeclarationScope() instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)((PsiParameter)resolved).getDeclarationScope();
            int index = method.getParameterList().getParameterIndex((PsiParameter)resolved);
            PsiMethod[] methods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method, (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY);
            OverriderUsageInfo[] overriders = new OverriderUsageInfo[methods.length];
            OverridenUsageInfo overridenUsageInfo = new OverridenUsageInfo((PsiElement)method.getParameterList().getParameters()[index]);
            for (int i = -1; i < methods.length; ++i) {
                TypeMigrationUsageInfo paramUsageInfo;
                PsiMethod m = i < 0 ? method : methods[i];
                PsiParameter p = m.getParameterList().getParameters()[index];
                if (i < 0) {
                    paramUsageInfo = overridenUsageInfo;
                } else {
                    overriders[i] = new OverriderUsageInfo((PsiElement)p, method);
                    paramUsageInfo = overriders[i];
                }
                alreadyProcessed = this.addRoot(paramUsageInfo, type, place, alreadyProcessed);
            }
            overridenUsageInfo.setOverriders(overriders);
            return !alreadyProcessed;
        }
        return !this.addRoot(new TypeMigrationUsageInfo(resolved), type, place, alreadyProcessed);
    }

    static boolean typeContainsTypeParameters(PsiType originalType) {
        if (originalType instanceof PsiClassType) {
            PsiClassType psiClassType = (PsiClassType)originalType;
            if (psiClassType.resolve() instanceof PsiTypeParameter) {
                return true;
            }
            for (PsiType paramType : psiClassType.getParameters()) {
                if (!(paramType instanceof PsiClassType) || !(((PsiClassType)paramType).resolve() instanceof PsiTypeParameter)) continue;
                return true;
            }
        }
        return false;
    }

    @Nullable
    public static PsiType getElementType(PsiElement resolved) {
        if (resolved instanceof PsiVariable) {
            return ((PsiVariable)resolved).getType();
        }
        if (resolved instanceof PsiMethod) {
            return ((PsiMethod)resolved).getReturnType();
        }
        if (resolved instanceof PsiExpression) {
            return ((PsiExpression)resolved).getType();
        }
        if (resolved instanceof PsiReferenceParameterList) {
            PsiElement parent = resolved.getParent();
            while (parent != null) {
                PsiSubstitutor classSubstitutor;
                LOG.assertTrue(parent instanceof PsiJavaCodeReferenceElement);
                PsiClass psiClass = (PsiClass)((PsiJavaCodeReferenceElement)parent).resolve();
                PsiClass containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)parent, PsiClass.class);
                if (psiClass != null && containingClass != null && (classSubstitutor = TypeConversionUtil.getClassSubstitutor((PsiClass)psiClass, (PsiClass)containingClass, (PsiSubstitutor)PsiSubstitutor.EMPTY)) != null) {
                    return JavaPsiFacade.getElementFactory((Project)parent.getProject()).createType(psiClass, classSubstitutor);
                }
                parent = PsiTreeUtil.getParentOfType((PsiElement)parent, PsiJavaCodeReferenceElement.class, (boolean)true);
            }
        } else if (resolved instanceof PsiClass) {
            return JavaPsiFacade.getElementFactory((Project)resolved.getProject()).createType((PsiClass)resolved, PsiSubstitutor.EMPTY);
        }
        return null;
    }

    boolean addRoot(TypeMigrationUsageInfo usageInfo, PsiType type, PsiElement place, boolean alreadyProcessed) {
        if (this.myShowWarning && this.myMigrationRoots.size() > 10 && !ApplicationManager.getApplication().isUnitTestMode()) {
            this.myShowWarning = false;
            try {
                Runnable checkTimeToStopRunnable = new Runnable(){

                    @Override
                    public void run() {
                        if (Messages.showYesNoCancelDialog((String)"Found more than 10 roots to migrate. Do you want to preview?", (String)"Type Migration", (Icon)Messages.getWarningIcon()) == 0) {
                            TypeMigrationLabeler.this.myException = new MigrateException();
                        }
                    }
                };
                SwingUtilities.invokeLater(checkTimeToStopRunnable);
            }
            catch (Exception e) {
                // empty catch block
            }
        }
        if (this.myException != null) {
            throw this.myException;
        }
        this.rememberRootTrace(usageInfo, type, place, alreadyProcessed);
        if (!alreadyProcessed && !this.getTypeEvaluator().setType(usageInfo, type)) {
            alreadyProcessed = true;
        }
        if (!alreadyProcessed) {
            this.myMigrationRoots.addFirst((Pair<TypeMigrationUsageInfo, PsiType>)new Pair((Object)usageInfo, (Object)type));
        }
        return alreadyProcessed;
    }

    private void rememberRootTrace(TypeMigrationUsageInfo usageInfo, PsiType type, PsiElement place, boolean alreadyProcessed) {
        if (this.myCurrentRoot != null) {
            if (!alreadyProcessed) {
                this.myProcessedRoots.add(usageInfo);
            }
            if (this.myProcessedRoots.contains((Object)usageInfo)) {
                HashSet<Object> infos = this.myRootsTree.get((Object)this.myCurrentRoot);
                if (infos == null) {
                    infos = new HashSet();
                    this.myRootsTree.put(this.myCurrentRoot, infos);
                }
                infos.add((Pair<TypeMigrationUsageInfo, PsiType>)Pair.create((Object)((Object)usageInfo), (Object)type));
            }
            if (!(usageInfo instanceof OverriderUsageInfo)) {
                this.setTypeUsage(usageInfo, place);
            }
        }
    }

    private void setTypeUsage(TypeMigrationUsageInfo usageInfo, PsiElement place) {
        if (place != null) {
            Pair rooted = Pair.create((Object)((Object)usageInfo), (Object)((Object)this.myCurrentRoot));
            Set<PsiElement> usages = this.myRootUsagesTree.get(rooted);
            if (usages == null) {
                usages = new HashSet<PsiElement>();
                this.myRootUsagesTree.put((Pair<TypeMigrationUsageInfo, TypeMigrationUsageInfo>)rooted, usages);
            }
            usages.add(place);
        }
    }

    public void setTypeUsage(PsiElement element, PsiElement place) {
        this.setTypeUsage(new TypeMigrationUsageInfo(element), place);
    }

    void markFailedConversion(Pair<PsiType, PsiType> typePair, PsiExpression expression) {
        LOG.assertTrue(typePair.getSecond() != null);
        this.myFailedConversions.add((Pair<PsiAnchor, PsiType>)new Pair((Object)PsiAnchor.create((PsiElement)expression), typePair.getSecond()));
    }

    void setConversionMapping(PsiExpression expression, Object obj) {
        if (this.myConversions.get(expression) != null) {
            return;
        }
        if (obj instanceof TypeConversionDescriptorBase) {
            ((TypeConversionDescriptorBase)obj).setRoot(this.myCurrentRoot);
        }
        this.myConversions.put((PsiElement)expression, obj);
    }

    public PsiReference[] markRootUsages(PsiElement element, PsiType migrationType) {
        return this.markRootUsages(element, migrationType, (PsiReference[])ReferencesSearch.search((PsiElement)element, (SearchScope)this.myRules.getSearchScope(), (boolean)false).toArray((Object[])new PsiReference[0]));
    }

    PsiReference[] markRootUsages(PsiElement element, PsiType migrationType, PsiReference[] refs) {
        ArrayList<PsiReference> validReferences = new ArrayList<PsiReference>();
        for (PsiReference ref1 : refs) {
            PsiElement ref = ref1.getElement();
            if (ref == null) continue;
            if (element instanceof PsiMethod) {
                PsiElement parent = Util.getEssentialParent(ref);
                if (!(parent instanceof PsiMethodCallExpression)) continue;
                this.getTypeEvaluator().setType(new TypeMigrationUsageInfo(parent), migrationType);
            } else if (element instanceof PsiVariable) {
                if (ref instanceof PsiReferenceExpression) {
                    this.getTypeEvaluator().setType(new TypeMigrationUsageInfo(ref), PsiImplUtil.normalizeWildcardTypeByPosition(migrationType, (PsiExpression)((PsiReferenceExpression)ref)));
                }
            } else {
                LOG.error("Method call expression or reference expression expected but found " + element.getClass().getName());
                continue;
            }
            validReferences.add(ref1);
        }
        Collections.sort(validReferences, new Comparator<PsiReference>(){

            @Override
            public int compare(PsiReference o1, PsiReference o2) {
                return o1.getElement().getTextOffset() - o2.getElement().getTextOffset();
            }
        });
        return validReferences.toArray(new PsiReference[validReferences.size()]);
    }

    public void migrateRoot(PsiElement root, PsiType migrationType, PsiReference[] usages) {
        if (root instanceof PsiMethod) {
            this.migrateMethodReturnExpression(migrationType, (PsiMethod)root);
        } else if (root instanceof PsiParameter && ((PsiParameter)root).getDeclarationScope() instanceof PsiMethod) {
            this.migrateMethodCallExpressions(migrationType, (PsiParameter)root, null);
        } else if (root instanceof PsiVariable || root instanceof PsiExpression) {
            PsiElement element = TypeMigrationLabeler.getContainingStatement(root);
            element.accept((PsiElementVisitor)new TypeMigrationStatementProcessor(element, this));
        } else if (root instanceof PsiReferenceParameterList) {
            this.myClassTypeArgumentsChange.put(new TypeMigrationUsageInfo(root), (PsiClassType)migrationType);
            new ClassTypeArgumentMigrationProcessor(this).migrateClassTypeParameter((PsiReferenceParameterList)root, migrationType);
        }
        HashSet<PsiElement> processed = new HashSet<PsiElement>();
        for (PsiReference usage : usages) {
            this.migrateRootUsageExpression(usage, processed);
        }
    }

    private static PsiElement getContainingStatement(PsiElement root) {
        PsiStatement statement = (PsiStatement)PsiTreeUtil.getParentOfType((PsiElement)root, PsiStatement.class);
        PsiField field = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)root, PsiField.class);
        return statement != null ? statement : (field != null ? field : root);
    }

    void migrateRootUsageExpression(PsiReference usage, Set<PsiElement> processed) {
        PsiElement element;
        PsiElement ref = usage.getElement();
        if (ref != null && ref.getLanguage() == JavaLanguage.INSTANCE && (element = TypeMigrationLabeler.getContainingStatement(ref)) != null && !processed.contains(element)) {
            processed.add(element);
            element.accept((PsiElementVisitor)new TypeMigrationStatementProcessor(ref, this));
        }
    }

    void migrateMethodCallExpressions(PsiType migrationType, PsiParameter param, PsiClass psiClass) {
        boolean checkNumberOfArguments = false;
        if (param.getType() instanceof PsiEllipsisType && !(migrationType instanceof PsiEllipsisType)) {
            checkNumberOfArguments = true;
        }
        PsiType strippedType = migrationType instanceof PsiEllipsisType ? ((PsiEllipsisType)migrationType).getComponentType() : migrationType;
        PsiMethod method = (PsiMethod)param.getDeclarationScope();
        PsiParameterList parameterList = method.getParameterList();
        int parametersCount = parameterList.getParametersCount();
        int index = parameterList.getParameterIndex(param);
        List<PsiReference> refs = TypeMigrationLabeler.filterReferences(psiClass, (Query<PsiReference>)ReferencesSearch.search((PsiElement)method, (SearchScope)method.getUseScope().intersectWith(this.myRules.getSearchScope()), (boolean)false));
        for (PsiReference ref1 : refs) {
            PsiElement ref = ref1.getElement();
            PsiElement parent = Util.getEssentialParent(ref);
            if (parent instanceof PsiCallExpression) {
                PsiExpressionList argumentList = ((PsiCallExpression)parent).getArgumentList();
                if (argumentList == null) continue;
                PsiExpression[] expressions = argumentList.getExpressions();
                if (checkNumberOfArguments && parametersCount != expressions.length) {
                    this.markFailedConversion((Pair<PsiType, PsiType>)new Pair((Object)param.getType(), (Object)migrationType), (PsiExpression)((PsiCallExpression)parent));
                }
                if (index <= -1 || index >= expressions.length) continue;
                for (int idx = index; idx < (param.isVarArgs() ? expressions.length : index + 1); ++idx) {
                    PsiExpression actual = expressions[idx];
                    PsiType type = this.getTypeEvaluator().evaluateType(actual);
                    if (type == null) continue;
                    this.migrateExpressionType(actual, strippedType, parent, TypeConversionUtil.isAssignable((PsiType)strippedType, (PsiType)type), true);
                }
                continue;
            }
            if (!(ref instanceof PsiDocTagValue)) continue;
            this.myConversions.put(ref, method);
        }
    }

    private void migrateMethodReturnExpression(final PsiType migrationType, PsiMethod method) {
        PsiCodeBlock block = method.getBody();
        if (block != null) {
            block.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReturnStatement(PsiReturnStatement statement) {
                    PsiType type;
                    PsiExpression value = statement.getReturnValue();
                    if (value != null && (type = TypeMigrationLabeler.this.getTypeEvaluator().evaluateType(value)) != null && !type.equals(migrationType)) {
                        TypeMigrationLabeler.this.migrateExpressionType(value, migrationType, (PsiElement)statement, TypeConversionUtil.isAssignable((PsiType)migrationType, (PsiType)type), true);
                    }
                }
            });
        }
    }

    private void iterate() {
        LinkedList roots = (LinkedList)this.myMigrationRoots.clone();
        this.myMigrationRoots = new LinkedList();
        PsiReference[][] cachedUsages = new PsiReference[roots.size()][];
        int j = 0;
        for (Pair p : roots) {
            cachedUsages[j++] = this.markRootUsages(((TypeMigrationUsageInfo)((Object)p.getFirst())).getElement(), (PsiType)p.getSecond());
        }
        j = 0;
        for (Pair root : roots) {
            this.myCurrentRoot = (TypeMigrationUsageInfo)((Object)root.getFirst());
            this.migrateRoot(((TypeMigrationUsageInfo)((Object)root.getFirst())).getElement(), (PsiType)root.getSecond(), cachedUsages[j++]);
        }
    }

    private void migrate(boolean autoMigrate, PsiElement ... victims) {
        this.myMigrationRoots = new LinkedList();
        this.myTypeEvaluator = new TypeEvaluator(this.myMigrationRoots, this);
        PsiType rootType = this.myRules.getMigrationRootType();
        for (PsiElement victim : victims) {
            this.addMigrationRoot(victim, rootType, null, false, true, true);
        }
        if (autoMigrate) {
            while (this.myMigrationRoots.size() > 0) {
                this.iterate();
            }
        }
    }

    public TypeEvaluator getTypeEvaluator() {
        return this.myTypeEvaluator;
    }

    public Map<TypeMigrationUsageInfo, HashSet<Pair<TypeMigrationUsageInfo, PsiType>>> getRootsTree() {
        return this.myRootsTree;
    }

    public void setCurrentRoot(TypeMigrationUsageInfo currentRoot) {
        this.myCurrentRoot = currentRoot;
    }

    public LinkedList<Pair<TypeMigrationUsageInfo, PsiType>> getMigrationRoots() {
        return this.myMigrationRoots;
    }

    public static List<PsiReference> filterReferences(PsiClass psiClass, Query<PsiReference> memberReferences) {
        ArrayList<PsiReference> refs = new ArrayList<PsiReference>();
        for (PsiReference memberReference : memberReferences) {
            if (psiClass == null) {
                refs.add(memberReference);
                continue;
            }
            PsiElement referencedElement = memberReference.getElement();
            if (!(referencedElement instanceof PsiReferenceExpression)) continue;
            PsiExpression qualifierExpression = ((PsiReferenceExpression)referencedElement).getQualifierExpression();
            if (qualifierExpression != null) {
                PsiType qualifierType = qualifierExpression.getType();
                if (!(qualifierType instanceof PsiClassType) || psiClass != ((PsiClassType)qualifierType).resolve()) continue;
                refs.add(memberReference);
                continue;
            }
            if (psiClass != PsiTreeUtil.getParentOfType((PsiElement)referencedElement, PsiClass.class)) continue;
            refs.add(memberReference);
        }
        return refs;
    }

    public String getMigrationReport() {
        StringBuilder buffer = new StringBuilder();
        buffer.append("Types:\n").append(this.getTypeEvaluator().getReport()).append("\n");
        buffer.append("Conversions:\n");
        String[] conversions = new String[this.myConversions.size()];
        int k = 0;
        for (PsiElement expr : this.myConversions.keySet()) {
            Object conversion = this.myConversions.get(expr);
            if (conversion instanceof Pair && ((Pair)conversion).first == null) {
                conversions[k++] = expr.getText() + " -> " + ((Pair)conversion).second + "\n";
                continue;
            }
            conversions[k++] = expr.getText() + " -> " + conversion + "\n";
        }
        Arrays.sort(conversions, new Comparator<String>(){

            @Override
            public int compare(String x, String y) {
                return x.compareTo(y);
            }
        });
        for (String conversion : conversions) {
            buffer.append(conversion);
        }
        buffer.append("\nNew expression type changes:\n");
        String[] newChanges = new String[this.myNewExpressionTypeChange.size()];
        k = 0;
        for (Map.Entry<TypeMigrationUsageInfo, PsiType> entry : this.myNewExpressionTypeChange.entrySet()) {
            PsiElement element = entry.getKey().getElement();
            newChanges[k++] = (element != null ? element.getText() : entry.getKey()) + " -> " + entry.getValue().getCanonicalText() + "\n";
        }
        Arrays.sort(newChanges, new Comparator<String>(){

            @Override
            public int compare(String x, String y) {
                return x.compareTo(y);
            }
        });
        for (String change : newChanges) {
            buffer.append(change);
        }
        buffer.append("Fails:\n");
        ArrayList<Pair<PsiAnchor, PsiType>> failsList = new ArrayList<Pair<PsiAnchor, PsiType>>(this.myFailedConversions);
        Collections.sort(failsList, new Comparator<Pair<PsiAnchor, PsiType>>(){

            @Override
            public int compare(Pair<PsiAnchor, PsiType> o1, Pair<PsiAnchor, PsiType> o2) {
                PsiElement element1 = ((PsiAnchor)o1.getFirst()).retrieve();
                PsiElement element2 = ((PsiAnchor)o2.getFirst()).retrieve();
                if (element1 == null || element2 == null) {
                    return 0;
                }
                return element1.getText().compareTo(element2.getText());
            }
        });
        for (Pair<PsiAnchor, PsiType> p : failsList) {
            PsiElement element = ((PsiAnchor)p.getFirst()).retrieve();
            if (element == null) continue;
            buffer.append(element.getText()).append("->").append(((PsiType)p.getSecond()).getCanonicalText()).append("\n");
        }
        return buffer.toString();
    }

    public static class MigrateException
    extends RuntimeException {
    }
}

