/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.replaceConstructorWithBuilder;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.replaceConstructorWithBuilder.ReplaceConstructorWithBuilderDialog;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ReplaceConstructorWithBuilderHandler
implements RefactoringActionHandler {
    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/replaceConstructorWithBuilder/ReplaceConstructorWithBuilderHandler", "invoke"));
        }
        int offset = editor.getCaretModel().getOffset();
        PsiElement element = file.findElementAt(offset);
        PsiClass psiClass = ReplaceConstructorWithBuilderHandler.getParentNamedClass(element);
        if (psiClass == null) {
            ReplaceConstructorWithBuilderHandler.showErrorMessage("The caret should be positioned inside a class which constructors are to be replaced with builder.", project, editor);
            return;
        }
        PsiMethod[] constructors = psiClass.getConstructors();
        if (constructors.length == 0) {
            ReplaceConstructorWithBuilderHandler.showErrorMessage("Current class doesn't have constructors to replace with builder.", project, editor);
            return;
        }
        new ReplaceConstructorWithBuilderDialog(project, constructors).show();
    }

    @Nullable
    public static PsiClass getParentNamedClass(PsiElement element) {
        PsiElement resolve;
        PsiElement parent;
        if (element != null && (parent = element.getParent()) instanceof PsiJavaCodeReferenceElement && (resolve = ((PsiJavaCodeReferenceElement)parent).resolve()) instanceof PsiClass) {
            return (PsiClass)resolve;
        }
        PsiClass psiClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)element, PsiClass.class);
        if (psiClass instanceof PsiAnonymousClass) {
            return ReplaceConstructorWithBuilderHandler.getParentNamedClass((PsiElement)psiClass);
        }
        return psiClass;
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/replaceConstructorWithBuilder/ReplaceConstructorWithBuilderHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/replaceConstructorWithBuilder/ReplaceConstructorWithBuilderHandler", "invoke"));
        }
        throw new UnsupportedOperationException();
    }

    private static void showErrorMessage(String message, Project project, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)"Replace Constructor with Builder", (String)"refactoring.replaceConstructorWithBuilder");
    }
}

