/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.project.Project;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.impl.file.PsiDirectoryFactory;
import com.intellij.refactoring.rename.RenameInputValidatorEx;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.Nullable;

public class PsiPackageRenameValidator
implements RenameInputValidatorEx {
    @Nullable
    public String getErrorMessage(String newName, Project project) {
        if (FileTypeManager.getInstance().isFileIgnored(newName)) {
            return "Trying to create a package with ignored name, result will not be visible";
        }
        if (newName.length() > 0) {
            if (!PsiDirectoryFactory.getInstance(project).isValidPackageName(newName)) {
                return "Not a valid package name";
            }
            if (!JavaPsiFacade.getInstance((Project)project).getNameHelper().isIdentifier(newName)) {
                return "Not a valid identifier name";
            }
        }
        return null;
    }

    public ElementPattern<? extends PsiElement> getPattern() {
        return PlatformPatterns.psiElement(PsiPackage.class);
    }

    public boolean isInputValid(String newName, PsiElement element, ProcessingContext context) {
        return newName != null && newName.length() > 0;
    }
}

