/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.rename;

import com.intellij.featureStatistics.FeatureUsageTracker;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.actionSystem.DataKey;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.SyntheticElement;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.meta.PsiMetaOwner;
import com.intellij.psi.meta.PsiWritableMetaData;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.actions.BaseRefactoringAction;
import com.intellij.refactoring.rename.RenameDialog;
import com.intellij.refactoring.rename.RenameHandler;
import com.intellij.refactoring.rename.RenamePsiElementProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.usageView.UsageViewUtil;
import java.util.Arrays;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiElementRenameHandler
implements RenameHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.rename.PsiElementRenameHandler");
    public static final ExtensionPointName<Condition<PsiElement>> VETO_RENAME_CONDITION_EP = ExtensionPointName.create((String)"com.intellij.vetoRenameCondition");
    public static DataKey<String> DEFAULT_NAME = DataKey.create((String)"DEFAULT_NAME");

    public void invoke(@NotNull Project project, Editor editor, PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/rename/PsiElementRenameHandler", "invoke"));
        }
        PsiElement element = PsiElementRenameHandler.getElement(dataContext);
        if (element == null) {
            element = BaseRefactoringAction.getElementAtCaret(editor, file);
        }
        editor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
        PsiElement nameSuggestionContext = InjectedLanguageUtil.findElementAtNoCommit(file, editor.getCaretModel().getOffset());
        PsiElementRenameHandler.invoke(element, project, nameSuggestionContext, editor);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        PsiElement element;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/rename/PsiElementRenameHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/rename/PsiElementRenameHandler", "invoke"));
        }
        PsiElement psiElement = element = elements.length == 1 ? elements[0] : null;
        if (element == null) {
            element = PsiElementRenameHandler.getElement(dataContext);
        }
        LOG.assertTrue(element != null);
        Editor editor = (Editor)CommonDataKeys.EDITOR.getData(dataContext);
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            String newName = (String)DEFAULT_NAME.getData(dataContext);
            LOG.assertTrue(newName != null);
            PsiElementRenameHandler.rename(element, project, element, editor, newName);
        } else {
            PsiElementRenameHandler.invoke(element, project, element, editor);
        }
    }

    public static void invoke(PsiElement element, Project project, PsiElement nameSuggestionContext, Editor editor) {
        if (element != null && !PsiElementRenameHandler.canRename(project, editor, element)) {
            return;
        }
        if (nameSuggestionContext != null && nameSuggestionContext.isPhysical() && !PsiManager.getInstance((Project)project).isInProject(nameSuggestionContext)) {
            String message = "Selected element is used from non-project files. These usages won't be renamed. Proceed anyway?";
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                throw new CommonRefactoringUtil.RefactoringErrorHintException("Selected element is used from non-project files. These usages won't be renamed. Proceed anyway?");
            }
            if (Messages.showYesNoDialog((Project)project, (String)"Selected element is used from non-project files. These usages won't be renamed. Proceed anyway?", (String)RefactoringBundle.getCannotRefactorMessage(null), (Icon)Messages.getWarningIcon()) != 0) {
                return;
            }
        }
        FeatureUsageTracker.getInstance().triggerFeatureUsed("refactoring.rename");
        PsiElementRenameHandler.rename(element, project, nameSuggestionContext, editor);
    }

    static boolean canRename(Project project, Editor editor, PsiElement element) throws CommonRefactoringUtil.RefactoringErrorHintException {
        String message = PsiElementRenameHandler.renameabilityStatus(project, element);
        if (message != null) {
            if (!message.isEmpty()) {
                PsiElementRenameHandler.showErrorMessage(project, editor, message);
            }
            return false;
        }
        return true;
    }

    @Nullable
    static String renameabilityStatus(Project project, PsiElement element) {
        boolean hasWritableMetaData;
        if (element == null) {
            return "";
        }
        boolean hasRenameProcessor = RenamePsiElementProcessor.forElement(element) != RenamePsiElementProcessor.DEFAULT;
        boolean bl = hasWritableMetaData = element instanceof PsiMetaOwner && ((PsiMetaOwner)element).getMetaData() instanceof PsiWritableMetaData;
        if (!(hasRenameProcessor || hasWritableMetaData || element instanceof PsiNamedElement)) {
            return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.wrong.caret.position.symbol.to.rename"));
        }
        if (!PsiManager.getInstance((Project)project).isInProject(element)) {
            if (element.isPhysical()) {
                String message = RefactoringBundle.message((String)"error.out.of.project.element", (Object[])new Object[]{UsageViewUtil.getType(element)});
                return RefactoringBundle.getCannotRefactorMessage((String)message);
            }
            if (!element.isWritable()) {
                return RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"error.cannot.be.renamed"));
            }
        }
        if (InjectedLanguageUtil.isInInjectedLanguagePrefixSuffix(element)) {
            String message = RefactoringBundle.message((String)"error.in.injected.lang.prefix.suffix", (Object[])new Object[]{UsageViewUtil.getType(element)});
            return RefactoringBundle.getCannotRefactorMessage((String)message);
        }
        return null;
    }

    static void showErrorMessage(Project project, @Nullable Editor editor, String message) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)RefactoringBundle.message((String)"rename.title"), null);
    }

    public static void rename(PsiElement element, Project project, PsiElement nameSuggestionContext, Editor editor) {
        PsiElementRenameHandler.rename(element, project, nameSuggestionContext, editor, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void rename(PsiElement element, Project project, PsiElement nameSuggestionContext, Editor editor, String defaultName) {
        RenamePsiElementProcessor processor = RenamePsiElementProcessor.forElement(element);
        PsiElement substituted = processor.substituteElementToRename(element, editor);
        if (substituted == null || !PsiElementRenameHandler.canRename(project, editor, substituted)) {
            return;
        }
        RenameDialog dialog = processor.createRenameDialog(project, substituted, nameSuggestionContext, editor);
        if (defaultName == null && ApplicationManager.getApplication().isUnitTestMode()) {
            Object[] strings = dialog.getSuggestedNames();
            if (strings != null && strings.length > 0) {
                Arrays.sort(strings);
                defaultName = strings[0];
            } else {
                defaultName = "undefined";
            }
        }
        if (defaultName != null) {
            try {
                dialog.performRename((String)defaultName);
            }
            finally {
                dialog.close(1);
            }
        } else {
            dialog.show();
        }
    }

    public boolean isAvailableOnDataContext(DataContext dataContext) {
        return !PsiElementRenameHandler.isVetoed(PsiElementRenameHandler.getElement(dataContext));
    }

    public static boolean isVetoed(PsiElement element) {
        if (element == null || element instanceof SyntheticElement) {
            return true;
        }
        for (Condition condition : (Condition[])Extensions.getExtensions(VETO_RENAME_CONDITION_EP)) {
            if (!condition.value((Object)element)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public static PsiElement getElement(DataContext dataContext) {
        PsiElement[] elementArray = BaseRefactoringAction.getPsiElementArray(dataContext);
        if (elementArray.length != 1) {
            return null;
        }
        return elementArray[0];
    }

    public boolean isRenaming(DataContext dataContext) {
        return this.isAvailableOnDataContext(dataContext);
    }
}

