/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPackage;
import com.intellij.refactoring.PackageWrapper;
import com.intellij.refactoring.move.moveClassesOrPackages.AutocreatingMoveDestination;
import com.intellij.refactoring.util.RefactoringUtil;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.MultiMap;
import java.util.Collection;
import org.jetbrains.annotations.Nullable;

public class MultipleRootsMoveDestination
extends AutocreatingMoveDestination {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MultipleRootsMoveDestination");

    public MultipleRootsMoveDestination(PackageWrapper aPackage) {
        super(aPackage);
    }

    @Override
    public PackageWrapper getTargetPackage() {
        return this.myPackage;
    }

    @Override
    public PsiDirectory getTargetDirectory(PsiDirectory source) throws IncorrectOperationException {
        return this.getOrCreateDirectoryForSource(source.getVirtualFile());
    }

    @Override
    public PsiDirectory getTargetDirectory(PsiFile source) throws IncorrectOperationException {
        return this.getOrCreateDirectoryForSource(source.getVirtualFile());
    }

    public PsiDirectory getTargetIfExists(PsiFile source) {
        return this.findTargetDirectoryForSource(source.getVirtualFile());
    }

    public String verify(PsiFile source) {
        VirtualFile sourceRootForFile;
        VirtualFile virtualFile = source.getVirtualFile();
        if (virtualFile.isDirectory()) {
            virtualFile = virtualFile.getParent();
            LOG.assertTrue(virtualFile.isDirectory());
        }
        if ((sourceRootForFile = this.myFileIndex.getSourceRootForFile(virtualFile)) == null) {
            return "";
        }
        return this.checkCanCreateInSourceRoot(sourceRootForFile);
    }

    @Nullable
    public String verify(PsiDirectory source) {
        VirtualFile virtualFile = source.getVirtualFile();
        VirtualFile sourceRootForFile = this.myFileIndex.getSourceRootForFile(virtualFile);
        if (sourceRootForFile == null) {
            return "";
        }
        if (virtualFile.equals(sourceRootForFile)) {
            return null;
        }
        return this.checkCanCreateInSourceRoot(sourceRootForFile);
    }

    @Nullable
    public String verify(PsiPackage source) {
        PsiDirectory[] directories;
        for (PsiDirectory directory : directories = source.getDirectories()) {
            String s = this.verify(directory);
            if (s == null) continue;
            return s;
        }
        return null;
    }

    public void analyzeModuleConflicts(Collection<PsiElement> elements, MultiMap<PsiElement, String> conflicts, UsageInfo[] usages) {
    }

    public boolean isTargetAccessible(Project project, VirtualFile place) {
        return true;
    }

    public PsiDirectory getTargetIfExists(PsiDirectory source) {
        return this.findTargetDirectoryForSource(source.getVirtualFile());
    }

    private PsiDirectory findTargetDirectoryForSource(VirtualFile file) {
        VirtualFile sourceRoot = this.myFileIndex.getSourceRootForFile(file);
        LOG.assertTrue(sourceRoot != null);
        return RefactoringUtil.findPackageDirectoryInSourceRoot(this.myPackage, sourceRoot);
    }

    private PsiDirectory getOrCreateDirectoryForSource(VirtualFile file) throws IncorrectOperationException {
        VirtualFile sourceRoot = this.myFileIndex.getSourceRootForFile(file);
        LOG.assertTrue(sourceRoot != null);
        return RefactoringUtil.createPackageDirectoryInSourceRoot(this.myPackage, sourceRoot);
    }
}

