/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.move.moveClassesOrPackages;

import com.intellij.codeInsight.ChangeContextUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.JavaProjectRootsUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCompiledElement;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.util.FileTypeUtils;
import com.intellij.refactoring.move.moveClassesOrPackages.MoveClassesOrPackagesUtil;
import com.intellij.refactoring.move.moveFilesOrDirectories.MoveFileHandler;
import com.intellij.refactoring.util.MoveRenameUsageInfo;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class MoveJavaFileHandler
extends MoveFileHandler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.move.moveClassesOrPackages.MoveJavaFileHandler");

    @Override
    public boolean canProcessElement(PsiFile element) {
        return element instanceof PsiJavaFile && !FileTypeUtils.isInServerPageFile((PsiElement)element) && !JavaProjectRootsUtil.isOutsideJavaSourceRoot(element) && !(element instanceof PsiCompiledElement);
    }

    @Override
    public void prepareMovedFile(PsiFile file, PsiDirectory moveDestination, Map<PsiElement, PsiElement> oldToNewMap) {
        PsiJavaFile javaFile = (PsiJavaFile)file;
        ChangeContextUtil.encodeContextInfo((PsiElement)javaFile, true);
        for (PsiClass psiClass : javaFile.getClasses()) {
            oldToNewMap.put((PsiElement)psiClass, (PsiElement)MoveClassesOrPackagesUtil.doMoveClass(psiClass, moveDestination));
        }
    }

    @Override
    public List<UsageInfo> findUsages(PsiFile psiFile, PsiDirectory newParent, boolean searchInComments, boolean searchInNonJavaFiles) {
        ArrayList<UsageInfo> result = new ArrayList<UsageInfo>();
        PsiPackage newParentPackage = JavaDirectoryService.getInstance().getPackage(newParent);
        String qualifiedName = newParentPackage == null ? "" : newParentPackage.getQualifiedName();
        for (PsiClass aClass : ((PsiJavaFile)psiFile).getClasses()) {
            Collections.addAll(result, MoveClassesOrPackagesUtil.findUsages((PsiElement)aClass, searchInComments, searchInNonJavaFiles, StringUtil.getQualifiedName((String)qualifiedName, (String)aClass.getName())));
        }
        return result.isEmpty() ? null : result;
    }

    @Override
    public void retargetUsages(List<UsageInfo> usageInfos, Map<PsiElement, PsiElement> oldToNewMap) {
        for (UsageInfo usage : usageInfos) {
            if (!(usage instanceof MoveRenameUsageInfo)) continue;
            MoveRenameUsageInfo moveRenameUsage = (MoveRenameUsageInfo)usage;
            PsiElement oldElement = moveRenameUsage.getReferencedElement();
            PsiElement newElement = oldToNewMap.get(oldElement);
            PsiReference reference = moveRenameUsage.getReference();
            if (reference == null) continue;
            try {
                LOG.assertTrue(newElement != null, oldElement != null ? oldElement : reference);
                reference.bindToElement(newElement);
            }
            catch (IncorrectOperationException ex) {
                LOG.error((Throwable)ex);
            }
        }
    }

    @Override
    public void updateMovedFile(PsiFile file) throws IncorrectOperationException {
        PsiPackage aPackage;
        ChangeContextUtil.decodeContextInfo((PsiElement)file, null, null);
        PsiDirectory containingDirectory = file.getContainingDirectory();
        if (containingDirectory != null && (aPackage = JavaDirectoryService.getInstance().getPackage(containingDirectory)) != null) {
            PsiPackageStatement filePackageStatement;
            PsiPackageStatement packageStatement;
            String qualifiedName = aPackage.getQualifiedName();
            PsiNameHelper helper = JavaPsiFacade.getInstance((Project)file.getProject()).getNameHelper();
            PsiPackageStatement psiPackageStatement = packageStatement = !StringUtil.isEmptyOrSpaces((String)qualifiedName) && helper.isQualifiedName(qualifiedName) ? JavaPsiFacade.getElementFactory((Project)file.getProject()).createPackageStatement(qualifiedName) : null;
            if (file instanceof PsiJavaFile && (filePackageStatement = ((PsiJavaFile)file).getPackageStatement()) != null) {
                if (packageStatement != null) {
                    filePackageStatement.getPackageReference().replace((PsiElement)packageStatement.getPackageReference());
                } else {
                    filePackageStatement.delete();
                }
            }
        }
    }
}

