/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceVariable;

import com.intellij.codeInsight.intention.impl.TypeExpression;
import com.intellij.codeInsight.template.TemplateBuilderImpl;
import com.intellij.openapi.actionSystem.Shortcut;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.command.impl.StartMarkAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.keymap.Keymap;
import com.intellij.openapi.keymap.KeymapManager;
import com.intellij.openapi.keymap.KeymapUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.vfs.ReadonlyStatusHandler;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartTypePointer;
import com.intellij.psi.SmartTypePointerManager;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.impl.source.tree.injected.InjectedLanguageUtil;
import com.intellij.psi.scope.processor.VariablesProcessor;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.introduce.inplace.InplaceVariableIntroducer;
import com.intellij.refactoring.introduceParameter.AbstractJavaInplaceIntroducer;
import com.intellij.refactoring.introduceVariable.FinalListener;
import com.intellij.refactoring.introduceVariable.IntroduceVariableBase;
import com.intellij.refactoring.introduceVariable.ReassignVariableUtil;
import com.intellij.refactoring.rename.ResolveSnapshotProvider;
import com.intellij.refactoring.rename.inplace.VariableInplaceRenamer;
import com.intellij.refactoring.ui.TypeSelectorManagerImpl;
import com.intellij.ui.NonFocusableCheckBox;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.List;
import javax.swing.Box;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaVariableInplaceIntroducer
extends InplaceVariableIntroducer<PsiExpression> {
    protected final Project myProject;
    private final SmartPsiElementPointer<PsiDeclarationStatement> myPointer;
    private JCheckBox myCanBeFinalCb;
    private final boolean myCantChangeFinalModifier;
    private final String myTitle;
    private String myExpressionText;
    protected final SmartTypePointer myDefaultType;
    protected final TypeExpression myExpression;
    private ResolveSnapshotProvider.ResolveSnapshot myConflictResolver;

    public JavaVariableInplaceIntroducer(Project project, TypeExpression expression, Editor editor, @NotNull PsiVariable elementToRename, boolean cantChangeFinalModifier, boolean hasTypeSuggestion, RangeMarker exprMarker, List<RangeMarker> occurrenceMarkers, String title) {
        if (elementToRename == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/refactoring/introduceVariable/JavaVariableInplaceIntroducer", "<init>"));
        }
        super((PsiNamedElement)elementToRename, editor, project, title, (PsiElement[])new PsiExpression[0], null);
        this.myProject = project;
        this.myCantChangeFinalModifier = cantChangeFinalModifier;
        this.myTitle = title;
        this.setExprMarker(exprMarker);
        this.setOccurrenceMarkers(occurrenceMarkers);
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)elementToRename, PsiDeclarationStatement.class);
        this.myPointer = declarationStatement != null ? SmartPointerManager.getInstance((Project)project).createSmartPsiElementPointer((PsiElement)declarationStatement) : null;
        editor.putUserData(ReassignVariableUtil.DECLARATION_KEY, this.myPointer);
        if (occurrenceMarkers != null) {
            ArrayList<RangeMarker> rangeMarkers = new ArrayList<RangeMarker>(occurrenceMarkers);
            rangeMarkers.add(exprMarker);
            editor.putUserData(ReassignVariableUtil.OCCURRENCES_KEY, (Object)rangeMarkers.toArray(new RangeMarker[rangeMarkers.size()]));
        }
        this.myExpression = expression;
        PsiType defaultType = elementToRename.getType();
        this.myDefaultType = SmartTypePointerManager.getInstance((Project)project).createSmartTypePointer(defaultType);
        this.setAdvertisementText(JavaVariableInplaceIntroducer.getAdvertisementText(declarationStatement, defaultType, hasTypeSuggestion));
    }

    public void initInitialText(String text) {
        this.myExpressionText = text;
    }

    @Override
    protected StartMarkAction startRename() throws StartMarkAction.AlreadyStartedException {
        return StartMarkAction.start(this.myEditor, this.myProject, this.getCommandName());
    }

    @Override
    protected void beforeTemplateStart() {
        super.beforeTemplateStart();
        ResolveSnapshotProvider resolveSnapshotProvider = (ResolveSnapshotProvider)VariableInplaceRenamer.INSTANCE.forLanguage(this.myScope.getLanguage());
        this.myConflictResolver = resolveSnapshotProvider != null ? resolveSnapshotProvider.createSnapshot(this.myScope) : null;
    }

    @Nullable
    protected PsiVariable getVariable() {
        PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)this.myPointer.getElement();
        if (declarationStatement != null) {
            PsiElement[] declaredElements = declarationStatement.getDeclaredElements();
            return declaredElements.length == 0 ? null : (PsiVariable)declaredElements[0];
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void moveOffsetAfter(boolean success) {
        try {
            if (success) {
                Document document = this.myEditor.getDocument();
                final PsiVariable psiVariable = this.getVariable();
                if (psiVariable == null) {
                    return;
                }
                LOG.assertTrue(psiVariable.isValid());
                TypeSelectorManagerImpl.typeSelected(psiVariable.getType(), this.myDefaultType.getType());
                if (this.myCanBeFinalCb != null) {
                    JavaRefactoringSettings.getInstance().INTRODUCE_LOCAL_CREATE_FINALS = psiVariable.hasModifierProperty("final");
                }
                JavaVariableInplaceIntroducer.adjustLine(psiVariable, document);
                int startOffset = this.getExprMarker() != null && this.getExprMarker().isValid() ? this.getExprMarker().getStartOffset() : psiVariable.getTextOffset();
                final PsiFile file = psiVariable.getContainingFile();
                PsiReference referenceAt = file.findReferenceAt(startOffset);
                if (referenceAt != null && referenceAt.resolve() instanceof PsiVariable) {
                    startOffset = referenceAt.getElement().getTextRange().getEndOffset();
                } else {
                    PsiDeclarationStatement declarationStatement = (PsiDeclarationStatement)PsiTreeUtil.getParentOfType((PsiElement)psiVariable, PsiDeclarationStatement.class);
                    if (declarationStatement != null) {
                        startOffset = declarationStatement.getTextRange().getEndOffset();
                    }
                }
                this.myEditor.getCaretModel().moveToOffset(startOffset);
                this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        if (psiVariable.getInitializer() != null) {
                            JavaVariableInplaceIntroducer.appendTypeCasts(JavaVariableInplaceIntroducer.this.getOccurrenceMarkers(), file, JavaVariableInplaceIntroducer.this.myProject, psiVariable);
                        }
                        if (JavaVariableInplaceIntroducer.this.myConflictResolver != null && JavaVariableInplaceIntroducer.this.myInsertedName != null && JavaVariableInplaceIntroducer.this.isIdentifier(JavaVariableInplaceIntroducer.this.myInsertedName, psiVariable.getLanguage())) {
                            JavaVariableInplaceIntroducer.this.myConflictResolver.apply(psiVariable.getName());
                        }
                    }
                });
            } else {
                RangeMarker exprMarker = this.getExprMarker();
                if (exprMarker != null && exprMarker.isValid()) {
                    this.myEditor.getCaretModel().moveToOffset(exprMarker.getStartOffset());
                    this.myEditor.getScrollingModel().scrollToCaret(ScrollType.MAKE_VISIBLE);
                }
                if (this.myExpressionText != null) {
                    if (!ReadonlyStatusHandler.ensureDocumentWritable((Project)this.myProject, (Document)InjectedLanguageUtil.getTopLevelEditor(this.myEditor).getDocument())) {
                        return;
                    }
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            PsiElement[] vars;
                            PsiDeclarationStatement element = (PsiDeclarationStatement)JavaVariableInplaceIntroducer.this.myPointer.getElement();
                            if (element != null && (vars = element.getDeclaredElements()).length > 0 && vars[0] instanceof PsiVariable) {
                                PsiFile containingFile = element.getContainingFile();
                                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)JavaVariableInplaceIntroducer.this.myProject);
                                RangeMarker exprMarker = JavaVariableInplaceIntroducer.this.getExprMarker();
                                if (exprMarker != null) {
                                    JavaVariableInplaceIntroducer.this.myExpr = (PsiElement)AbstractJavaInplaceIntroducer.restoreExpression(containingFile, (PsiVariable)vars[0], elementFactory, exprMarker, JavaVariableInplaceIntroducer.this.myExpressionText);
                                    if (JavaVariableInplaceIntroducer.this.myExpr != null && ((PsiExpression)JavaVariableInplaceIntroducer.this.myExpr).isPhysical()) {
                                        JavaVariableInplaceIntroducer.this.myExprMarker = JavaVariableInplaceIntroducer.this.createMarker(JavaVariableInplaceIntroducer.this.myExpr);
                                    }
                                }
                                List<RangeMarker> markers = JavaVariableInplaceIntroducer.this.getOccurrenceMarkers();
                                for (RangeMarker occurrenceMarker : markers) {
                                    if (JavaVariableInplaceIntroducer.this.getExprMarker() != null && occurrenceMarker.getStartOffset() == JavaVariableInplaceIntroducer.this.getExprMarker().getStartOffset() && JavaVariableInplaceIntroducer.this.myExpr != null) continue;
                                    AbstractJavaInplaceIntroducer.restoreExpression(containingFile, (PsiVariable)vars[0], elementFactory, occurrenceMarker, JavaVariableInplaceIntroducer.this.myExpressionText);
                                }
                                PsiExpression initializer = ((PsiVariable)vars[0]).getInitializer();
                                if (initializer != null && Comparing.strEqual((String)initializer.getText(), (String)JavaVariableInplaceIntroducer.this.myExpressionText) && JavaVariableInplaceIntroducer.this.myExpr == null) {
                                    element.replace((PsiElement)JavaPsiFacade.getInstance((Project)JavaVariableInplaceIntroducer.this.myProject).getElementFactory().createStatementFromText(JavaVariableInplaceIntroducer.this.myExpressionText, (PsiElement)element));
                                } else {
                                    element.delete();
                                }
                            }
                        }
                    });
                }
            }
        }
        finally {
            this.myEditor.putUserData(ReassignVariableUtil.DECLARATION_KEY, null);
            for (RangeMarker occurrenceMarker : this.getOccurrenceMarkers()) {
                occurrenceMarker.dispose();
            }
            this.myEditor.putUserData(ReassignVariableUtil.OCCURRENCES_KEY, null);
            if (this.getExprMarker() != null) {
                this.getExprMarker().dispose();
            }
        }
    }

    @Override
    @Nullable
    protected JComponent getComponent() {
        if (this.myCantChangeFinalModifier) {
            return null;
        }
        this.myCanBeFinalCb = new NonFocusableCheckBox("Declare final");
        this.myCanBeFinalCb.setSelected(this.createFinals());
        this.myCanBeFinalCb.setMnemonic('f');
        final FinalListener finalListener = new FinalListener(this.myEditor);
        this.myCanBeFinalCb.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                new WriteCommandAction(JavaVariableInplaceIntroducer.this.myProject, JavaVariableInplaceIntroducer.this.getCommandName(), JavaVariableInplaceIntroducer.this.getCommandName(), new PsiFile[0]){

                    protected void run(Result result) throws Throwable {
                        PsiDocumentManager.getInstance((Project)JavaVariableInplaceIntroducer.this.myProject).commitDocument(JavaVariableInplaceIntroducer.this.myEditor.getDocument());
                        PsiVariable variable = JavaVariableInplaceIntroducer.this.getVariable();
                        if (variable != null) {
                            finalListener.perform(JavaVariableInplaceIntroducer.this.myCanBeFinalCb.isSelected(), variable);
                        }
                    }
                }.execute();
            }
        });
        JPanel panel = new JPanel(new GridBagLayout());
        panel.setBorder(null);
        if (this.myCanBeFinalCb != null) {
            panel.add((Component)this.myCanBeFinalCb, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 18, 2, new Insets(5, 5, 5, 5), 0, 0));
        }
        panel.add((Component)Box.createVerticalBox(), new GridBagConstraints(0, 2, 1, 1, 1.0, 1.0, 18, 1, new Insets(0, 0, 0, 0), 0, 0));
        return panel;
    }

    @Override
    protected void addAdditionalVariables(TemplateBuilderImpl builder) {
        PsiTypeElement typeElement = this.getVariable().getTypeElement();
        builder.replaceElement((PsiElement)typeElement, "Variable_Type", AbstractJavaInplaceIntroducer.createExpression(this.myExpression, typeElement.getText()), true, true);
    }

    private static void appendTypeCasts(List<RangeMarker> occurrenceMarkers, PsiFile file, Project project, @Nullable PsiVariable psiVariable) {
        if (occurrenceMarkers != null) {
            for (RangeMarker occurrenceMarker : occurrenceMarkers) {
                PsiElement refVariableElement = file.findElementAt(occurrenceMarker.getStartOffset());
                PsiReferenceExpression referenceExpression = (PsiReferenceExpression)PsiTreeUtil.getParentOfType((PsiElement)refVariableElement, PsiReferenceExpression.class);
                if (referenceExpression == null) continue;
                PsiElement parent = referenceExpression.getParent();
                if (parent instanceof PsiVariable) {
                    JavaVariableInplaceIntroducer.createCastInVariableDeclaration(project, (PsiVariable)parent);
                    continue;
                }
                if (!(parent instanceof PsiReferenceExpression) || psiVariable == null) continue;
                PsiExpression initializer = psiVariable.getInitializer();
                LOG.assertTrue(initializer != null);
                PsiType type = initializer.getType();
                if (((PsiReferenceExpression)parent).resolve() != null || type == null) continue;
                PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
                PsiExpression castedExpr = elementFactory.createExpressionFromText("((" + type.getCanonicalText() + ")" + referenceExpression.getText() + ")", parent);
                JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(referenceExpression.replace((PsiElement)castedExpr));
            }
        }
        if (psiVariable != null && psiVariable.isValid()) {
            JavaVariableInplaceIntroducer.createCastInVariableDeclaration(project, psiVariable);
        }
    }

    private static void createCastInVariableDeclaration(Project project, PsiVariable psiVariable) {
        PsiExpression initializer = psiVariable.getInitializer();
        LOG.assertTrue(initializer != null);
        PsiType type = psiVariable.getType();
        PsiType initializerType = initializer.getType();
        if (initializerType != null && !TypeConversionUtil.isAssignable((PsiType)type, (PsiType)initializerType)) {
            PsiElementFactory elementFactory = JavaPsiFacade.getElementFactory((Project)project);
            PsiExpression castExpr = elementFactory.createExpressionFromText("(" + psiVariable.getType().getCanonicalText() + ")" + initializer.getText(), (PsiElement)psiVariable);
            JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences(initializer.replace((PsiElement)castExpr));
        }
    }

    @Nullable
    private static String getAdvertisementText(PsiDeclarationStatement declaration, PsiType type, boolean hasTypeSuggestion) {
        Shortcut[] shortcuts;
        VariablesProcessor processor = ReassignVariableUtil.findVariablesOfType(declaration, type);
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        if (processor.size() > 0 && (shortcuts = keymap.getShortcuts("IntroduceVariable")).length > 0) {
            return "Press " + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + " to reassign existing variable";
        }
        if (hasTypeSuggestion && (shortcuts = keymap.getShortcuts("PreviousTemplateVariable")).length > 0) {
            return "Press " + KeymapUtil.getShortcutText((Shortcut)shortcuts[0]) + " to change type";
        }
        return null;
    }

    protected boolean createFinals() {
        return IntroduceVariableBase.createFinals(this.myProject);
    }

    public static void adjustLine(final PsiVariable psiVariable, final Document document) {
        int modifierListOffset = psiVariable.getTextRange().getStartOffset();
        final int varLineNumber = document.getLineNumber(modifierListOffset);
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                PsiDocumentManager.getInstance((Project)psiVariable.getProject()).doPostponedOperationsAndUnblockDocument(document);
                CodeStyleManager.getInstance((Project)psiVariable.getProject()).adjustLineIndent(document, document.getLineStartOffset(varLineNumber));
            }
        });
    }

    protected String getTitle() {
        return this.myTitle;
    }

    @Nullable
    private static String getAdvertisementText(boolean hasTypeSuggestion) {
        Shortcut[] shortcuts;
        Keymap keymap = KeymapManager.getInstance().getActiveKeymap();
        if (hasTypeSuggestion && (shortcuts = keymap.getShortcuts("PreviousTemplateVariable")).length > 0) {
            return "Press " + shortcuts[0] + " to change type";
        }
        return null;
    }
}

