/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.introduceField;

import com.intellij.codeInsight.TestFrameworks;
import com.intellij.ide.util.PropertiesComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.introduceField.BaseExpressionToFieldHandler;
import com.intellij.refactoring.ui.TypeSelectorManager;
import com.intellij.ui.NonFocusableCheckBox;
import com.intellij.ui.StateRestoringCheckBox;
import com.intellij.util.Processor;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;

public abstract class IntroduceFieldCentralPanel {
    protected static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.introduceField.IntroduceFieldDialog");
    private static final String INTRODUCE_FIELD_FINAL_CHECKBOX = "introduce.final.checkbox";
    public static boolean ourLastCbFinalState = PropertiesComponent.getInstance().getBoolean("introduce.final.checkbox", true);
    protected final PsiClass myParentClass;
    protected final PsiExpression myInitializerExpression;
    protected final PsiLocalVariable myLocalVariable;
    protected final boolean myIsCurrentMethodConstructor;
    protected final boolean myIsInvokedOnDeclaration;
    protected final boolean myWillBeDeclaredStatic;
    protected final int myOccurrencesCount;
    protected final boolean myAllowInitInMethod;
    protected final boolean myAllowInitInMethodIfAll;
    protected final TypeSelectorManager myTypeSelectorManager;
    private JCheckBox myCbReplaceAll;
    private StateRestoringCheckBox myCbDeleteVariable;
    private StateRestoringCheckBox myCbFinal;
    private boolean myHasWriteAccess;

    public IntroduceFieldCentralPanel(PsiClass parentClass, PsiExpression initializerExpression, PsiLocalVariable localVariable, boolean isCurrentMethodConstructor, boolean isInvokedOnDeclaration, boolean willBeDeclaredStatic, PsiExpression[] occurrences, boolean allowInitInMethod, boolean allowInitInMethodIfAll, TypeSelectorManager typeSelectorManager) {
        this.myParentClass = parentClass;
        this.myInitializerExpression = initializerExpression;
        this.myLocalVariable = localVariable;
        this.myIsCurrentMethodConstructor = isCurrentMethodConstructor;
        this.myIsInvokedOnDeclaration = isInvokedOnDeclaration;
        this.myWillBeDeclaredStatic = willBeDeclaredStatic;
        this.myOccurrencesCount = occurrences.length;
        this.myHasWriteAccess = false;
        for (PsiExpression occurrence : occurrences) {
            if (!PsiUtil.isAccessedForWriting((PsiExpression)occurrence)) continue;
            this.myHasWriteAccess = true;
            break;
        }
        this.myAllowInitInMethod = allowInitInMethod;
        this.myAllowInitInMethodIfAll = allowInitInMethodIfAll;
        this.myTypeSelectorManager = typeSelectorManager;
    }

    protected boolean setEnabledInitializationPlaces(PsiElement initializerPart, PsiElement initializer) {
        PsiElement[] children;
        PsiElement refElement;
        PsiReferenceExpression refExpr;
        if (initializerPart instanceof PsiReferenceExpression && (refExpr = (PsiReferenceExpression)initializerPart).getQualifierExpression() == null && ((refElement = refExpr.resolve()) == null || (refElement instanceof PsiLocalVariable || refElement instanceof PsiParameter || refElement instanceof PsiField && !((PsiField)refElement).hasInitializer()) && !PsiTreeUtil.isAncestor((PsiElement)initializer, (PsiElement)refElement, (boolean)true))) {
            return this.updateInitializationPlaceModel(this.initializedInSetUp(refElement));
        }
        for (PsiElement child : children = initializerPart.getChildren()) {
            if (this.setEnabledInitializationPlaces(child, initializer)) continue;
            return false;
        }
        return true;
    }

    private boolean initializedInSetUp(PsiElement refElement) {
        PsiMethod setUpMethod;
        if (refElement instanceof PsiField && this.hasSetUpChoice() && (setUpMethod = TestFrameworks.getInstance().findSetUpMethod(((PsiField)refElement).getContainingClass())) != null) {
            Processor<PsiReference> initializerSearcher = new Processor<PsiReference>(){

                public boolean process(PsiReference reference) {
                    PsiElement referenceElement = reference.getElement();
                    if (referenceElement instanceof PsiExpression) {
                        return !PsiUtil.isAccessedForWriting((PsiExpression)((PsiExpression)referenceElement));
                    }
                    return true;
                }
            };
            if (!ReferencesSearch.search((PsiElement)refElement, (SearchScope)new LocalSearchScope((PsiElement)setUpMethod)).forEach((Processor)initializerSearcher)) {
                return true;
            }
        }
        return false;
    }

    public abstract BaseExpressionToFieldHandler.InitializationPlace getInitializerPlace();

    protected abstract void initializeInitializerPlace(PsiExpression var1, BaseExpressionToFieldHandler.InitializationPlace var2);

    protected abstract JComponent createInitializerPlacePanel(ItemListener var1, ItemListener var2);

    public abstract void setInitializeInFieldDeclaration();

    public abstract void setVisibility(String var1);

    public abstract String getFieldVisibility();

    protected void initializeControls(PsiExpression initializerExpression, BaseExpressionToFieldHandler.InitializationPlace ourLastInitializerPlace) {
        this.myCbFinal.setSelected(this.myCbFinal.isEnabled() && ourLastCbFinalState);
    }

    public boolean isReplaceAllOccurrences() {
        if (this.myIsInvokedOnDeclaration) {
            return true;
        }
        if (this.myOccurrencesCount <= 1) {
            return false;
        }
        return this.myCbReplaceAll.isSelected();
    }

    public boolean isDeleteVariable() {
        if (this.myIsInvokedOnDeclaration) {
            return true;
        }
        if (this.myCbDeleteVariable == null) {
            return false;
        }
        return this.myCbDeleteVariable.isSelected();
    }

    public boolean isDeclareFinal() {
        return this.myCbFinal.isSelected();
    }

    protected JComponent createCenterPanel() {
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                if (IntroduceFieldCentralPanel.this.myCbReplaceAll != null && IntroduceFieldCentralPanel.this.myAllowInitInMethod) {
                    IntroduceFieldCentralPanel.this.updateInitializerSelection();
                }
                if (IntroduceFieldCentralPanel.this.shouldUpdateTypeSelector()) {
                    IntroduceFieldCentralPanel.this.updateTypeSelector();
                }
            }
        };
        ItemListener finalUpdater = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent e) {
                IntroduceFieldCentralPanel.this.updateCbFinal();
            }
        };
        JComponent initializerPlacePanel = this.createInitializerPlacePanel(itemListener, finalUpdater);
        JPanel checkboxes = this.appendCheckboxes(itemListener);
        JPanel panel = this.composeWholePanel(initializerPlacePanel, checkboxes);
        this.updateTypeSelector();
        this.updateCbFinal();
        return panel;
    }

    protected abstract JPanel composeWholePanel(JComponent var1, JPanel var2);

    protected void updateInitializerSelection() {
    }

    protected boolean shouldUpdateTypeSelector() {
        return true;
    }

    protected JPanel appendCheckboxes(ItemListener itemListener) {
        GridBagConstraints gbConstraints = new GridBagConstraints(0, -1, 1, 1, 0.0, 0.0, 18, 0, new Insets(0, 0, 0, 0), 0, 0);
        JPanel panel = new JPanel(new GridBagLayout());
        this.myCbFinal = new StateRestoringCheckBox();
        this.myCbFinal.setFocusable(false);
        this.myCbFinal.setText(RefactoringBundle.message((String)"declare.final"));
        this.myCbFinal.addItemListener(itemListener);
        ++gbConstraints.gridy;
        panel.add((Component)this.myCbFinal, gbConstraints);
        this.appendOccurrences(itemListener, gbConstraints, panel);
        if (this.myLocalVariable != null) {
            ++gbConstraints.gridy;
            if (this.myCbReplaceAll != null) {
                gbConstraints.insets = new Insets(0, 8, 0, 0);
            }
            this.myCbDeleteVariable = new StateRestoringCheckBox();
            this.myCbDeleteVariable.setText(RefactoringBundle.message((String)"delete.variable.declaration"));
            panel.add((Component)this.myCbDeleteVariable, gbConstraints);
            if (this.myIsInvokedOnDeclaration) {
                this.myCbDeleteVariable.setEnabled(false);
                this.myCbDeleteVariable.setSelected(true);
            } else if (this.myCbReplaceAll != null) {
                this.updateCbDeleteVariable();
                this.myCbReplaceAll.addItemListener(new ItemListener(){

                    @Override
                    public void itemStateChanged(ItemEvent e) {
                        IntroduceFieldCentralPanel.this.updateCbDeleteVariable();
                    }
                });
            }
        }
        return panel;
    }

    public void appendOccurrences(ItemListener itemListener, GridBagConstraints gbConstraints, JPanel panel) {
        if (this.myOccurrencesCount > 1) {
            this.myCbReplaceAll = new NonFocusableCheckBox();
            this.myCbReplaceAll.setText(RefactoringBundle.message((String)"replace.all.occurrences.of.expression.0.occurrences", (Object[])new Object[]{this.myOccurrencesCount}));
            ++gbConstraints.gridy;
            panel.add((Component)this.myCbReplaceAll, gbConstraints);
            this.myCbReplaceAll.addItemListener(itemListener);
            if (this.myIsInvokedOnDeclaration) {
                this.myCbReplaceAll.setEnabled(false);
                this.myCbReplaceAll.setSelected(true);
            }
        }
    }

    private void updateTypeSelector() {
        if (this.myCbReplaceAll != null) {
            this.myTypeSelectorManager.setAllOccurrences(this.myCbReplaceAll.isSelected());
        } else {
            this.myTypeSelectorManager.setAllOccurrences(false);
        }
    }

    private void updateCbDeleteVariable() {
        if (!this.myCbReplaceAll.isSelected()) {
            this.myCbDeleteVariable.makeUnselectable(false);
        } else {
            this.myCbDeleteVariable.makeSelectable();
        }
    }

    protected void updateCbFinal() {
        if (!this.allowFinal()) {
            this.myCbFinal.makeUnselectable(false);
        } else {
            this.myCbFinal.makeSelectable();
        }
    }

    protected boolean allowFinal() {
        return !this.myHasWriteAccess || !this.isReplaceAllOccurrences();
    }

    public void addOccurrenceListener(ItemListener itemListener) {
        if (this.myCbReplaceAll != null) {
            this.myCbReplaceAll.addItemListener(itemListener);
        }
    }

    public void setReplaceAllOccurrences(boolean replaceAllOccurrences) {
        if (this.myCbReplaceAll != null) {
            this.myCbReplaceAll.setSelected(replaceAllOccurrences);
        }
    }

    public void setCreateFinal(boolean createFinal) {
        this.myCbFinal.setSelected(createFinal);
        this.myCbFinal.setEnabled(true);
    }

    protected void enableFinal(boolean enable) {
        this.myCbFinal.setEnabled(enable);
    }

    public void saveFinalState() {
        if (this.myCbFinal != null && this.myCbFinal.isEnabled()) {
            ourLastCbFinalState = this.myCbFinal.isSelected();
            PropertiesComponent.getInstance().setValue(INTRODUCE_FIELD_FINAL_CHECKBOX, String.valueOf(ourLastCbFinalState));
        }
    }

    protected abstract boolean updateInitializationPlaceModel(boolean var1);

    protected abstract boolean hasSetUpChoice();
}

