/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractMethodObject;

import com.intellij.openapi.actionSystem.DataContext;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.command.CommandProcessor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.RangeMarker;
import com.intellij.openapi.editor.ScrollType;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pass;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.impl.source.PostprocessReformattingAspect;
import com.intellij.refactoring.RefactoringActionHandler;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.extractMethod.ExtractMethodHandler;
import com.intellij.refactoring.extractMethod.PrepareFailedException;
import com.intellij.refactoring.extractMethodObject.ExtractMethodObjectProcessor;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import com.intellij.refactoring.util.duplicates.DuplicatesImpl;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ExtractMethodObjectHandler
implements RefactoringActionHandler {
    private static final Logger LOG = Logger.getInstance((String)("#" + ExtractMethodObjectHandler.class.getName()));

    public void invoke(final @NotNull Project project, final Editor editor, final PsiFile file, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invoke"));
        }
        ExtractMethodHandler.selectAndPass(project, editor, file, new Pass<PsiElement[]>(){

            public void pass(PsiElement[] selectedValue) {
                ExtractMethodObjectHandler.this.invokeOnElements(project, editor, file, selectedValue);
            }
        });
    }

    private void invokeOnElements(@NotNull Project project, @NotNull Editor editor, @NotNull PsiFile file, @NotNull PsiElement[] elements) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invokeOnElements"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invokeOnElements"));
        }
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invokeOnElements"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invokeOnElements"));
        }
        if (elements.length == 0) {
            String message = RefactoringBundle.getCannotRefactorMessage((String)RefactoringBundle.message((String)"selected.block.should.represent.a.set.of.statements.or.an.expression"));
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)message, (String)"Extract Method Object", (String)"refactoring.extractMethodObject");
            return;
        }
        ExtractMethodObjectProcessor processor = new ExtractMethodObjectProcessor(project, editor, elements, "");
        ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor = processor.getExtractProcessor();
        try {
            if (!extractProcessor.prepare()) {
                return;
            }
        }
        catch (PrepareFailedException e) {
            CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)e.getMessage(), (String)"Extract Method Object", (String)"refactoring.extractMethodObject");
            ExtractMethodHandler.highlightPrepareError(e, file, editor, project);
            return;
        }
        if (!CommonRefactoringUtil.checkReadOnlyStatus((Project)project, (PsiElement)extractProcessor.getTargetClass().getContainingFile())) {
            return;
        }
        if (extractProcessor.showDialog()) {
            ExtractMethodObjectHandler.run(project, editor, processor, extractProcessor);
        }
    }

    public static void run(final @NotNull Project project, final @NotNull Editor editor, final @NotNull ExtractMethodObjectProcessor processor, final @NotNull ExtractMethodObjectProcessor.MyExtractMethodProcessor extractProcessor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "run"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "run"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "run"));
        }
        if (extractProcessor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "run"));
        }
        int offset = editor.getCaretModel().getOffset();
        RangeMarker marker = editor.getDocument().createRangeMarker(new TextRange(offset, offset));
        CommandProcessor.getInstance().executeCommand(project, new Runnable(){

            @Override
            public void run() {
                PostprocessReformattingAspect.getInstance(project).postponeFormattingInside(new Runnable(){

                    @Override
                    public void run() {
                        try {
                            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                                @Override
                                public void run() {
                                    extractProcessor.doRefactoring();
                                }
                            });
                            processor.run();
                            processor.runChangeSignature();
                        }
                        catch (IncorrectOperationException e) {
                            LOG.error((Throwable)e);
                        }
                    }
                });
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                if (processor.isCreateInnerClass()) {
                    processor.moveUsedMethodsToInner();
                    PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
                    DuplicatesImpl.processDuplicates(extractProcessor, project, editor);
                }
                ApplicationManager.getApplication().runWriteAction(new Runnable(){

                    @Override
                    public void run() {
                        if (processor.isCreateInnerClass()) {
                            processor.changeInstanceAccess(project);
                        }
                        PsiMethod method = processor.getMethod();
                        LOG.assertTrue(method != null);
                        method.delete();
                    }
                });
            }
        }, "Extract Method Object", (Object)"Extract Method Object");
        editor.getCaretModel().moveToOffset(marker.getStartOffset());
        marker.dispose();
        editor.getScrollingModel().scrollToCaret(ScrollType.RELATIVE);
    }

    public void invoke(@NotNull Project project, @NotNull PsiElement[] elements, DataContext dataContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invoke"));
        }
        if (elements == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/extractMethodObject/ExtractMethodObjectHandler", "invoke"));
        }
        throw new UnsupportedOperationException();
    }
}

