/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.extractInterface;

import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.refactoring.JavaRefactoringSettings;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.classMembers.DelegatingMemberInfoModel;
import com.intellij.refactoring.classMembers.MemberInfoBase;
import com.intellij.refactoring.extractInterface.ExtractInterfaceHandler;
import com.intellij.refactoring.extractInterface.ExtractInterfaceProcessor;
import com.intellij.refactoring.extractSuperclass.ExtractSuperBaseProcessor;
import com.intellij.refactoring.extractSuperclass.JavaExtractSuperBaseDialog;
import com.intellij.refactoring.ui.MemberSelectionPanel;
import com.intellij.refactoring.util.DocCommentPolicy;
import com.intellij.refactoring.util.classMembers.MemberInfo;
import com.intellij.util.ArrayUtil;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JPanel;

class ExtractInterfaceDialog
extends JavaExtractSuperBaseDialog {
    public ExtractInterfaceDialog(Project project, PsiClass sourceClass) {
        super(project, sourceClass, ExtractInterfaceDialog.collectMembers(sourceClass), ExtractInterfaceHandler.REFACTORING_NAME);
        for (MemberInfo memberInfo : this.myMemberInfos) {
            memberInfo.setToAbstract(true);
        }
        this.init();
    }

    private static List<MemberInfo> collectMembers(PsiClass c) {
        return MemberInfo.extractClassMembers(c, new MemberInfoBase.Filter<PsiMember>(){

            public boolean includeMember(PsiMember element) {
                if (element instanceof PsiMethod) {
                    return element.hasModifierProperty("public") && !element.hasModifierProperty("static");
                }
                if (element instanceof PsiField) {
                    return element.hasModifierProperty("final") && element.hasModifierProperty("static") && element.hasModifierProperty("public");
                }
                if (element instanceof PsiClass) {
                    return ((PsiClass)element).isInterface() || element.hasModifierProperty("static");
                }
                return false;
            }
        }, true);
    }

    @Override
    protected String getClassNameLabelText() {
        return this.isExtractSuperclass() ? RefactoringBundle.message((String)"interface.name.prompt") : RefactoringBundle.message((String)"rename.implementation.class.to");
    }

    @Override
    protected String getPackageNameLabelText() {
        return this.isExtractSuperclass() ? RefactoringBundle.message((String)"package.for.new.interface") : RefactoringBundle.message((String)"package.for.original.class");
    }

    @Override
    protected String getEntityName() {
        return RefactoringBundle.message((String)"extractSuperInterface.interface");
    }

    @Override
    protected String getTopLabelText() {
        return RefactoringBundle.message((String)"extract.interface.from");
    }

    protected JComponent createCenterPanel() {
        JPanel panel = new JPanel(new BorderLayout());
        MemberSelectionPanel memberSelectionPanel = new MemberSelectionPanel(RefactoringBundle.message((String)"members.to.form.interface"), this.myMemberInfos, RefactoringBundle.message((String)"make.abstract"));
        memberSelectionPanel.getTable().setMemberInfoModel(new DelegatingMemberInfoModel<PsiMember, MemberInfo>(memberSelectionPanel.getTable().getMemberInfoModel()){

            @Override
            public Boolean isFixedAbstract(MemberInfo member) {
                return Boolean.TRUE;
            }
        });
        panel.add((Component)memberSelectionPanel, "Center");
        panel.add((Component)this.myDocCommentPanel, "East");
        return panel;
    }

    @Override
    protected String getDocCommentPanelName() {
        return RefactoringBundle.message((String)"extractSuperInterface.javadoc");
    }

    @Override
    protected String getExtractedSuperNameNotSpecifiedMessage() {
        return RefactoringBundle.message((String)"no.interface.name.specified");
    }

    @Override
    protected int getDocCommentPolicySetting() {
        return JavaRefactoringSettings.getInstance().EXTRACT_INTERFACE_JAVADOC;
    }

    @Override
    protected void setDocCommentPolicySetting(int policy) {
        JavaRefactoringSettings.getInstance().EXTRACT_INTERFACE_JAVADOC = policy;
    }

    @Override
    protected ExtractSuperBaseProcessor createProcessor() {
        return new ExtractInterfaceProcessor(this.myProject, false, this.getTargetDirectory(), this.getExtractedSuperName(), (PsiClass)this.mySourceClass, (MemberInfo[])ArrayUtil.toObjectArray(this.getSelectedMemberInfos(), MemberInfo.class), new DocCommentPolicy(this.getDocCommentPolicy()));
    }

    @Override
    protected String getHelpId() {
        return "refactoring.extractInterface";
    }
}

