/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.LogicalPosition;
import com.intellij.openapi.editor.event.CaretAdapter;
import com.intellij.openapi.editor.event.CaretEvent;
import com.intellij.openapi.editor.event.CaretListener;
import com.intellij.openapi.editor.event.DocumentAdapter;
import com.intellij.openapi.editor.event.DocumentEvent;
import com.intellij.openapi.editor.event.DocumentListener;
import com.intellij.openapi.editor.impl.CaretModelImpl;
import com.intellij.openapi.editor.impl.EditorImpl;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiFileFactory;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ParameterIndexer;
import com.intellij.ui.EditorTextField;
import java.awt.Dimension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class MethodSignatureEditor<M extends PsiElement>
extends EditorTextField {
    private static final String MARKER_START = "\n\n\n\n\n\n\n\n/*marker_start*/\n\n\n\n\n\n\n";
    private static final String MARKER_END = "\n\n\n\n\n\n\n\n/*marker_end*/\n\n\n\n\n\n\n";
    private final M myMethod;
    private final Class<? extends M> myClass;
    private final PsiFile myFile;
    private final String myStartMarker;
    private String myEndMarker;
    public static final Key<Integer> OLD_PARAMETER_INDEX = Key.create((String)"change.signature.parameter.index");
    public static final ParameterIndexer INDEXER = new ParameterIndexer(){

        @Override
        public void setIndex(@NotNull PsiElement element, int index) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/changeSignature/MethodSignatureEditor$1", "setIndex"));
            }
            element.putCopyableUserData(OLD_PARAMETER_INDEX, (Object)index);
        }

        @Override
        public int getIndex(@NotNull PsiElement element) {
            if (element == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/changeSignature/MethodSignatureEditor$1", "getIndex"));
            }
            Integer index = (Integer)element.getCopyableUserData(OLD_PARAMETER_INDEX);
            return index == null ? -1 : index;
        }
    };

    public MethodSignatureEditor(@NotNull M method, Class<? extends M> genericInterface) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/changeSignature/MethodSignatureEditor", "<init>"));
        }
        super(EditorFactory.getInstance().createDocument((CharSequence)""), method.getProject(), method.getContainingFile().getFileType(), false, false);
        this.myStartMarker = this.getStartMarker();
        this.myEndMarker = this.getEndMarker();
        this.myMethod = method;
        this.myFile = method.getContainingFile();
        this.myClass = genericInterface;
        Document document = this.createDocument();
        assert (document != null) : "Can't create document";
        this.setDocument(document);
    }

    protected final TextRange getCurrentSignatureTextRange() {
        String text = this.getDocument().getText();
        return TextRange.create((int)(text.indexOf(this.myStartMarker) + this.myStartMarker.length()), (int)text.indexOf(this.myEndMarker));
    }

    public abstract TextRange getSignatureTextRange();

    protected abstract String formatMethod();

    protected abstract void indexParameters(M var1, @NotNull ParameterIndexer var2);

    protected String getStartMarker() {
        return MARKER_START;
    }

    protected String getEndMarker() {
        return MARKER_END;
    }

    @Nullable
    protected M createFromString() {
        PsiFile file = PsiDocumentManager.getInstance((Project)this.getProject()).getPsiFile(this.getDocument());
        if (file == null) {
            return null;
        }
        int startOffset = this.getCurrentSignatureTextRange().getStartOffset();
        int endOffset = file.getTextLength();
        PsiTreeUtil.findElementOfClassAtRange((PsiFile)file, (int)startOffset, (int)endOffset, this.myClass);
        FileViewProvider viewProvider = file.getViewProvider();
        M result = null;
        for (Language lang : viewProvider.getLanguages()) {
            PsiElement run;
            PsiElement elementAt = viewProvider.findElementAt(startOffset, lang);
            PsiElement prev = run = PsiTreeUtil.getParentOfType((PsiElement)elementAt, this.myClass, (boolean)false);
            while (run != null && run.getTextRange().getStartOffset() == startOffset && run.getTextRange().getEndOffset() <= endOffset) {
                prev = run;
                run = PsiTreeUtil.getParentOfType((PsiElement)run, this.myClass);
            }
            if (prev == null) continue;
            int elementStartOffset = prev.getTextRange().getStartOffset();
            int elementEndOffset = prev.getTextRange().getEndOffset();
            return (M)(startOffset >= elementStartOffset && elementEndOffset <= endOffset ? prev : null);
        }
        return result;
    }

    public M getMethod() {
        return this.myMethod;
    }

    @Nullable
    private Document createDocument() {
        StringBuilder text = new StringBuilder(this.myFile.getText());
        TextRange range = this.getSignatureTextRange();
        text.insert(range.getEndOffset(), this.myEndMarker);
        text.insert(range.getStartOffset(), this.myStartMarker);
        text.replace(range.getStartOffset() + this.myStartMarker.length(), range.getEndOffset() + this.myStartMarker.length(), this.formatMethod());
        PsiFile newFile = PsiFileFactory.getInstance((Project)this.myMethod.getProject()).createFileFromText(this.myFile.getName(), this.myFile.getFileType(), (CharSequence)text, System.currentTimeMillis(), true);
        return PsiDocumentManager.getInstance((Project)this.myMethod.getProject()).getDocument(newFile);
    }

    @Override
    public void addNotify() {
        super.addNotify();
        Editor editor = this.getEditor();
        if (editor instanceof EditorImpl) {
            editor.putUserData(EditorImpl.EDITABLE_AREA_MARKER, (Object)Pair.create((Object)this.myStartMarker, (Object)this.myEndMarker));
            this.indexParameters(this.createFromString(), INDEXER);
            ((EditorImpl)editor).setScrollToCaret(false);
            ((CaretModelImpl)editor.getCaretModel()).setIgnoreWrongMoves(true);
            final TextRange range = this.getCurrentSignatureTextRange();
            ApplicationManager.getApplication().runWriteAction(new Runnable(){

                @Override
                public void run() {
                    CodeStyleManager.getInstance((Project)MethodSignatureEditor.this.getProject()).reformatText(MethodSignatureEditor.this.myFile, range.getStartOffset(), range.getEndOffset());
                }
            });
            editor.getCaretModel().addCaretListener((CaretListener)new CaretAdapter(){

                public void caretPositionChanged(CaretEvent e) {
                    MethodSignatureEditor.this.createFromString();
                    LogicalPosition newPosition = e.getNewPosition();
                    Editor ed = e.getEditor();
                    int pos = ed.logicalPositionToOffset(newPosition);
                    TextRange range = MethodSignatureEditor.this.getCurrentSignatureTextRange();
                    int start = range.getStartOffset();
                    int end = range.getEndOffset();
                    if (pos < start) {
                        e.getEditor().getCaretModel().moveToOffset(start);
                        MethodSignatureEditor.this.updateUI(ed, false);
                    } else if (end < pos) {
                        e.getEditor().getCaretModel().moveToOffset(end);
                        MethodSignatureEditor.this.updateUI(ed, false);
                    }
                }
            });
            editor.getSettings().setUseSoftWraps(false);
            this.updateUI(editor, true);
            editor.getDocument().addDocumentListener((DocumentListener)new DocumentAdapter(){

                public void documentChanged(DocumentEvent e) {
                    MethodSignatureEditor.this.updateUI(MethodSignatureEditor.this.getEditor(), false);
                }
            });
        }
    }

    private void updateUI(Editor editor, boolean moveCaretToStart) {
        Dimension size;
        TextRange range = this.getCurrentSignatureTextRange();
        int start = range.getStartOffset();
        int end = range.getEndOffset();
        int startLine = ((EditorImpl)editor).offsetToLogicalPosition((int)start, (boolean)false).line;
        int endLine = ((EditorImpl)editor).offsetToLogicalPosition((int)end, (boolean)false).line;
        int lineCount = Math.max(1, endLine - startLine);
        Dimension old = this.getSize();
        if (!old.equals(size = new Dimension(this.getWidth(), editor.getLineHeight() * (lineCount + 2) + 4))) {
            this.setSize(size);
            this.setPreferredSize(size);
            this.revalidate();
            this.repaint();
        }
        if (moveCaretToStart) {
            editor.getCaretModel().moveToOffset(start);
        }
        editor.getScrollingModel().scrollVertically((startLine - 1) * editor.getLineHeight() + 2);
    }
}

