/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiImportList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameIdentifierOwner;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParameterList;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.light.LightModifierList;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.DetectedJavaChangeInfo;
import com.intellij.refactoring.changeSignature.JavaChangeInfo;
import com.intellij.refactoring.changeSignature.LanguageChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.RenameChangeInfo;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaChangeSignatureDetector
implements LanguageChangeSignatureDetector {
    private static final Logger LOG = Logger.getInstance((String)("#" + JavaChangeSignatureDetector.class.getName()));

    @Override
    public ChangeInfo createInitialChangeInfo(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDetector", "createInitialChangeInfo"));
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
        if (method != null && JavaChangeSignatureDetector.isInsideMethodSignature(element, method)) {
            if (element.getTextRange().getEndOffset() <= method.getTextOffset()) {
                return null;
            }
            return DetectedJavaChangeInfo.createFromMethod(method);
        }
        PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)element, PsiVariable.class);
        if (variable != null) {
            return new RenameChangeInfo((PsiNameIdentifierOwner)variable, null){

                public Language getLanguage() {
                    return StdLanguages.JAVA;
                }
            };
        }
        return null;
    }

    @Override
    public boolean performChange(ChangeInfo changeInfo, ChangeInfo initialChangeInfo, @NotNull String oldText, boolean silently) {
        if (oldText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDetector", "performChange"));
        }
        if (changeInfo instanceof DetectedJavaChangeInfo) {
            return ((DetectedJavaChangeInfo)changeInfo).perform(initialChangeInfo, oldText, silently);
        }
        if (changeInfo instanceof RenameChangeInfo) {
            ((RenameChangeInfo)changeInfo).perform();
            return true;
        }
        return false;
    }

    @Override
    public boolean isChangeSignatureAvailableOnElement(PsiElement element, ChangeInfo currentInfo) {
        if (currentInfo instanceof RenameChangeInfo) {
            PsiElement nameIdentifier = ((RenameChangeInfo)currentInfo).getNameIdentifier();
            if (nameIdentifier != null) {
                TextRange nameIdentifierTextRange = nameIdentifier.getTextRange();
                return nameIdentifierTextRange.contains(element.getTextRange()) || nameIdentifierTextRange.getEndOffset() == element.getTextOffset();
            }
        } else if (currentInfo instanceof JavaChangeInfo) {
            PsiMethod method = (PsiMethod)currentInfo.getMethod();
            return JavaChangeSignatureDetector.getSignatureRange(method).contains(element.getTextRange());
        }
        return false;
    }

    @Override
    public boolean ignoreChanges(PsiElement element) {
        if (element instanceof PsiMethod) {
            return true;
        }
        return PsiTreeUtil.getParentOfType((PsiElement)element, PsiImportList.class) != null;
    }

    @Override
    @Nullable
    public TextRange getHighlightingRange(ChangeInfo changeInfo) {
        if (changeInfo == null) {
            return null;
        }
        if (changeInfo instanceof RenameChangeInfo) {
            PsiElement nameIdentifier = ((RenameChangeInfo)changeInfo).getNameIdentifier();
            return nameIdentifier != null ? nameIdentifier.getTextRange() : null;
        }
        PsiElement method = changeInfo.getMethod();
        return method instanceof PsiMethod ? JavaChangeSignatureDetector.getSignatureRange((PsiMethod)method) : null;
    }

    @Override
    @Nullable
    public String extractSignature(PsiElement element, @NotNull ChangeInfo initialChangeInfo) {
        if (initialChangeInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDetector", "extractSignature"));
        }
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)element, PsiMethod.class, (boolean)false);
        if (method != null && JavaChangeSignatureDetector.isInsideMethodSignature(element, method) && method == initialChangeInfo.getMethod()) {
            PsiCodeBlock body = method.getBody();
            TextRange signatureRange = new TextRange(0, body != null ? body.getStartOffsetInParent() : method.getTextLength());
            return signatureRange.substring(method.getText());
        }
        if (element instanceof PsiIdentifier && element.getParent() instanceof PsiNamedElement) {
            return element.getText();
        }
        return null;
    }

    @Override
    public ChangeInfo createNextChangeInfo(String signature, @NotNull ChangeInfo currentInfo, String initialName) {
        if (currentInfo == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDetector", "createNextChangeInfo"));
        }
        PsiElement currentInfoMethod = currentInfo.getMethod();
        if (currentInfoMethod == null) {
            return null;
        }
        Project project = currentInfoMethod.getProject();
        if (currentInfo instanceof RenameChangeInfo) {
            return currentInfo;
        }
        PsiMethod oldMethod = (PsiMethod)currentInfo.getMethod();
        String visibility = "";
        PsiClass containingClass = oldMethod.getContainingClass();
        if (containingClass != null && containingClass.isInterface()) {
            visibility = "public ";
        }
        PsiMethod method = JavaPsiFacade.getElementFactory((Project)project).createMethodFromText((visibility + signature).trim(), (PsiElement)oldMethod);
        return ((DetectedJavaChangeInfo)currentInfo).createNextInfo(method);
    }

    private static boolean isInsideMethodSignature(PsiElement element, @NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/refactoring/changeSignature/JavaChangeSignatureDetector", "isInsideMethodSignature"));
        }
        PsiCodeBlock body = method.getBody();
        TextRange textRange = element.getTextRange();
        PsiModifierList psiModifierList = method.getModifierList();
        if (psiModifierList instanceof LightModifierList) {
            return false;
        }
        if (body != null) {
            return textRange.getEndOffset() <= body.getTextOffset() && textRange.getStartOffset() >= psiModifierList.getTextRange().getEndOffset();
        }
        return textRange.getStartOffset() >= psiModifierList.getTextRange().getEndOffset() && textRange.getEndOffset() <= method.getTextRange().getEndOffset();
    }

    public static TextRange getSignatureRange(PsiMethod method) {
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            return new TextRange(method.getTextRange().getStartOffset(), body.getTextOffset());
        }
        return new TextRange(method.getTextRange().getStartOffset(), method.getTextRange().getEndOffset());
    }

    @Override
    public boolean isMoveParameterAvailable(PsiElement element, boolean left) {
        PsiParameter parameter;
        PsiElement declarationScope;
        if (element instanceof PsiParameter && (declarationScope = (parameter = (PsiParameter)element).getDeclarationScope()) instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)declarationScope;
            int parameterIndex = method.getParameterList().getParameterIndex(parameter);
            if (left) {
                return parameterIndex > 0;
            }
            return parameterIndex < method.getParameterList().getParametersCount() - 1;
        }
        return false;
    }

    @Override
    public void moveParameter(PsiElement element, final Editor editor, final boolean left) {
        final PsiParameter parameter = (PsiParameter)element;
        final PsiMethod method = (PsiMethod)parameter.getDeclarationScope();
        final int parameterIndex = method.getParameterList().getParameterIndex(parameter);
        new WriteCommandAction(element.getProject(), "Parameter Move", new PsiFile[0]){

            protected void run(Result result) throws Throwable {
                PsiParameterList parameterList = method.getParameterList();
                PsiParameter[] parameters = parameterList.getParameters();
                int deltaOffset = editor.getCaretModel().getOffset() - parameter.getTextRange().getStartOffset();
                PsiParameter frst = left ? parameters[parameterIndex - 1] : parameter;
                PsiParameter scnd = left ? parameter : parameters[parameterIndex + 1];
                int startOffset = frst.getTextRange().getStartOffset();
                int endOffset = scnd.getTextRange().getEndOffset();
                PsiFile file = method.getContainingFile();
                Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(file);
                if (document != null) {
                    String comma_whitespace_between = document.getText().substring(frst.getTextRange().getEndOffset(), scnd.getTextRange().getStartOffset());
                    document.replaceString(startOffset, endOffset, (CharSequence)(scnd.getText() + comma_whitespace_between + frst.getText()));
                    editor.getCaretModel().moveToOffset(document.getText().indexOf(parameter.getText(), startOffset) + deltaOffset);
                }
            }
        }.execute();
    }
}

