/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.refactoring.BaseRefactoringIntentionAction;
import com.intellij.refactoring.changeSignature.ChangeInfo;
import com.intellij.refactoring.changeSignature.ChangeSignatureGestureDetector;
import com.intellij.refactoring.changeSignature.LanguageChangeSignatureDetector;
import com.intellij.refactoring.changeSignature.LanguageChangeSignatureDetectors;
import com.intellij.refactoring.changeSignature.RenameChangeInfo;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class ChangeSignatureDetectorAction
extends BaseRefactoringIntentionAction {
    public static final String CHANGE_SIGNATURE = "Apply signature change";
    public static final String NEW_NAME = "Apply new name";
    private String myAcceptText;

    @NotNull
    public String getText() {
        String text = this.myAcceptText;
        String string = text != null ? text : CHANGE_SIGNATURE;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/ChangeSignatureDetectorAction", "getText"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        if (CHANGE_SIGNATURE == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/refactoring/changeSignature/ChangeSignatureDetectorAction", "getFamilyName"));
        }
        return CHANGE_SIGNATURE;
    }

    public boolean isAvailable(@NotNull Project project, Editor editor, @NotNull PsiElement element) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/changeSignature/ChangeSignatureDetectorAction", "isAvailable"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/refactoring/changeSignature/ChangeSignatureDetectorAction", "isAvailable"));
        }
        this.myAcceptText = null;
        LanguageChangeSignatureDetector detector = (LanguageChangeSignatureDetector)LanguageChangeSignatureDetectors.INSTANCE.forLanguage(element.getLanguage());
        if (detector != null) {
            ChangeSignatureGestureDetector signatureGestureDetector = ChangeSignatureGestureDetector.getInstance(project);
            PsiFile containingFile = element.getContainingFile();
            ChangeInfo changeInfo = signatureGestureDetector.getChangeInfo(containingFile);
            ChangeInfo initialChangeInfo = signatureGestureDetector.getInitialChangeInfo(containingFile);
            if (changeInfo != null && detector.isChangeSignatureAvailableOnElement(element, initialChangeInfo)) {
                this.myAcceptText = changeInfo instanceof RenameChangeInfo ? NEW_NAME : CHANGE_SIGNATURE;
            }
        }
        return this.myAcceptText != null;
    }

    public void invoke(@NotNull Project project, Editor editor, @NotNull PsiElement element) throws IncorrectOperationException {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/changeSignature/ChangeSignatureDetectorAction", "invoke"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/refactoring/changeSignature/ChangeSignatureDetectorAction", "invoke"));
        }
        ChangeSignatureGestureDetector.getInstance(project).changeSignature(element.getContainingFile(), true);
    }

    public boolean startInWriteAction() {
        return false;
    }
}

