/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring.changeSignature;

import com.intellij.codeInsight.highlighting.HighlightManager;
import com.intellij.ide.highlighter.HighlighterFactory;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.editor.EditorFactory;
import com.intellij.openapi.editor.colors.EditorColors;
import com.intellij.openapi.editor.colors.EditorColorsManager;
import com.intellij.openapi.editor.ex.EditorEx;
import com.intellij.openapi.editor.markup.TextAttributes;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.DialogWrapper;
import com.intellij.openapi.ui.Splitter;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiReference;
import com.intellij.psi.search.LocalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.refactoring.RefactoringBundle;
import com.intellij.refactoring.changeSignature.MethodNodeBase;
import com.intellij.ui.CheckboxTree;
import com.intellij.ui.CheckboxTreeBase;
import com.intellij.ui.CheckedTreeNode;
import com.intellij.ui.IdeBorderFactory;
import com.intellij.ui.ScrollPaneFactory;
import com.intellij.ui.treeStructure.Tree;
import com.intellij.util.Alarm;
import com.intellij.util.Consumer;
import com.intellij.util.Function;
import com.intellij.util.Query;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.awt.BorderLayout;
import java.awt.Component;
import java.util.Arrays;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Set;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.MutableTreeNode;
import javax.swing.tree.TreePath;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CallerChooserBase<M extends PsiElement>
extends DialogWrapper {
    private final M myMethod;
    private final Alarm myAlarm = new Alarm();
    private MethodNodeBase<M> myRoot;
    protected final Project myProject;
    private Tree myTree;
    private final Consumer<Set<M>> myCallback;
    private TreeSelectionListener myTreeSelectionListener;
    private Editor myCallerEditor;
    private Editor myCalleeEditor;
    private final boolean myInitDone;
    private final String myFileName;

    protected abstract MethodNodeBase<M> createTreeNode(M var1, HashSet<M> var2, Runnable var3);

    protected abstract M[] findDeepestSuperMethods(M var1);

    public CallerChooserBase(M method, Project project, String title, Tree previousTree, String fileName, Consumer<Set<M>> callback) {
        super(true);
        this.myMethod = method;
        this.myProject = project;
        this.myTree = previousTree;
        this.myFileName = fileName;
        this.myCallback = callback;
        this.setTitle(title);
        this.init();
        this.myInitDone = true;
    }

    public Tree getTree() {
        return this.myTree;
    }

    protected JComponent createCenterPanel() {
        Splitter splitter = new Splitter(false, 0.6f);
        JPanel result = new JPanel(new BorderLayout());
        if (this.myTree == null) {
            this.myTree = this.createTree();
        } else {
            CheckedTreeNode root = (CheckedTreeNode)this.myTree.getModel().getRoot();
            this.myRoot = (MethodNodeBase)((Object)root.getFirstChild());
        }
        this.myTreeSelectionListener = new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent e) {
                TreePath path = e.getPath();
                if (path != null) {
                    final MethodNodeBase node = (MethodNodeBase)((Object)path.getLastPathComponent());
                    CallerChooserBase.this.myAlarm.cancelAllRequests();
                    CallerChooserBase.this.myAlarm.addRequest(new Runnable(){

                        @Override
                        public void run() {
                            CallerChooserBase.this.updateEditorTexts(node);
                        }
                    }, 300);
                }
            }
        };
        this.myTree.getSelectionModel().addTreeSelectionListener(this.myTreeSelectionListener);
        JScrollPane scrollPane = ScrollPaneFactory.createScrollPane((Component)this.myTree);
        splitter.setFirstComponent((JComponent)scrollPane);
        JComponent callSitesViewer = this.createCallSitesViewer();
        TreePath selectionPath = this.myTree.getSelectionPath();
        if (selectionPath == null) {
            selectionPath = new TreePath(this.myRoot.getPath());
            this.myTree.getSelectionModel().addSelectionPath(selectionPath);
        }
        MethodNodeBase node = (MethodNodeBase)((Object)selectionPath.getLastPathComponent());
        this.updateEditorTexts(node);
        splitter.setSecondComponent(callSitesViewer);
        result.add((Component)splitter);
        return result;
    }

    private void updateEditorTexts(MethodNodeBase<M> node) {
        PsiElement callee;
        MethodNodeBase parentNode = (MethodNodeBase)((Object)node.getParent());
        final String callerText = node != this.myRoot ? this.getText(node.getMethod()) : "";
        final Document callerDocument = this.myCallerEditor.getDocument();
        final String calleeText = node != this.myRoot ? this.getText(parentNode.getMethod()) : "";
        final Document calleeDocument = this.myCalleeEditor.getDocument();
        ApplicationManager.getApplication().runWriteAction(new Runnable(){

            @Override
            public void run() {
                callerDocument.setText((CharSequence)callerText);
                calleeDocument.setText((CharSequence)calleeText);
            }
        });
        M caller = node.getMethod();
        PsiElement psiElement = callee = parentNode != null ? parentNode.getElementToSearch() : null;
        if (caller != null && caller.isPhysical() && callee != null) {
            HighlightManager highlighter = HighlightManager.getInstance((Project)this.myProject);
            EditorColorsManager colorManager = EditorColorsManager.getInstance();
            TextAttributes attributes = colorManager.getGlobalScheme().getAttributes(EditorColors.TEXT_SEARCH_RESULT_ATTRIBUTES);
            int start = this.getStartOffset(caller);
            for (PsiElement element : this.findElementsToHighlight(caller, callee)) {
                highlighter.addRangeHighlight(this.myCallerEditor, element.getTextRange().getStartOffset() - start, element.getTextRange().getEndOffset() - start, attributes, false, null);
            }
        }
    }

    protected Collection<PsiElement> findElementsToHighlight(M caller, PsiElement callee) {
        Query references = ReferencesSearch.search((PsiElement)callee, (SearchScope)new LocalSearchScope(caller), (boolean)false);
        return ContainerUtil.mapNotNull((Iterable)references, (Function)new Function<PsiReference, PsiElement>(){

            public PsiElement fun(PsiReference psiReference) {
                return psiReference.getElement();
            }
        });
    }

    public void dispose() {
        if (this.myTree != null) {
            this.myTree.removeTreeSelectionListener(this.myTreeSelectionListener);
            EditorFactory.getInstance().releaseEditor(this.myCallerEditor);
            EditorFactory.getInstance().releaseEditor(this.myCalleeEditor);
        }
        super.dispose();
    }

    private String getText(M method) {
        if (method == null) {
            return "";
        }
        PsiFile file = method.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        if (document != null) {
            int start = document.getLineStartOffset(document.getLineNumber(method.getTextRange().getStartOffset()));
            int end = document.getLineEndOffset(document.getLineNumber(method.getTextRange().getEndOffset()));
            return document.getText().substring(start, end);
        }
        return "";
    }

    private int getStartOffset(@NotNull M method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/refactoring/changeSignature/CallerChooserBase", "getStartOffset"));
        }
        PsiFile file = method.getContainingFile();
        Document document = PsiDocumentManager.getInstance((Project)this.myProject).getDocument(file);
        return document.getLineStartOffset(document.getLineNumber(method.getTextRange().getStartOffset()));
    }

    private JComponent createCallSitesViewer() {
        Splitter splitter = new Splitter(true);
        this.myCallerEditor = this.createEditor();
        this.myCalleeEditor = this.createEditor();
        JComponent callerComponent = this.myCallerEditor.getComponent();
        callerComponent.setBorder((Border)IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"caller.chooser.caller.method"), (boolean)false));
        splitter.setFirstComponent(callerComponent);
        JComponent calleeComponent = this.myCalleeEditor.getComponent();
        calleeComponent.setBorder((Border)IdeBorderFactory.createTitledBorder((String)RefactoringBundle.message((String)"caller.chooser.callee.method"), (boolean)false));
        splitter.setSecondComponent(calleeComponent);
        splitter.setBorder((Border)IdeBorderFactory.createRoundedBorder());
        return splitter;
    }

    private Editor createEditor() {
        EditorFactory editorFactory = EditorFactory.getInstance();
        Document document = editorFactory.createDocument((CharSequence)"");
        Editor editor = editorFactory.createViewer(document, this.myProject);
        ((EditorEx)editor).setHighlighter(HighlighterFactory.createHighlighter((Project)this.myProject, (String)this.myFileName));
        return editor;
    }

    private Tree createTree() {
        Runnable cancelCallback = new Runnable(){

            @Override
            public void run() {
                if (!CallerChooserBase.this.myInitDone) {
                    throw new ProcessCanceledException();
                }
                CallerChooserBase.this.close(1);
            }
        };
        MethodNodeBase<Object> root = this.createTreeNode(null, new HashSet(), cancelCallback);
        this.myRoot = this.createTreeNode(this.myMethod, new HashSet(), cancelCallback);
        root.add((MutableTreeNode)((Object)this.myRoot));
        CheckboxTree.CheckboxTreeCellRenderer cellRenderer = new CheckboxTree.CheckboxTreeCellRenderer(true, false){

            public void customizeRenderer(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
                if (value instanceof MethodNodeBase) {
                    ((MethodNodeBase)((Object)value)).customizeRenderer(this.getTextRenderer());
                }
            }
        };
        CheckboxTree tree = new CheckboxTree(cellRenderer, root, new CheckboxTreeBase.CheckPolicy(false, true, true, false));
        tree.getSelectionModel().setSelectionMode(1);
        tree.getSelectionModel().setSelectionPath(new TreePath(this.myRoot.getPath()));
        return tree;
    }

    private void getSelectedMethods(Set<M> methods) {
        MethodNodeBase<M> node = this.myRoot;
        this.getSelectedMethodsInner(node, methods);
        methods.remove(node.getMethod());
    }

    private void getSelectedMethodsInner(MethodNodeBase<M> node, Set<M> allMethods) {
        if (node.isChecked()) {
            M method = node.getMethod();
            PsiElement[] superMethods = this.findDeepestSuperMethods((PsiElement)method);
            if (superMethods.length == 0) {
                allMethods.add(method);
            } else {
                allMethods.addAll(Arrays.asList(superMethods));
            }
            Enumeration children = node.children();
            while (children.hasMoreElements()) {
                this.getSelectedMethodsInner((MethodNodeBase)((Object)children.nextElement()), allMethods);
            }
        }
    }

    protected void doOKAction() {
        HashSet selectedMethods = new HashSet();
        this.getSelectedMethods((Set<M>)selectedMethods);
        this.myCallback.consume((Object)selectedMethods);
        super.doOKAction();
    }

    public JComponent getPreferredFocusedComponent() {
        return this.myTree;
    }

    @Nullable
    protected String getDimensionServiceKey() {
        return "caller.chooser.dialog";
    }
}

