/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.refactoring;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiImportStatementBase;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.refactoring.RefactoringHelper;
import com.intellij.usageView.UsageInfo;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.HashSet;
import java.util.Collection;
import java.util.Set;

public class OptimizeImportsRefactoringHelper
implements RefactoringHelper<Set<PsiJavaFile>> {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.refactoring.OptimizeImportsRefactoringHelper");

    @Override
    public Set<PsiJavaFile> prepareOperation(UsageInfo[] usages) {
        HashSet javaFiles = new HashSet();
        for (UsageInfo usage : usages) {
            PsiFile file;
            if (usage.isNonCodeUsage || !((file = usage.getFile()) instanceof PsiJavaFile)) continue;
            javaFiles.add((PsiJavaFile)file);
        }
        return javaFiles;
    }

    @Override
    public void performOperation(final Project project, final Set<PsiJavaFile> javaFiles) {
        CodeStyleManager.getInstance((Project)project).performActionWithFormatterDisabled(new Runnable(){

            @Override
            public void run() {
                PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
            }
        });
        HashSet redundants = new HashSet();
        Runnable findRedundantImports = new Runnable((Set)redundants){
            final /* synthetic */ Set val$redundants;
            {
                this.val$redundants = set2;
            }

            @Override
            public void run() {
                ApplicationManager.getApplication().runReadAction(new Runnable(){

                    @Override
                    public void run() {
                        JavaCodeStyleManager styleManager = JavaCodeStyleManager.getInstance((Project)project);
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        SmartPointerManager pointerManager = SmartPointerManager.getInstance((Project)project);
                        int i = 0;
                        int fileCount = javaFiles.size();
                        for (PsiJavaFile file : javaFiles) {
                            Collection perFile;
                            VirtualFile virtualFile;
                            if (!file.isValid() || (virtualFile = file.getVirtualFile()) == null) continue;
                            if (progressIndicator != null) {
                                progressIndicator.setText2(virtualFile.getPresentableUrl());
                                progressIndicator.setFraction((double)i++ / (double)fileCount);
                            }
                            if ((perFile = styleManager.findRedundantImports(file)) == null) continue;
                            for (PsiImportStatementBase redundant : perFile) {
                                val$redundants.add(pointerManager.createSmartPsiElementPointer((PsiElement)redundant));
                            }
                        }
                    }
                });
            }
        };
        if (!ProgressManager.getInstance().runProcessWithProgressSynchronously(findRedundantImports, "Removing redundant imports", false, project)) {
            return;
        }
        ApplicationManager.getApplication().runWriteAction(new Runnable((Set)redundants){
            final /* synthetic */ Set val$redundants;
            {
                this.val$redundants = set;
            }

            @Override
            public void run() {
                try {
                    for (SmartPsiElementPointer pointer : this.val$redundants) {
                        PsiElement resolve;
                        PsiJavaCodeReferenceElement ref;
                        PsiImportStatementBase importStatement = (PsiImportStatementBase)pointer.getElement();
                        if (importStatement == null || !importStatement.isValid() || (ref = importStatement.getImportReference()) == null || (resolve = ref.resolve()) == null || resolve instanceof PsiPackage && ((PsiPackage)resolve).getDirectories(ref.getResolveScope()).length == 0) continue;
                        importStatement.delete();
                    }
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
        });
    }
}

