/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.util;

import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.FileTemplateManager;
import com.intellij.ide.fileTemplates.JavaCreateFromTemplateHandler;
import com.intellij.ide.util.PackageUtil;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.text.StringTokenizer;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CreateClassUtil {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.j2ee.CreateClassUtil");
    @NonNls
    public static final String DEFAULT_CLASS_TEMPLATE = "#DEFAULT_CLASS_TEMPLATE";
    @NonNls
    private static final String DO_NOT_CREATE_CLASS_TEMPLATE = "#DO_NOT_CREATE_CLASS_TEMPLATE";
    @NonNls
    private static final String CLASS_NAME_PROPERTY = "Class_Name";
    @NonNls
    private static final String INTERFACE_NAME_PROPERTY = "Interface_Name";

    private CreateClassUtil() {
    }

    @Nullable
    private static PsiClass createClassFromTemplate(@NotNull Properties attributes, @Nullable String templateName, @NotNull PsiDirectory directoryRoot, @NotNull String className) throws IncorrectOperationException {
        if (attributes == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/CreateClassUtil", "createClassFromTemplate"));
        }
        if (directoryRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/util/CreateClassUtil", "createClassFromTemplate"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/util/CreateClassUtil", "createClassFromTemplate"));
        }
        if (templateName == null) {
            return null;
        }
        if (templateName.equals(DO_NOT_CREATE_CLASS_TEMPLATE)) {
            return null;
        }
        Project project = directoryRoot.getProject();
        try {
            PsiClass aClass;
            String rawClassName;
            PsiFile existing;
            PsiDirectory directory = CreateClassUtil.createParentDirectories(directoryRoot, className);
            PsiFile psiFile = directory.findFile(className + "." + StdFileTypes.JAVA.getDefaultExtension());
            if (psiFile != null) {
                psiFile.delete();
            }
            if ((existing = directory.findFile((rawClassName = CreateClassUtil.extractClassName(className)) + ".java")) instanceof PsiJavaFile) {
                PsiClass[] classes = ((PsiJavaFile)existing).getClasses();
                if (classes.length > 0) {
                    return classes[0];
                }
                return null;
            }
            if (templateName.equals(DEFAULT_CLASS_TEMPLATE)) {
                aClass = JavaDirectoryService.getInstance().createClass(directory, rawClassName);
            } else {
                FileTemplateManager fileTemplateManager = FileTemplateManager.getInstance();
                FileTemplate fileTemplate = fileTemplateManager.getJ2eeTemplate(templateName);
                LOG.assertTrue(fileTemplate != null, (Object)(templateName + " not found"));
                String text = fileTemplate.getText(attributes);
                aClass = JavaCreateFromTemplateHandler.createClassOrInterface(project, directory, text, true, fileTemplate.getExtension());
            }
            return (PsiClass)JavaCodeStyleManager.getInstance((Project)project).shortenClassReferences((PsiElement)aClass);
        }
        catch (IOException e) {
            throw new IncorrectOperationException(e.toString(), (Exception)e);
        }
    }

    @NotNull
    private static PsiDirectory createParentDirectories(@NotNull PsiDirectory directoryRoot, @NotNull String className) throws IncorrectOperationException {
        if (directoryRoot == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/util/CreateClassUtil", "createParentDirectories"));
        }
        if (className == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/util/CreateClassUtil", "createParentDirectories"));
        }
        PsiPackage currentPackage = JavaDirectoryService.getInstance().getPackage(directoryRoot);
        String packagePrefix = currentPackage == null ? null : currentPackage.getQualifiedName() + ".";
        String packageName = CreateClassUtil.extractPackage(packagePrefix != null && className.startsWith(packagePrefix) ? className.substring(packagePrefix.length()) : className);
        StringTokenizer tokenizer = new StringTokenizer(packageName, ".");
        while (tokenizer.hasMoreTokens()) {
            String packagePart = tokenizer.nextToken();
            PsiDirectory subdirectory = directoryRoot.findSubdirectory(packagePart);
            if (subdirectory == null) {
                directoryRoot.checkCreateSubdirectory(packagePart);
                subdirectory = directoryRoot.createSubdirectory(packagePart);
            }
            directoryRoot = subdirectory;
        }
        PsiDirectory psiDirectory = directoryRoot;
        if (psiDirectory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/util/CreateClassUtil", "createParentDirectories"));
        }
        return psiDirectory;
    }

    public static String extractClassName(String fqName) {
        return StringUtil.getShortName((String)fqName);
    }

    public static String extractPackage(String fqName) {
        int i = fqName.lastIndexOf(46);
        return i == -1 ? "" : fqName.substring(0, i);
    }

    public static String makeFQName(String aPackage, String className) {
        String fq = aPackage;
        if (!"".equals(aPackage)) {
            fq = fq + ".";
        }
        fq = fq + className;
        return fq;
    }

    @Nullable
    public static PsiClass createClassNamed(String newClassName, String templateName, @NotNull PsiDirectory directory) throws IncorrectOperationException {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/util/CreateClassUtil", "createClassNamed"));
        }
        return CreateClassUtil.createClassNamed(newClassName, FileTemplateManager.getInstance().getDefaultProperties(directory.getProject()), templateName, directory);
    }

    @Nullable
    public static PsiClass createClassNamed(String newClassName, Map classProperties, String templateName, @NotNull PsiDirectory directory) throws IncorrectOperationException {
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/util/CreateClassUtil", "createClassNamed"));
        }
        Properties defaultProperties = FileTemplateManager.getInstance().getDefaultProperties(directory.getProject());
        Properties properties = new Properties(defaultProperties);
        properties.putAll((Map<?, ?>)classProperties);
        return CreateClassUtil.createClassNamed(newClassName, properties, templateName, directory);
    }

    @Nullable
    private static PsiClass createClassNamed(@Nullable String newClassName, @NotNull Properties properties, String templateName, @NotNull PsiDirectory directory) throws IncorrectOperationException {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/util/CreateClassUtil", "createClassNamed"));
        }
        if (directory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/util/CreateClassUtil", "createClassNamed"));
        }
        if (newClassName == null) {
            return null;
        }
        String className = CreateClassUtil.extractClassName(newClassName);
        properties.setProperty(CLASS_NAME_PROPERTY, className);
        properties.setProperty(INTERFACE_NAME_PROPERTY, className);
        return CreateClassUtil.createClassFromTemplate(properties, templateName, directory, newClassName);
    }

    @Nullable
    public static PsiClass createClassFromCustomTemplate(@Nullable PsiDirectory classDirectory, @Nullable Module module, String className, String templateName) {
        if (classDirectory == null && module != null) {
            try {
                classDirectory = PackageUtil.findOrCreateDirectoryForPackage(module, "", null, false);
            }
            catch (IncorrectOperationException e) {
                return null;
            }
        }
        if (classDirectory == null) {
            return null;
        }
        try {
            Properties properties = ApplicationManager.getApplication().isUnitTestMode() ? new Properties() : FileTemplateManager.getInstance().getDefaultProperties(classDirectory.getProject());
            return CreateClassUtil.createClassNamed(className, new Properties(properties), templateName, classDirectory);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
            return null;
        }
    }
}

