/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.templateLanguages;

import com.intellij.lexer.Lexer;
import com.intellij.lexer.LexerPosition;
import com.intellij.psi.tree.IElementType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TemplateBlackAndWhiteLexer
extends Lexer {
    private final Lexer myBaseLexer;
    private final Lexer myTemplateLexer;
    private final IElementType myTemplateElementType;
    private final IElementType myOuterElementType;
    private int myTemplateState = 0;

    public TemplateBlackAndWhiteLexer(Lexer baseLexer, Lexer templateLexer, IElementType templateElementType, IElementType outerElementType) {
        this.myTemplateLexer = templateLexer;
        this.myBaseLexer = baseLexer;
        this.myTemplateElementType = templateElementType;
        this.myOuterElementType = outerElementType;
    }

    public void start(@NotNull CharSequence buffer, int startOffset, int endOffset, int initialState) {
        if (buffer == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/templateLanguages/TemplateBlackAndWhiteLexer", "start"));
        }
        this.myBaseLexer.start(buffer, startOffset, endOffset, initialState);
        this.setupTemplateToken();
    }

    @NotNull
    public CharSequence getBufferSequence() {
        CharSequence charSequence = this.myBaseLexer.getBufferSequence();
        if (charSequence == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateBlackAndWhiteLexer", "getBufferSequence"));
        }
        return charSequence;
    }

    public int getState() {
        return this.myBaseLexer.getState();
    }

    @Nullable
    public IElementType getTokenType() {
        IElementType tokenType = this.myBaseLexer.getTokenType();
        if (tokenType == null) {
            return null;
        }
        return tokenType == this.myTemplateElementType ? this.myTemplateElementType : this.myOuterElementType;
    }

    public int getTokenStart() {
        IElementType tokenType = this.myBaseLexer.getTokenType();
        if (tokenType == this.myTemplateElementType) {
            return this.myTemplateLexer.getTokenStart();
        }
        return this.myBaseLexer.getTokenStart();
    }

    public int getTokenEnd() {
        IElementType tokenType = this.myBaseLexer.getTokenType();
        if (tokenType == this.myTemplateElementType) {
            return this.myTemplateLexer.getTokenEnd();
        }
        return this.myBaseLexer.getTokenEnd();
    }

    public void advance() {
        IElementType tokenType = this.myBaseLexer.getTokenType();
        if (tokenType == this.myTemplateElementType) {
            this.myTemplateLexer.advance();
            this.myTemplateState = this.myTemplateLexer.getState();
            if (this.myTemplateLexer.getTokenType() != null) {
                return;
            }
        }
        this.myBaseLexer.advance();
        this.setupTemplateToken();
    }

    private void setupTemplateToken() {
        IElementType tokenType;
        while ((tokenType = this.myBaseLexer.getTokenType()) == this.myTemplateElementType) {
            this.myTemplateLexer.start(this.myBaseLexer.getBufferSequence(), this.myBaseLexer.getTokenStart(), this.myBaseLexer.getTokenEnd(), this.myTemplateState);
            if (this.myTemplateLexer.getTokenType() != null) {
                return;
            }
            this.myBaseLexer.advance();
        }
        return;
    }

    @NotNull
    public LexerPosition getCurrentPosition() {
        Position position = new Position(this.myTemplateLexer.getCurrentPosition(), this.myBaseLexer.getCurrentPosition());
        if (position == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/templateLanguages/TemplateBlackAndWhiteLexer", "getCurrentPosition"));
        }
        return position;
    }

    public void restore(@NotNull LexerPosition position) {
        if (position == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/templateLanguages/TemplateBlackAndWhiteLexer", "restore"));
        }
        Position p = (Position)position;
        this.myBaseLexer.restore(p.getBasePosition());
        LexerPosition templatePos = p.getTemplatePosition();
        if (templatePos != null && templatePos.getOffset() < this.myTemplateLexer.getBufferEnd()) {
            this.myTemplateLexer.restore(templatePos);
        } else {
            this.setupTemplateToken();
        }
    }

    public int getBufferEnd() {
        return this.myBaseLexer.getBufferEnd();
    }

    private static class Position
    implements LexerPosition {
        private final LexerPosition myTemplatePosition;
        private final LexerPosition myBasePosition;

        public Position(LexerPosition templatePosition, LexerPosition jspPosition) {
            this.myTemplatePosition = templatePosition;
            this.myBasePosition = jspPosition;
        }

        public int getOffset() {
            return Math.max(this.myBasePosition.getOffset(), this.myTemplatePosition.getOffset());
        }

        public LexerPosition getTemplatePosition() {
            return this.myTemplatePosition;
        }

        public LexerPosition getBasePosition() {
            return this.myBasePosition;
        }

        public int getState() {
            throw new UnsupportedOperationException("Method getState is not yet implemented in " + this.getClass().getName());
        }
    }
}

