/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.stubs;

import com.intellij.lang.Language;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.components.PersistentStateComponent;
import com.intellij.openapi.components.RoamingType;
import com.intellij.openapi.components.State;
import com.intellij.openapi.components.Storage;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.fileEditor.FileDocumentManager;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.LanguageFileType;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullComputable;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.psi.LanguageSubstitutors;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.source.PsiFileImpl;
import com.intellij.psi.impl.source.PsiFileWithStubSupport;
import com.intellij.psi.impl.source.tree.FileElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.StringStubIndexExtension;
import com.intellij.psi.stubs.StubIdList;
import com.intellij.psi.stubs.StubIndex;
import com.intellij.psi.stubs.StubIndexExtension;
import com.intellij.psi.stubs.StubIndexKey;
import com.intellij.psi.stubs.StubIndexState;
import com.intellij.psi.stubs.StubProcessingHelper;
import com.intellij.psi.stubs.StubTree;
import com.intellij.psi.stubs.StubUpdatingIndex;
import com.intellij.util.CommonProcessors;
import com.intellij.util.Processor;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.FileBasedIndexImpl;
import com.intellij.util.indexing.ID;
import com.intellij.util.indexing.IdFilter;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.indexing.IndexStorage;
import com.intellij.util.indexing.MapIndexStorage;
import com.intellij.util.indexing.MapReduceIndex;
import com.intellij.util.indexing.MemoryIndexStorage;
import com.intellij.util.indexing.StorageException;
import com.intellij.util.indexing.ValueContainer;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import gnu.trove.THashMap;
import gnu.trove.THashSet;
import gnu.trove.TObjectIntHashMap;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.Lock;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@State(name="FileBasedIndex", roamingType=RoamingType.DISABLED, storages={@Storage(file="$APP_CONFIG$/stubIndex.xml")})
public class StubIndexImpl
extends StubIndex
implements ApplicationComponent,
PersistentStateComponent<StubIndexState> {
    private static final AtomicReference<Boolean> ourForcedClean = new AtomicReference<Object>(null);
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.stubs.StubIndexImpl");
    private final Map<StubIndexKey<?, ?>, MyIndex<?>> myIndices = new THashMap();
    private final TObjectIntHashMap<ID<?, ?>> myIndexIdToVersionMap = new TObjectIntHashMap();
    private final StubProcessingHelper myStubProcessingHelper;
    private StubIndexState myPreviouslyRegistered;

    public StubIndexImpl(FileBasedIndex fileBasedIndex) throws IOException {
        boolean forceClean = Boolean.TRUE == ourForcedClean.getAndSet(Boolean.FALSE);
        StubIndexExtension[] extensions = (StubIndexExtension[])Extensions.getExtensions((ExtensionPointName)StubIndexExtension.EP_NAME);
        boolean needRebuild = false;
        for (StubIndexExtension extension : extensions) {
            needRebuild |= this.registerIndexer(extension, forceClean);
        }
        if (needRebuild) {
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                StubIndexImpl.requestRebuild();
            } else {
                final Throwable e = new Throwable();
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        StubIndexImpl.forceRebuild(e);
                    }
                }, ModalityState.NON_MODAL);
            }
        }
        this.dropUnregisteredIndices();
        this.myStubProcessingHelper = new StubProcessingHelper(fileBasedIndex);
    }

    @Nullable
    public static StubIndexImpl getInstanceOrInvalidate() {
        if (ourForcedClean.compareAndSet(null, Boolean.TRUE)) {
            return null;
        }
        return (StubIndexImpl)StubIndexImpl.getInstance();
    }

    private <K> boolean registerIndexer(@NotNull StubIndexExtension<K, ?> extension, boolean forceClean) throws IOException {
        if (extension == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubIndexImpl", "registerIndexer"));
        }
        StubIndexKey indexKey = extension.getKey();
        int version = extension.getVersion();
        this.myIndexIdToVersionMap.put((Object)indexKey, version);
        File versionFile = IndexInfrastructure.getVersionFile(indexKey);
        boolean versionFileExisted = versionFile.exists();
        File indexRootDir = IndexInfrastructure.getIndexRootDir(indexKey);
        boolean needRebuild = false;
        if (forceClean || IndexInfrastructure.versionDiffers(versionFile, version)) {
            String[] children = indexRootDir.list();
            boolean bl = needRebuild = !forceClean && (versionFileExisted || children != null && children.length > 0);
            if (needRebuild) {
                LOG.info("Version has changed for stub index " + extension.getKey() + ". The index will be rebuilt.");
            }
            FileUtil.delete((File)indexRootDir);
            IndexInfrastructure.rewriteVersion(versionFile, version);
        }
        for (int attempt = 0; attempt < 2; ++attempt) {
            try {
                MapIndexStorage storage = new MapIndexStorage(IndexInfrastructure.getStorageFile(indexKey), extension.getKeyDescriptor(), new StubIdExternalizer(), extension.getCacheSize(), false, extension instanceof StringStubIndexExtension && ((StringStubIndexExtension)extension).traceKeyHashToVirtualFileMapping());
                MemoryIndexStorage memStorage = new MemoryIndexStorage(storage);
                this.myIndices.put(indexKey, new MyIndex(memStorage));
                break;
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                needRebuild = true;
                FileUtil.delete((File)indexRootDir);
                IndexInfrastructure.rewriteVersion(versionFile, version);
                continue;
            }
        }
        return needRebuild;
    }

    @NotNull
    public <Key, Psi extends PsiElement> Collection<Psi> get(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, GlobalSearchScope scope) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubIndexImpl", "get"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/StubIndexImpl", "get"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/stubs/StubIndexImpl", "get"));
        }
        Collection<Psi> collection = this.get(indexKey, key, project, scope, null);
        if (collection == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubIndexImpl", "get"));
        }
        return collection;
    }

    public <Key, Psi extends PsiElement> Collection<Psi> get(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, GlobalSearchScope scope, IdFilter filter) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubIndexImpl", "get"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/StubIndexImpl", "get"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/stubs/StubIndexImpl", "get"));
        }
        SmartList result = new SmartList();
        this.process(indexKey, key, project, scope, filter, (Processor)new CommonProcessors.CollectProcessor((Collection)result));
        return result;
    }

    public <Key, Psi extends PsiElement> boolean processElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, @NotNull Project project, GlobalSearchScope scope, Class<Psi> requiredClass, @NotNull Processor<? super Psi> processor) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubIndexImpl", "processElements"));
        }
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/StubIndexImpl", "processElements"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/stubs/StubIndexImpl", "processElements"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "5", "com/intellij/psi/stubs/StubIndexImpl", "processElements"));
        }
        return this.processElements(indexKey, key, project, scope, null, requiredClass, processor);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <Key, Psi extends PsiElement> boolean processElements(@NotNull StubIndexKey<Key, Psi> indexKey, @NotNull Key key, final @NotNull Project project, final @Nullable GlobalSearchScope scope, @Nullable IdFilter idFilter, final Class<Psi> requiredClass, final @NotNull Processor<? super Psi> processor) {
        block12: {
            boolean bl;
            if (indexKey == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubIndexImpl", "processElements"));
            }
            if (key == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/StubIndexImpl", "processElements"));
            }
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/stubs/StubIndexImpl", "processElements"));
            }
            if (processor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "6", "com/intellij/psi/stubs/StubIndexImpl", "processElements"));
            }
            FileBasedIndexImpl fileBasedIndex = (FileBasedIndexImpl)FileBasedIndex.getInstance();
            fileBasedIndex.ensureUpToDate(StubUpdatingIndex.INDEX_ID, project, scope);
            final PersistentFS fs = (PersistentFS)ManagingFS.getInstance();
            MyIndex<?> index = this.myIndices.get(indexKey);
            try {
                FileBasedIndexImpl.disableUpToDateCheckForCurrentThread();
                index.getReadLock().lock();
                ValueContainer<StubIdList> container = index.getData(key);
                final IdFilter finalIdFilter = idFilter != null ? idFilter : fileBasedIndex.projectIndexableFiles(project);
                bl = container.forEach(new ValueContainer.ContainerAction<StubIdList>(){

                    @Override
                    public boolean perform(int id, @NotNull StubIdList value) {
                        if (value == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/StubIndexImpl$2", "perform"));
                        }
                        ProgressManager.checkCanceled();
                        if (finalIdFilter != null && !finalIdFilter.containsFileId(id)) {
                            return true;
                        }
                        VirtualFile file = IndexInfrastructure.findFileByIdIfCached(fs, id);
                        if (file == null || scope != null && !scope.contains(file)) {
                            return true;
                        }
                        return StubIndexImpl.this.myStubProcessingHelper.processStubsInFile(project, file, value, processor, requiredClass);
                    }
                });
                index.getReadLock().unlock();
            }
            catch (Throwable throwable) {
                try {
                    index.getReadLock().unlock();
                    FileBasedIndexImpl.enableUpToDateCheckForCurrentThread();
                    throw throwable;
                }
                catch (StorageException e) {
                    StubIndexImpl.forceRebuild(e);
                    break block12;
                }
                catch (RuntimeException e) {
                    Throwable cause = FileBasedIndexImpl.getCauseToRebuildIndex(e);
                    if (cause != null) {
                        StubIndexImpl.forceRebuild(cause);
                        break block12;
                    }
                    throw e;
                }
                catch (AssertionError ae) {
                    StubIndexImpl.forceRebuild((Throwable)((Object)ae));
                }
            }
            FileBasedIndexImpl.enableUpToDateCheckForCurrentThread();
            return bl;
        }
        return true;
    }

    private static void forceRebuild(@NotNull Throwable e) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubIndexImpl", "forceRebuild"));
        }
        LOG.info(e);
        FileBasedIndex.getInstance().scheduleRebuild(StubUpdatingIndex.INDEX_ID, e);
    }

    private static void requestRebuild() {
        FileBasedIndex.getInstance().requestRebuild(StubUpdatingIndex.INDEX_ID);
    }

    @NotNull
    public <K> Collection<K> getAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Project project) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubIndexImpl", "getAllKeys"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/StubIndexImpl", "getAllKeys"));
        }
        THashSet allKeys = ContainerUtil.newTroveSet();
        this.processAllKeys(indexKey, project, (Processor<K>)new CommonProcessors.CollectProcessor((Collection)allKeys));
        THashSet tHashSet = allKeys;
        if (tHashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubIndexImpl", "getAllKeys"));
        }
        return tHashSet;
    }

    public <K> boolean processAllKeys(@NotNull StubIndexKey<K, ?> indexKey, @NotNull Project project, Processor<K> processor) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubIndexImpl", "processAllKeys"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/StubIndexImpl", "processAllKeys"));
        }
        return this.processAllKeys(indexKey, processor, GlobalSearchScope.allScope((Project)project), null);
    }

    public <K> boolean processAllKeys(@NotNull StubIndexKey<K, ?> indexKey, Processor<K> processor, GlobalSearchScope scope, @Nullable IdFilter idFilter) {
        if (indexKey == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubIndexImpl", "processAllKeys"));
        }
        FileBasedIndex.getInstance().ensureUpToDate(StubUpdatingIndex.INDEX_ID, scope.getProject(), scope);
        MyIndex<?> index = this.myIndices.get(indexKey);
        try {
            return index.processAllKeys(processor, scope, idFilter);
        }
        catch (StorageException e) {
            StubIndexImpl.forceRebuild(e);
        }
        catch (RuntimeException e) {
            Throwable cause = e.getCause();
            if (cause instanceof IOException || cause instanceof StorageException) {
                StubIndexImpl.forceRebuild(e);
            }
            throw e;
        }
        return true;
    }

    @NotNull
    public String getComponentName() {
        if ("Stub.IndexManager" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubIndexImpl", "getComponentName"));
        }
        return "Stub.IndexManager";
    }

    public void initComponent() {
    }

    public void disposeComponent() {
    }

    public void dispose() {
        for (MyIndex<?> index : this.myIndices.values()) {
            index.dispose();
        }
    }

    public void setDataBufferingEnabled(boolean enabled) {
        for (MyIndex<?> index : this.myIndices.values()) {
            IndexStorage indexStorage = ((MapReduceIndex)index).getStorage();
            ((MemoryIndexStorage)indexStorage).setBufferingEnabled(enabled);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cleanupMemoryStorage() {
        for (MyIndex<?> index : this.myIndices.values()) {
            IndexStorage indexStorage = ((MapReduceIndex)index).getStorage();
            index.getWriteLock().lock();
            try {
                ((MemoryIndexStorage)indexStorage).clearMemoryMap();
            }
            finally {
                index.getWriteLock().unlock();
            }
        }
    }

    public void clearAllIndices() {
        for (MyIndex<?> index : this.myIndices.values()) {
            try {
                index.clear();
            }
            catch (StorageException e) {
                LOG.error((Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }

    private void dropUnregisteredIndices() {
        HashSet indicesToDrop = new HashSet(this.myPreviouslyRegistered != null ? this.myPreviouslyRegistered.registeredIndices : Collections.emptyList());
        for (StubIndexKey<?, ?> key : this.myIndices.keySet()) {
            indicesToDrop.remove(key.toString());
        }
        for (String s : indicesToDrop) {
            FileUtil.delete((File)IndexInfrastructure.getIndexRootDir(ID.create((String)s)));
        }
    }

    @NotNull
    public StubIndexState getState() {
        StubIndexState stubIndexState = new StubIndexState(this.myIndices.keySet());
        if (stubIndexState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubIndexImpl", "getState"));
        }
        return stubIndexState;
    }

    public void loadState(StubIndexState state) {
        this.myPreviouslyRegistered = state;
    }

    public final Lock getWriteLock(StubIndexKey indexKey) {
        return this.myIndices.get(indexKey).getWriteLock();
    }

    public Collection<StubIndexKey> getAllStubIndexKeys() {
        return Collections.unmodifiableCollection(this.myIndices.keySet());
    }

    public void flush(StubIndexKey key) throws StorageException {
        MyIndex<?> index = this.myIndices.get(key);
        index.flush();
    }

    public <K> void updateIndex(@NotNull StubIndexKey key, int fileId, final @NotNull Map<K, StubIdList> oldValues, @NotNull Map<K, StubIdList> newValues) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubIndexImpl", "updateIndex"));
        }
        if (oldValues == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/stubs/StubIndexImpl", "updateIndex"));
        }
        if (newValues == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/stubs/StubIndexImpl", "updateIndex"));
        }
        try {
            MyIndex<?> index = this.myIndices.get(key);
            index.updateWithMap(fileId, newValues, (NotNullComputable<Collection<?>>)new NotNullComputable<Collection<K>>(){

                @NotNull
                public Collection<K> compute() {
                    Set set = oldValues.keySet();
                    if (set == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubIndexImpl$3", "compute"));
                    }
                    return set;
                }
            });
        }
        catch (StorageException e) {
            LOG.info((Throwable)e);
            StubIndexImpl.requestRebuild();
        }
    }

    protected <Psi extends PsiElement> void reportStubPsiMismatch(Psi psi, VirtualFile file, Class<Psi> requiredClass) {
        FileElement treeElement;
        PsiFile psiFile;
        if (file == null) {
            super.reportStubPsiMismatch(psi, file, requiredClass);
            return;
        }
        StringWriter writer = new StringWriter();
        PrintWriter out = new PrintWriter(writer);
        out.print("Invalid stub element type in index:");
        out.printf("\nfile: %s\npsiElement: %s\nrequiredClass: %s\nactualClass: %s", file, psi, requiredClass, psi.getClass());
        FileType fileType = file.getFileType();
        Language language = fileType instanceof LanguageFileType ? LanguageSubstitutors.INSTANCE.substituteLanguage(((LanguageFileType)fileType).getLanguage(), file, psi.getProject()) : Language.ANY;
        out.printf("\nvirtualFile: size:%s; stamp:%s; modCount:%s; fileType:%s; language:%s", file.getLength(), file.getModificationStamp(), file.getModificationCount(), fileType.getName(), language.getID());
        Document document = FileDocumentManager.getInstance().getCachedDocument(file);
        if (document != null) {
            boolean committed = PsiDocumentManager.getInstance((Project)psi.getProject()).isCommitted(document);
            boolean saved = !FileDocumentManager.getInstance().isDocumentUnsaved(document);
            out.printf("\ndocument: size:%s; stamp:%s; committed:%s; saved:%s", document.getTextLength(), document.getModificationStamp(), committed, saved);
        }
        if ((psiFile = psi.getManager().findFile(file)) != null) {
            out.printf("\npsiFile: size:%s; stamp:%s; class:%s; language:%s", psiFile.getTextLength(), psiFile.getViewProvider().getModificationStamp(), psiFile.getClass().getName(), psiFile.getLanguage().getID());
        }
        StubTree stub = psiFile instanceof PsiFileWithStubSupport ? ((PsiFileWithStubSupport)psiFile).getStubTree() : null;
        FileElement fileElement = treeElement = stub == null && psiFile instanceof PsiFileImpl ? ((PsiFileImpl)psiFile).getTreeElement() : null;
        if (stub != null) {
            out.printf("\nstubInfo: " + stub.getDebugInfo(), new Object[0]);
        } else if (treeElement != null) {
            out.printf("\nfileAST: size:%s; parsed:%s", treeElement.getTextLength(), treeElement.isParsed());
        }
        out.printf("\nindexing info: " + StubUpdatingIndex.getIndexingStampInfo(file), new Object[0]);
        LOG.error(writer.toString());
    }

    private static class MyIndex<K>
    extends MapReduceIndex<K, StubIdList, Void> {
        public MyIndex(IndexStorage<K, StubIdList> storage) {
            super(null, null, storage);
        }

        @Override
        public void updateWithMap(int inputId, @NotNull Map<K, StubIdList> newData, @NotNull NotNullComputable<Collection<K>> oldKeysGetter) throws StorageException {
            if (newData == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/StubIndexImpl$MyIndex", "updateWithMap"));
            }
            if (oldKeysGetter == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/stubs/StubIndexImpl$MyIndex", "updateWithMap"));
            }
            super.updateWithMap(inputId, newData, oldKeysGetter);
        }
    }

    private static class StubIdExternalizer
    implements DataExternalizer<StubIdList> {
        private StubIdExternalizer() {
        }

        public void save(@NotNull DataOutput out, @NotNull StubIdList value) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubIndexImpl$StubIdExternalizer", "save"));
            }
            if (value == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/stubs/StubIndexImpl$StubIdExternalizer", "save"));
            }
            int size = value.size();
            if (size == 0) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)Integer.MAX_VALUE);
            } else if (size == 1) {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)value.get(0));
            } else {
                DataInputOutputUtil.writeINT((DataOutput)out, (int)(-size));
                for (int i = 0; i < size; ++i) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)value.get(i));
                }
            }
        }

        @NotNull
        public StubIdList read(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/stubs/StubIndexImpl$StubIdExternalizer", "read"));
            }
            int size = DataInputOutputUtil.readINT((DataInput)in);
            if (size == Integer.MAX_VALUE) {
                StubIdList stubIdList = new StubIdList();
                if (stubIdList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubIndexImpl$StubIdExternalizer", "read"));
                }
                return stubIdList;
            }
            if (size >= 0) {
                StubIdList stubIdList = new StubIdList(size);
                if (stubIdList == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubIndexImpl$StubIdExternalizer", "read"));
                }
                return stubIdList;
            }
            size = -size;
            int[] result = new int[size];
            for (int i = 0; i < size; ++i) {
                result[i] = DataInputOutputUtil.readINT((DataInput)in);
            }
            StubIdList stubIdList = new StubIdList(result, size);
            if (stubIdList == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/stubs/StubIndexImpl$StubIdExternalizer", "read"));
            }
            return stubIdList;
        }
    }
}

