/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search.scope.packageSet;

import com.intellij.analysis.AnalysisScopeBundle;
import com.intellij.lexer.Lexer;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.psi.TokenType;
import com.intellij.psi.search.scope.packageSet.ComplementPackageSet;
import com.intellij.psi.search.scope.packageSet.IntersectionPackageSet;
import com.intellij.psi.search.scope.packageSet.NamedPackageSetReference;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import com.intellij.psi.search.scope.packageSet.PackageSetFactory;
import com.intellij.psi.search.scope.packageSet.PackageSetParserExtension;
import com.intellij.psi.search.scope.packageSet.ParsingException;
import com.intellij.psi.search.scope.packageSet.UnionPackageSet;
import com.intellij.psi.search.scope.packageSet.lexer.ScopeTokenTypes;
import com.intellij.psi.search.scope.packageSet.lexer.ScopesLexer;
import org.jetbrains.annotations.Nullable;

public class PackageSetFactoryImpl
extends PackageSetFactory {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.search.scope.packageSet.PackageSetFactoryImpl");

    public PackageSet compile(String text) throws ParsingException {
        ScopesLexer lexer = new ScopesLexer();
        lexer.start(text);
        return new Parser((Lexer)lexer).parse();
    }

    private static class Parser {
        private final Lexer myLexer;

        public Parser(Lexer lexer) {
            this.myLexer = lexer;
        }

        public PackageSet parse() throws ParsingException {
            PackageSet set = this.parseUnion();
            if (this.myLexer.getTokenType() != null) {
                this.error(AnalysisScopeBundle.message((String)"error.packageset.token.expectations", (Object[])new Object[]{this.getTokenText()}));
            }
            return set;
        }

        private PackageSet parseUnion() throws ParsingException {
            PackageSet result = this.parseIntersection();
            while (this.myLexer.getTokenType() == ScopeTokenTypes.OROR) {
                this.myLexer.advance();
                result = new UnionPackageSet(result, this.parseIntersection());
            }
            return result;
        }

        private PackageSet parseIntersection() throws ParsingException {
            PackageSet result = this.parseTerm();
            while (this.myLexer.getTokenType() == ScopeTokenTypes.ANDAND) {
                this.myLexer.advance();
                result = new IntersectionPackageSet(result, this.parseTerm());
            }
            return result;
        }

        private PackageSet parseTerm() throws ParsingException {
            if (this.myLexer.getTokenType() == ScopeTokenTypes.EXCL) {
                this.myLexer.advance();
                return new ComplementPackageSet(this.parseTerm());
            }
            if (this.myLexer.getTokenType() == ScopeTokenTypes.LPARENTH) {
                return this.parseParenthesized();
            }
            if (this.myLexer.getTokenType() == ScopeTokenTypes.IDENTIFIER && this.myLexer.getBufferSequence().charAt(this.myLexer.getTokenStart()) == '$') {
                NamedPackageSetReference namedPackageSetReference = new NamedPackageSetReference(this.getTokenText());
                this.myLexer.advance();
                return namedPackageSetReference;
            }
            return this.parsePattern();
        }

        private PackageSet parsePattern() throws ParsingException {
            PackageSetParserExtension extension;
            String scope = null;
            PackageSetParserExtension[] arr$ = (PackageSetParserExtension[])Extensions.getExtensions(PackageSetParserExtension.EP_NAME);
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && (scope = (extension = arr$[i$]).parseScope(this.myLexer)) == null; ++i$) {
            }
            if (scope == null) {
                this.error("Unknown scope type");
            }
            String modulePattern = this.parseModulePattern();
            if (this.myLexer.getTokenType() == ScopeTokenTypes.COLON) {
                this.myLexer.advance();
            }
            for (PackageSetParserExtension extension2 : (PackageSetParserExtension[])Extensions.getExtensions(PackageSetParserExtension.EP_NAME)) {
                PackageSet packageSet = extension2.parsePackageSet(this.myLexer, scope, modulePattern);
                if (packageSet == null) continue;
                return packageSet;
            }
            this.error("Unknown scope type");
            return null;
        }

        private String getTokenText() {
            int start = this.myLexer.getTokenStart();
            int end = this.myLexer.getTokenEnd();
            return ((Object)this.myLexer.getBufferSequence().subSequence(start, end)).toString();
        }

        @Nullable
        private String parseModulePattern() throws ParsingException {
            if (this.myLexer.getTokenType() != ScopeTokenTypes.LBRACKET) {
                return null;
            }
            this.myLexer.advance();
            StringBuffer pattern = new StringBuffer();
            while (true) {
                if (this.myLexer.getTokenType() == ScopeTokenTypes.RBRACKET || this.myLexer.getTokenType() == null) {
                    this.myLexer.advance();
                    break;
                }
                if (this.myLexer.getTokenType() == ScopeTokenTypes.ASTERISK) {
                    pattern.append("*");
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.IDENTIFIER || this.myLexer.getTokenType() == TokenType.WHITE_SPACE || this.myLexer.getTokenType() == ScopeTokenTypes.INTEGER_LITERAL) {
                    pattern.append(this.getTokenText());
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.DOT) {
                    pattern.append(".");
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.MINUS) {
                    pattern.append("-");
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.TILDE) {
                    pattern.append("~");
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.SHARP) {
                    pattern.append("#");
                } else if (this.myLexer.getTokenType() == ScopeTokenTypes.COLON) {
                    pattern.append(":");
                } else {
                    this.error(AnalysisScopeBundle.message((String)"error.packageset.token.expectations", (Object[])new Object[]{this.getTokenText()}));
                    break;
                }
                this.myLexer.advance();
            }
            if (pattern.length() == 0) {
                this.error(AnalysisScopeBundle.message((String)"error.packageset.pattern.expectations", (Object[])new Object[0]));
            }
            return pattern.toString();
        }

        private PackageSet parseParenthesized() throws ParsingException {
            LOG.assertTrue(this.myLexer.getTokenType() == ScopeTokenTypes.LPARENTH);
            this.myLexer.advance();
            PackageSet result = this.parseUnion();
            if (this.myLexer.getTokenType() != ScopeTokenTypes.RPARENTH) {
                this.error(AnalysisScopeBundle.message((String)"error.packageset.rparen.expected", (Object[])new Object[0]));
            }
            this.myLexer.advance();
            return result;
        }

        private void error(String message) throws ParsingException {
            throw new ParsingException(AnalysisScopeBundle.message((String)"error.packageset.position.parsing.error", (Object[])new Object[]{message, this.myLexer.getTokenStart() + 1}));
        }
    }
}

