/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.search;

import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndexFacade;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiBundle;
import com.intellij.psi.search.GlobalSearchScope;
import org.jetbrains.annotations.NotNull;

public class ProjectScopeImpl
extends GlobalSearchScope {
    private final FileIndexFacade myFileIndex;

    public ProjectScopeImpl(Project project, FileIndexFacade fileIndex) {
        super(project);
        this.myFileIndex = fileIndex;
    }

    public boolean contains(@NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/ProjectScopeImpl", "contains"));
        }
        if (file instanceof VirtualFileWindow) {
            return true;
        }
        if (this.myFileIndex.isInLibraryClasses(file) && !this.myFileIndex.isInSourceContent(file)) {
            return false;
        }
        return this.myFileIndex.isInContent(file);
    }

    public int compare(@NotNull VirtualFile file1, @NotNull VirtualFile file2) {
        if (file1 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/ProjectScopeImpl", "compare"));
        }
        if (file2 == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/search/ProjectScopeImpl", "compare"));
        }
        return 0;
    }

    public boolean isSearchInModuleContent(@NotNull Module aModule) {
        if (aModule == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/ProjectScopeImpl", "isSearchInModuleContent"));
        }
        return true;
    }

    public boolean isSearchInLibraries() {
        return false;
    }

    public String getDisplayName() {
        return PsiBundle.message((String)"psi.search.scope.project", (Object[])new Object[0]);
    }

    public String toString() {
        return this.getDisplayName();
    }

    @NotNull
    public GlobalSearchScope uniteWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/ProjectScopeImpl", "uniteWith"));
        }
        if (scope == this || !scope.isSearchInLibraries() || !scope.isSearchOutsideRootModel()) {
            ProjectScopeImpl projectScopeImpl = this;
            if (projectScopeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "uniteWith"));
            }
            return projectScopeImpl;
        }
        GlobalSearchScope globalSearchScope = super.uniteWith(scope);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "uniteWith"));
        }
        return globalSearchScope;
    }

    @NotNull
    public GlobalSearchScope intersectWith(@NotNull GlobalSearchScope scope) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/search/ProjectScopeImpl", "intersectWith"));
        }
        if (scope == this) {
            ProjectScopeImpl projectScopeImpl = this;
            if (projectScopeImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "intersectWith"));
            }
            return projectScopeImpl;
        }
        if (!scope.isSearchInLibraries()) {
            GlobalSearchScope globalSearchScope = scope;
            if (globalSearchScope == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "intersectWith"));
            }
            return globalSearchScope;
        }
        GlobalSearchScope globalSearchScope = super.intersectWith(scope);
        if (globalSearchScope == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/search/ProjectScopeImpl", "intersectWith"));
        }
        return globalSearchScope;
    }
}

