/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiAnnotationParameterList;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiNameValuePairStub;
import com.intellij.psi.impl.source.JavaStubPsiElement;
import com.intellij.psi.impl.source.SourceTreeToPsiMap;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.java.NameValuePairElement;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class PsiNameValuePairImpl
extends JavaStubPsiElement<PsiNameValuePairStub>
implements PsiNameValuePair {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.PsiNameValuePairImpl");

    public PsiNameValuePairImpl(@NotNull PsiNameValuePairStub stub) {
        if (stub == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "<init>"));
        }
        super(stub, (IStubElementType)JavaStubElementTypes.NAME_VALUE_PAIR);
    }

    public PsiNameValuePairImpl(@NotNull ASTNode node) {
        if (node == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "<init>"));
        }
        super(node);
    }

    @Override
    @NotNull
    public NameValuePairElement getNode() {
        NameValuePairElement nameValuePairElement = (NameValuePairElement)super.getNode();
        if (nameValuePairElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "getNode"));
        }
        return nameValuePairElement;
    }

    @Override
    public String getName() {
        PsiNameValuePairStub stub = (PsiNameValuePairStub)this.getStub();
        if (stub == null) {
            PsiIdentifier nameIdentifier = this.getNameIdentifier();
            return nameIdentifier == null ? null : nameIdentifier.getText();
        }
        return stub.getName();
    }

    public String getLiteralValue() {
        PsiNameValuePairStub stub = (PsiNameValuePairStub)this.getStub();
        return stub == null ? null : stub.getValue();
    }

    public PsiIdentifier getNameIdentifier() {
        ASTNode node = this.getNode().findChildByRole(9);
        return node == null ? null : (PsiIdentifier)node.getPsi();
    }

    public PsiAnnotationMemberValue getValue() {
        ASTNode node = this.getNode().findChildByRole(249);
        return node == null ? null : (PsiAnnotationMemberValue)node.getPsi();
    }

    @NotNull
    public PsiAnnotationMemberValue setValue(@NotNull PsiAnnotationMemberValue newValue) {
        if (newValue == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "setValue"));
        }
        this.getValue().replace((PsiElement)newValue);
        PsiAnnotationMemberValue psiAnnotationMemberValue = this.getValue();
        if (psiAnnotationMemberValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "setValue"));
        }
        return psiAnnotationMemberValue;
    }

    @Override
    public PsiReference getReference() {
        return new PsiReference(){

            @Nullable
            private PsiClass getReferencedClass() {
                LOG.assertTrue(PsiNameValuePairImpl.this.getParent() instanceof PsiAnnotationParameterList && PsiNameValuePairImpl.this.getParent().getParent() instanceof PsiAnnotation);
                PsiAnnotation annotation = (PsiAnnotation)PsiNameValuePairImpl.this.getParent().getParent();
                PsiJavaCodeReferenceElement nameRef = annotation.getNameReferenceElement();
                if (nameRef == null) {
                    return null;
                }
                PsiElement target = nameRef.resolve();
                return target instanceof PsiClass ? (PsiClass)target : null;
            }

            public PsiElement getElement() {
                PsiIdentifier nameIdentifier = PsiNameValuePairImpl.this.getNameIdentifier();
                if (nameIdentifier != null) {
                    return nameIdentifier;
                }
                return PsiNameValuePairImpl.this;
            }

            public TextRange getRangeInElement() {
                PsiIdentifier id = PsiNameValuePairImpl.this.getNameIdentifier();
                if (id != null) {
                    return new TextRange(0, id.getTextLength());
                }
                return TextRange.EMPTY_RANGE;
            }

            public PsiElement resolve() {
                PsiClass refClass = this.getReferencedClass();
                if (refClass == null) {
                    return null;
                }
                String name = PsiNameValuePairImpl.this.getName();
                if (name == null) {
                    name = "value";
                }
                MethodSignature signature = MethodSignatureUtil.createMethodSignature((String)name, (PsiType[])PsiType.EMPTY_ARRAY, (PsiTypeParameter[])PsiTypeParameter.EMPTY_ARRAY, (PsiSubstitutor)PsiSubstitutor.EMPTY);
                return MethodSignatureUtil.findMethodBySignature((PsiClass)refClass, (MethodSignature)signature, (boolean)false);
            }

            @NotNull
            public String getCanonicalText() {
                String name = PsiNameValuePairImpl.this.getName();
                String string = name != null ? name : "value";
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1", "getCanonicalText"));
                }
                return string;
            }

            public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
                PsiIdentifier nameIdentifier = PsiNameValuePairImpl.this.getNameIdentifier();
                if (nameIdentifier != null) {
                    PsiImplUtil.setName((PsiElement)nameIdentifier, newElementName);
                } else if (ElementType.ANNOTATION_MEMBER_VALUE_BIT_SET.contains(PsiNameValuePairImpl.this.getNode().getFirstChildNode().getElementType())) {
                    PsiElementFactory factory = JavaPsiFacade.getInstance((Project)PsiNameValuePairImpl.this.getProject()).getElementFactory();
                    nameIdentifier = factory.createIdentifier(newElementName);
                    PsiNameValuePairImpl.this.addBefore((PsiElement)nameIdentifier, SourceTreeToPsiMap.treeElementToPsi(PsiNameValuePairImpl.this.getNode().getFirstChildNode()));
                }
                return PsiNameValuePairImpl.this;
            }

            public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
                if (element == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1", "bindToElement"));
                }
                throw new IncorrectOperationException("Not implemented");
            }

            public boolean isReferenceTo(PsiElement element) {
                return element instanceof PsiMethod && element.equals(this.resolve());
            }

            @NotNull
            public Object[] getVariants() {
                if (ArrayUtil.EMPTY_OBJECT_ARRAY == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl$1", "getVariants"));
                }
                return ArrayUtil.EMPTY_OBJECT_ARRAY;
            }

            public boolean isSoft() {
                return false;
            }
        };
    }

    @Override
    public final void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/PsiNameValuePairImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitNameValuePair((PsiNameValuePair)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    public String toString() {
        return "PsiNameValuePair";
    }
}

