/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.impl.PsiImplUtil;
import com.intellij.psi.impl.source.Constants;
import com.intellij.psi.impl.source.tree.ChildRole;
import com.intellij.psi.impl.source.tree.CompositeElement;
import com.intellij.psi.impl.source.tree.Factory;
import com.intellij.psi.impl.source.tree.LeafElement;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.impl.source.tree.TreeElement;
import com.intellij.psi.tree.IElementType;
import com.intellij.util.CharTable;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ParameterListElement
extends CompositeElement
implements Constants {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.tree.java.ParameterListElement");

    public ParameterListElement() {
        super(PARAMETER_LIST);
    }

    @Override
    public TreeElement addInternal(TreeElement first, ASTNode last, ASTNode anchor, Boolean before) {
        if (anchor == null) {
            if (before == null || before.booleanValue()) {
                anchor = this.findChildByRole(25);
                before = Boolean.TRUE;
            } else {
                anchor = this.findChildByRole(24);
                before = Boolean.FALSE;
            }
        }
        TreeElement firstAdded = super.addInternal(first, last, anchor, before);
        if (first == last && first.getElementType() == PARAMETER) {
            LeafElement comma;
            ASTNode child;
            CharTable treeCharTab = SharedImplUtil.findCharTableByTree(this);
            for (child = first.getTreeNext(); child != null && child.getElementType() != COMMA; child = child.getTreeNext()) {
                if (child.getElementType() != PARAMETER) continue;
                comma = Factory.createSingleLeafElement(COMMA, ",", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, first, Boolean.FALSE);
                break;
            }
            for (child = first.getTreePrev(); child != null && child.getElementType() != COMMA; child = child.getTreePrev()) {
                if (child.getElementType() != PARAMETER) continue;
                comma = Factory.createSingleLeafElement(COMMA, ",", 0, 1, treeCharTab, this.getManager());
                super.addInternal(comma, comma, child, Boolean.FALSE);
                break;
            }
        }
        try {
            CodeStyleManager.getInstance((Project)this.getManager().getProject()).reformat(this.getPsi());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        return firstAdded;
    }

    @Override
    public void deleteChildInternal(@NotNull ASTNode child) {
        TreeElement newFirstNodeInsideParens;
        if (child == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/ParameterListElement", "deleteChildInternal"));
        }
        TreeElement oldLastNodeInsideParens = this.getLastNodeInsideParens();
        TreeElement oldFirstNodeInsideParens = this.getFirstNodeInsideParens();
        if (child.getElementType() == PARAMETER) {
            ASTNode next = PsiImplUtil.skipWhitespaceAndComments(child.getTreeNext());
            if (next != null && next.getElementType() == COMMA) {
                this.deleteChildInternal(next);
            } else {
                ASTNode prev = PsiImplUtil.skipWhitespaceAndCommentsBack(child.getTreePrev());
                if (prev != null && prev.getElementType() == COMMA) {
                    this.deleteChildInternal(prev);
                }
            }
        }
        super.deleteChildInternal(child);
        TreeElement newLastNodeInsideParens = this.getLastNodeInsideParens();
        if (newLastNodeInsideParens != null && newLastNodeInsideParens.getElementType() == WHITE_SPACE) {
            if (oldLastNodeInsideParens.getElementType() != WHITE_SPACE) {
                this.deleteChildInternal(newLastNodeInsideParens);
            } else {
                this.replaceChild(newLastNodeInsideParens, (ASTNode)oldLastNodeInsideParens.clone());
            }
        }
        if ((newFirstNodeInsideParens = this.getFirstNodeInsideParens()) != null && newFirstNodeInsideParens.getElementType() == WHITE_SPACE) {
            if (oldFirstNodeInsideParens == null || oldFirstNodeInsideParens.getElementType() != WHITE_SPACE) {
                this.deleteChildInternal(newFirstNodeInsideParens);
            } else {
                this.replaceChild(newFirstNodeInsideParens, (ASTNode)oldFirstNodeInsideParens.clone());
            }
        }
        try {
            CodeStyleManager.getInstance((Project)this.getManager().getProject()).reformat(this.getPsi());
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }

    @Override
    public ASTNode findChildByRole(int role) {
        LOG.assertTrue(ChildRole.isUnique(role));
        switch (role) {
            default: {
                return null;
            }
            case 24: {
                if (this.getFirstChildNode().getElementType() == LPARENTH) {
                    return this.getFirstChildNode();
                }
                return null;
            }
            case 25: 
        }
        if (this.getLastChildNode().getElementType() == RPARENTH) {
            return this.getLastChildNode();
        }
        return null;
    }

    @Override
    public int getChildRole(ASTNode child) {
        LOG.assertTrue(child.getTreeParent() == this);
        IElementType i = child.getElementType();
        if (i == PARAMETER) {
            return 15;
        }
        if (i == COMMA) {
            return 23;
        }
        if (i == LPARENTH) {
            return this.getChildRole(child, 24);
        }
        if (i == RPARENTH) {
            return this.getChildRole(child, 25);
        }
        return 0;
    }

    @Nullable
    private TreeElement getLastNodeInsideParens() {
        TreeElement lastNode = this.getLastChildNode();
        return lastNode.getElementType() == RPARENTH ? lastNode.getTreePrev() : null;
    }

    @Nullable
    private TreeElement getFirstNodeInsideParens() {
        TreeElement firstNode = this.getFirstChildNode();
        return firstNode.getElementType() == LPARENTH ? firstNode.getTreeNext() : null;
    }
}

