/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.java;

import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodReferenceExpression;
import com.intellij.psi.PsiMethodReferenceUtil;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.source.resolve.ParameterTypeInferencePolicy;
import com.intellij.psi.impl.source.resolve.ResolveCache;
import com.intellij.psi.impl.source.resolve.graphInference.FunctionalInterfaceParameterizationUtil;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import com.intellij.psi.infos.CandidateInfo;
import com.intellij.psi.infos.ClassCandidateInfo;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.scope.JavaScopeProcessorEvent;
import com.intellij.psi.scope.PsiConflictResolver;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.scope.conflictResolvers.JavaMethodsConflictResolver;
import com.intellij.psi.scope.processor.MethodCandidatesProcessor;
import com.intellij.psi.util.MethodSignature;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.SmartList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class MethodReferenceResolver
implements ResolveCache.PolyVariantResolver<PsiMethodReferenceExpression> {
    private static final Logger LOG = Logger.getInstance((String)("#" + MethodReferenceResolver.class.getName()));

    MethodReferenceResolver() {
    }

    @Override
    @NotNull
    public ResolveResult[] resolve(final @NotNull PsiMethodReferenceExpression reference, boolean incompleteCode) {
        if (reference == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver", "resolve"));
        }
        PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult = PsiMethodReferenceUtil.getQualifierResolveResult((PsiMethodReferenceExpression)reference);
        final PsiClass containingClass = qualifierResolveResult.getContainingClass();
        PsiSubstitutor substitutor = qualifierResolveResult.getSubstitutor();
        if (containingClass != null) {
            PsiElement element = reference.getReferenceNameElement();
            boolean isConstructor = reference.isConstructor();
            if (element instanceof PsiIdentifier || isConstructor) {
                if (isConstructor && (containingClass.isEnum() || containingClass.hasModifierProperty("abstract"))) {
                    if (JavaResolveResult.EMPTY_ARRAY == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver", "resolve"));
                    }
                    return JavaResolveResult.EMPTY_ARRAY;
                }
                final PsiType functionalInterfaceType = this.getInterfaceType(reference);
                PsiClassType.ClassResolveResult resolveResult = PsiUtil.resolveGenericsClassInType((PsiType)functionalInterfaceType);
                final PsiMethod interfaceMethod = LambdaUtil.getFunctionalInterfaceMethod((PsiClassType.ClassResolveResult)resolveResult);
                PsiSubstitutor functionalInterfaceSubstitutor = interfaceMethod != null ? LambdaUtil.getSubstitutor((PsiMethod)interfaceMethod, (PsiClassType.ClassResolveResult)resolveResult) : null;
                MethodSignature signature = interfaceMethod != null ? interfaceMethod.getSignature(functionalInterfaceSubstitutor) : null;
                final PsiType interfaceMethodReturnType = LambdaUtil.getFunctionalInterfaceReturnType((PsiType)functionalInterfaceType);
                if (isConstructor && containingClass.getConstructors().length == 0) {
                    JavaResolveResult[] javaResolveResultArray;
                    boolean isArray;
                    if (interfaceMethod != null) {
                        PsiClassType returnType = MethodReferenceResolver.composeReturnType(containingClass, substitutor);
                        InferenceSession session = new InferenceSession(containingClass.getTypeParameters(), substitutor, reference.getManager(), null);
                        if (!session.isProperType((PsiType)returnType) || !session.isProperType(interfaceMethodReturnType)) {
                            session.registerReturnTypeConstraints((PsiType)returnType, interfaceMethodReturnType);
                            substitutor = session.infer();
                        }
                    }
                    ClassCandidateInfo candidateInfo = null;
                    boolean bl = isArray = containingClass == JavaPsiFacade.getElementFactory((Project)reference.getProject()).getArrayClass(PsiUtil.getLanguageLevel((PsiElement)containingClass));
                    if (signature == null || !isArray && (containingClass.getContainingClass() == null || !MethodReferenceResolver.isLocatedInStaticContext(containingClass, reference)) && signature.getParameterTypes().length == 0 || isArray && MethodReferenceResolver.arrayCreationSignature(signature)) {
                        candidateInfo = new ClassCandidateInfo((PsiElement)containingClass, substitutor);
                    }
                    if (candidateInfo == null) {
                        javaResolveResultArray = JavaResolveResult.EMPTY_ARRAY;
                    } else {
                        JavaResolveResult[] javaResolveResultArray2 = new JavaResolveResult[1];
                        javaResolveResultArray = javaResolveResultArray2;
                        javaResolveResultArray2[0] = candidateInfo;
                    }
                    if (javaResolveResultArray == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver", "resolve"));
                    }
                    return javaResolveResultArray;
                }
                PsiConflictResolver conflictResolver = this.createResolver(reference, qualifierResolveResult, interfaceMethod, signature);
                MethodCandidatesProcessor processor = new MethodCandidatesProcessor((PsiElement)reference, reference.getContainingFile(), new PsiConflictResolver[]{conflictResolver}, (List)new SmartList()){

                    @Override
                    protected boolean acceptVarargs() {
                        return true;
                    }

                    @Override
                    protected MethodCandidateInfo createCandidateInfo(final @NotNull PsiMethod method, final @NotNull PsiSubstitutor substitutor, boolean staticProblem, boolean accessible, final boolean varargs) {
                        if (method == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1", "createCandidateInfo"));
                        }
                        if (substitutor == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1", "createCandidateInfo"));
                        }
                        PsiExpressionList argumentList = this.getArgumentList();
                        PsiType[] typeParameters = reference.getTypeParameters();
                        return new MethodCandidateInfo((PsiElement)method, substitutor, !accessible, staticProblem, (PsiElement)argumentList, this.myCurrentFileContext, argumentList != null ? argumentList.getExpressionTypes() : null, (PsiType[])(typeParameters.length > 0 ? typeParameters : null), this.getLanguageLevel()){

                            public boolean isVarargs() {
                                return varargs;
                            }

                            @NotNull
                            public PsiSubstitutor inferTypeArguments(@NotNull ParameterTypeInferencePolicy policy, boolean includeReturnConstraint) {
                                if (policy == null) {
                                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1$1", "inferTypeArguments"));
                                }
                                PsiSubstitutor psiSubstitutor = this.inferTypeArguments();
                                if (psiSubstitutor == null) {
                                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$1$1", "inferTypeArguments"));
                                }
                                return psiSubstitutor;
                            }

                            private PsiSubstitutor inferTypeArguments() {
                                PsiSubstitutor psiSubstitutor;
                                if (interfaceMethod == null) {
                                    return substitutor;
                                }
                                InferenceSession session = new InferenceSession(method.getTypeParameters(), substitutor, reference.getManager(), (PsiElement)reference);
                                MethodCandidateInfo.CurrentCandidateProperties methodSubstitutorPair = MethodCandidateInfo.getCurrentMethod((PsiElement)reference.getParent());
                                if (methodSubstitutorPair != null) {
                                    session.initBounds(methodSubstitutorPair.getMethod().getTypeParameters());
                                }
                                if ((psiSubstitutor = session.collectApplicabilityConstraints(reference, this, functionalInterfaceType)) != null) {
                                    return psiSubstitutor;
                                }
                                if (!session.repeatInferencePhases(false)) {
                                    return substitutor;
                                }
                                if (interfaceMethodReturnType != PsiType.VOID && interfaceMethodReturnType != null) {
                                    PsiType returnType;
                                    Object object = returnType = method.isConstructor() ? MethodReferenceResolver.composeReturnType(containingClass, substitutor) : method.getReturnType();
                                    if (returnType != null) {
                                        session.registerReturnTypeConstraints(returnType, interfaceMethodReturnType);
                                    }
                                }
                                return session.infer(method.getParameterList().getParameters(), null, null);
                            }
                        };
                    }
                };
                processor.setIsConstructor(isConstructor);
                processor.setName(isConstructor ? containingClass.getName() : element.getText());
                PsiExpression expression = reference.getQualifierExpression();
                if (expression == null || !(expression.getType() instanceof PsiArrayType)) {
                    processor.setAccessClass(containingClass);
                }
                if (qualifierResolveResult.isReferenceTypeQualified() && MethodReferenceResolver.isLocatedInStaticContext(containingClass, reference)) {
                    processor.handleEvent((PsiScopeProcessor.Event)JavaScopeProcessorEvent.START_STATIC, null);
                }
                ResolveState state = ResolveState.initial().put(PsiSubstitutor.KEY, (Object)substitutor);
                containingClass.processDeclarations((PsiScopeProcessor)processor, state, (PsiElement)reference, (PsiElement)reference);
                JavaResolveResult[] javaResolveResultArray = processor.getResult();
                if (javaResolveResultArray == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver", "resolve"));
                }
                return javaResolveResultArray;
            }
        }
        if (JavaResolveResult.EMPTY_ARRAY == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver", "resolve"));
        }
        return JavaResolveResult.EMPTY_ARRAY;
    }

    private static boolean isLocatedInStaticContext(PsiClass containingClass, PsiMethodReferenceExpression reference) {
        PsiClass gContainingClass = containingClass.getContainingClass();
        if (gContainingClass == null || !containingClass.hasModifierProperty("static")) {
            PsiClass aClass = null;
            if (PsiTreeUtil.isAncestor((PsiElement)(gContainingClass != null ? gContainingClass : containingClass), (PsiElement)reference, (boolean)false)) {
                PsiClass psiClass = aClass = gContainingClass != null ? gContainingClass : containingClass;
            }
            if (PsiUtil.getEnclosingStaticElement((PsiElement)reference, aClass) != null) {
                return true;
            }
        }
        return false;
    }

    protected PsiType getInterfaceType(PsiMethodReferenceExpression reference) {
        PsiType functionalInterfaceType = null;
        Map map = (Map)PsiMethodReferenceUtil.ourRefs.get();
        if (map != null) {
            functionalInterfaceType = FunctionalInterfaceParameterizationUtil.getGroundTargetType((PsiType)map.get(reference));
        }
        if (functionalInterfaceType == null) {
            functionalInterfaceType = reference.getFunctionalInterfaceType();
        }
        return functionalInterfaceType;
    }

    protected PsiConflictResolver createResolver(PsiMethodReferenceExpression referenceExpression, PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, PsiMethod interfaceMethod, MethodSignature signature) {
        return new MethodReferenceConflictResolver(referenceExpression, qualifierResolveResult, signature, interfaceMethod != null && interfaceMethod.isVarArgs());
    }

    private static PsiClassType composeReturnType(PsiClass containingClass, PsiSubstitutor substitutor) {
        boolean isRawSubst = PsiUtil.isRawSubstitutor((PsiTypeParameterListOwner)containingClass, (PsiSubstitutor)substitutor);
        return JavaPsiFacade.getElementFactory((Project)containingClass.getProject()).createType(containingClass, isRawSubst ? PsiSubstitutor.EMPTY : substitutor);
    }

    private static boolean arrayCreationSignature(MethodSignature signature) {
        PsiType[] parameterTypes = signature.getParameterTypes();
        return parameterTypes.length == 1 && parameterTypes[0] != null && TypeConversionUtil.isAssignable((PsiType)PsiType.INT, (PsiType)parameterTypes[0]);
    }

    private static class MethodReferenceConflictResolver
    extends JavaMethodsConflictResolver {
        private final MethodSignature mySignature;
        private PsiMethodReferenceExpression myReferenceExpression;
        private final PsiMethodReferenceUtil.QualifierResolveResult myQualifierResolveResult;
        private final boolean myFunctionalMethodVarArgs;

        private MethodReferenceConflictResolver(PsiMethodReferenceExpression referenceExpression, PsiMethodReferenceUtil.QualifierResolveResult qualifierResolveResult, @Nullable MethodSignature signature, boolean varArgs) {
            super((PsiElement)referenceExpression, signature != null ? signature.getParameterTypes() : PsiType.EMPTY_ARRAY, PsiUtil.getLanguageLevel((PsiElement)referenceExpression));
            this.myReferenceExpression = referenceExpression;
            this.myQualifierResolveResult = qualifierResolveResult;
            this.myFunctionalMethodVarArgs = varArgs;
            this.mySignature = signature;
        }

        @Override
        protected int getPertinentApplicabilityLevel(MethodCandidateInfo conflict) {
            return conflict.isVarargs() ? 2 : 3;
        }

        @Override
        @Nullable
        public CandidateInfo resolveConflict(@NotNull List<CandidateInfo> conflicts) {
            if (conflicts == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/java/MethodReferenceResolver$MethodReferenceConflictResolver", "resolveConflict"));
            }
            if (this.mySignature == null) {
                return null;
            }
            this.checkSameSignatures(conflicts);
            MethodReferenceConflictResolver.checkAccessStaticLevels(conflicts, true);
            PsiType[] parameterTypes = this.mySignature.getParameterTypes();
            boolean hasReceiver = PsiMethodReferenceUtil.hasReceiver((PsiType[])parameterTypes, (PsiMethodReferenceUtil.QualifierResolveResult)this.myQualifierResolveResult, (PsiMethodReferenceExpression)this.myReferenceExpression);
            ArrayList<CandidateInfo> firstCandidates = new ArrayList<CandidateInfo>();
            ArrayList<CandidateInfo> secondCandidates = new ArrayList<CandidateInfo>();
            for (CandidateInfo conflict : conflicts) {
                if (!(conflict instanceof MethodCandidateInfo)) continue;
                PsiMethod psiMethod = ((MethodCandidateInfo)conflict).getElement();
                PsiSubstitutor substitutor = conflict.getSubstitutor();
                PsiType[] signatureParameterTypes2 = psiMethod.getSignature(substitutor).getParameterTypes();
                boolean varargs = ((MethodCandidateInfo)conflict).isVarargs();
                if (varargs && (!psiMethod.isVarArgs() || this.myFunctionalMethodVarArgs)) continue;
                if ((varargs || parameterTypes.length == signatureParameterTypes2.length) && PsiMethodReferenceUtil.isCorrectAssignment((PsiType[])signatureParameterTypes2, (PsiType[])parameterTypes, (PsiSubstitutor)substitutor, (boolean)varargs, (int)0)) {
                    firstCandidates.add(conflict);
                }
                if (!hasReceiver || !varargs && parameterTypes.length != signatureParameterTypes2.length + 1 || !PsiMethodReferenceUtil.isCorrectAssignment((PsiType[])signatureParameterTypes2, (PsiType[])parameterTypes, (PsiSubstitutor)substitutor, (boolean)varargs, (int)1)) continue;
                secondCandidates.add(conflict);
            }
            if (this.myQualifierResolveResult.isReferenceTypeQualified() && this.myReferenceExpression.getReferenceNameElement() instanceof PsiIdentifier) {
                CandidateInfo candidateInfo = MethodReferenceConflictResolver.filterStaticCorrectCandidates(firstCandidates, secondCandidates, true);
                if (candidateInfo != null) {
                    return candidateInfo;
                }
                candidateInfo = MethodReferenceConflictResolver.filterStaticCorrectCandidates(secondCandidates, firstCandidates, false);
                if (candidateInfo != null) {
                    return candidateInfo;
                }
            }
            if (this.resolveConflicts(firstCandidates, secondCandidates, 3)) {
                return !firstCandidates.isEmpty() ? (CandidateInfo)firstCandidates.get(0) : (CandidateInfo)secondCandidates.get(0);
            }
            if (this.resolveConflicts(firstCandidates, secondCandidates, 2)) {
                return !firstCandidates.isEmpty() ? (CandidateInfo)firstCandidates.get(0) : (CandidateInfo)secondCandidates.get(0);
            }
            conflicts.clear();
            firstCandidates.addAll(secondCandidates);
            conflicts.addAll(firstCandidates);
            return null;
        }

        private boolean resolveConflicts(List<CandidateInfo> firstCandidates, List<CandidateInfo> secondCandidates, int applicabilityLevel) {
            this.checkApplicability(firstCandidates);
            this.checkSpecifics(firstCandidates, applicabilityLevel, this.myLanguageLevel);
            this.checkApplicability(secondCandidates);
            this.checkSpecifics(secondCandidates, applicabilityLevel, this.myLanguageLevel);
            return firstCandidates.size() + secondCandidates.size() == 1;
        }

        @Override
        protected boolean nonComparable(CandidateInfo method, CandidateInfo conflict) {
            if (method == conflict) {
                return true;
            }
            PsiElement psiElement = method.getElement();
            PsiElement conflictElement = conflict.getElement();
            return psiElement instanceof PsiMethod && conflictElement instanceof PsiMethod && ((PsiMethod)psiElement).getParameterList().getParametersCount() != ((PsiMethod)conflictElement).getParameterList().getParametersCount();
        }

        private static CandidateInfo filterStaticCorrectCandidates(List<CandidateInfo> firstCandidates, List<CandidateInfo> secondCandidates, boolean shouldBeStatic) {
            CandidateInfo candidateInfo;
            PsiElement element;
            if (firstCandidates.size() == 1 && (element = (candidateInfo = firstCandidates.get(0)).getElement()) instanceof PsiMethod) {
                boolean isStatic = ((PsiMethod)element).hasModifierProperty("static");
                if (shouldBeStatic && isStatic || !shouldBeStatic && !isStatic) {
                    for (CandidateInfo secondCandidate : secondCandidates) {
                        PsiElement psiElement = secondCandidate.getElement();
                        if (!(psiElement instanceof PsiMethod)) continue;
                        boolean oppositeStatic = ((PsiMethod)psiElement).hasModifierProperty("static");
                        if ((!shouldBeStatic || oppositeStatic) && (shouldBeStatic || !oppositeStatic)) continue;
                        return null;
                    }
                    return candidateInfo;
                }
            }
            return null;
        }
    }
}

