/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.tree.injected;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.StdLanguages;
import com.intellij.lang.injection.ConcatenationAwareInjector;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.injection.MultiHostInjector;
import com.intellij.lang.injection.MultiHostRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.extensions.ExtensionPoint;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.InjectedLanguagePlaces;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.LanguageInjector;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiComment;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.source.tree.PsiCommentImpl;
import com.intellij.psi.impl.source.tree.injected.JavaConcatenationInjectorManager;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlAttributeValue;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlText;
import com.intellij.psi.xml.XmlTokenType;
import com.intellij.util.ArrayUtil;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class MyTestInjector {
    private final PsiManager myPsiManager;

    public MyTestInjector(PsiManager psiManager) {
        this.myPsiManager = psiManager;
    }

    public void injectAll(Disposable parent) {
        MyTestInjector.injectVariousStuffEverywhere(parent, this.myPsiManager);
        Project project = this.myPsiManager.getProject();
        Language ql = Language.findLanguageByID((String)"JPAQL");
        Language js = Language.findLanguageByID((String)"JavaScript");
        MyTestInjector.registerForStringVarInitializer(parent, project, ql, "ql", null, null);
        MyTestInjector.registerForStringVarInitializer(parent, project, ql, "qlPrefixed", "xxx", null);
        MyTestInjector.registerForStringVarInitializer(parent, project, js, "js", null, null);
        MyTestInjector.registerForStringVarInitializer(parent, project, js, "jsSeparated", " + ", " + 'separator'");
        MyTestInjector.registerForStringVarInitializer(parent, project, js, "jsBrokenPrefix", "xx ", "");
        MyTestInjector.registerForStringVarInitializer(parent, project, Language.findLanguageByID((String)"Oracle"), "oracle", null, null);
        MyTestInjector.registerForParameterValue(parent, project, Language.findLanguageByID((String)"Groovy"), "groovy");
    }

    private static void registerForParameterValue(Disposable parent, final Project project, final Language language, final String paramName) {
        if (language == null) {
            return;
        }
        final ConcatenationAwareInjector injector = new ConcatenationAwareInjector(){

            public void getLanguagesToInject(@NotNull MultiHostRegistrar injectionPlacesRegistrar, PsiElement ... operands) {
                if (injectionPlacesRegistrar == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/MyTestInjector$1", "getLanguagesToInject"));
                }
                if (operands == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/MyTestInjector$1", "getLanguagesToInject"));
                }
                PsiElement operand = operands[0];
                if (!(operand instanceof PsiLiteralExpression)) {
                    return;
                }
                if (!(operand.getParent() instanceof PsiExpressionList)) {
                    return;
                }
                PsiExpressionList expressionList = (PsiExpressionList)operand.getParent();
                int i = ArrayUtil.indexOf((Object[])expressionList.getExpressions(), (Object)operand);
                if (!(operand.getParent().getParent() instanceof PsiMethodCallExpression)) {
                    return;
                }
                PsiMethodCallExpression methodCallExpression = (PsiMethodCallExpression)operand.getParent().getParent();
                PsiMethod method = methodCallExpression.resolveMethod();
                if (method == null) {
                    return;
                }
                PsiParameter[] parameters = method.getParameterList().getParameters();
                if (i >= parameters.length) {
                    return;
                }
                PsiParameter parameter = parameters[i];
                if (!paramName.equals(parameter.getName())) {
                    return;
                }
                TextRange textRange = MyTestInjector.textRangeToInject((PsiLanguageInjectionHost)operand);
                injectionPlacesRegistrar.startInjecting(language).addPlace(null, null, (PsiLanguageInjectionHost)operand, textRange).doneInjecting();
            }
        };
        JavaConcatenationInjectorManager.getInstance(project).registerConcatenationInjector(injector);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                boolean b = JavaConcatenationInjectorManager.getInstance(project).unregisterConcatenationInjector(injector);
                assert (b);
            }
        });
    }

    private static void registerForStringVarInitializer(@NotNull Disposable parent, final @NotNull Project project, final Language language, final @NotNull @NonNls String varName, final @NonNls String prefix, final @NonNls String suffix) {
        if (parent == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/MyTestInjector", "registerForStringVarInitializer"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/MyTestInjector", "registerForStringVarInitializer"));
        }
        if (varName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/tree/injected/MyTestInjector", "registerForStringVarInitializer"));
        }
        if (language == null) {
            return;
        }
        final ConcatenationAwareInjector injector = new ConcatenationAwareInjector(){

            public void getLanguagesToInject(@NotNull MultiHostRegistrar injectionPlacesRegistrar, PsiElement ... operands) {
                if (injectionPlacesRegistrar == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/MyTestInjector$3", "getLanguagesToInject"));
                }
                if (operands == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/MyTestInjector$3", "getLanguagesToInject"));
                }
                PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)operands[0], PsiVariable.class);
                if (variable == null) {
                    return;
                }
                if (!varName.equals(variable.getName())) {
                    return;
                }
                if (!(operands[0] instanceof PsiLiteralExpression)) {
                    return;
                }
                boolean started = false;
                String prefixFromPrev = "";
                for (int i = 0; i < operands.length; ++i) {
                    PsiElement operand = operands[i];
                    if (!(operand instanceof PsiLiteralExpression)) continue;
                    Object value = ((PsiLiteralExpression)operand).getValue();
                    if (!(value instanceof String)) {
                        prefixFromPrev = prefixFromPrev + value;
                        continue;
                    }
                    TextRange textRange = MyTestInjector.textRangeToInject((PsiLanguageInjectionHost)operand);
                    if (!started) {
                        injectionPlacesRegistrar.startInjecting(language);
                        started = true;
                    }
                    injectionPlacesRegistrar.addPlace(prefixFromPrev + (i == 0 ? "" : (prefix == null ? "" : prefix)), i == operands.length - 1 ? null : suffix, (PsiLanguageInjectionHost)operand, textRange);
                    prefixFromPrev = "";
                }
                if (started) {
                    injectionPlacesRegistrar.doneInjecting();
                }
            }
        };
        JavaConcatenationInjectorManager.getInstance(project).registerConcatenationInjector(injector);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                boolean b = JavaConcatenationInjectorManager.getInstance(project).unregisterConcatenationInjector(injector);
                assert (b);
            }
        });
    }

    private static void injectVariousStuffEverywhere(Disposable parent, final PsiManager psiManager) {
        final Language ql = Language.findLanguageByID((String)"JPAQL");
        final Language js = Language.findLanguageByID((String)"JavaScript");
        if (ql == null || js == null) {
            return;
        }
        final Language ecma4 = Language.findLanguageByID((String)"ECMA Script Level 4");
        final MultiHostInjector myMultiHostInjector = new MultiHostInjector(){

            public void getLanguagesToInject(@NotNull MultiHostRegistrar registrar, @NotNull PsiElement context) {
                String attrName;
                if (registrar == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/MyTestInjector$5", "getLanguagesToInject"));
                }
                if (context == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/MyTestInjector$5", "getLanguagesToInject"));
                }
                XmlAttributeValue value = (XmlAttributeValue)context;
                PsiElement parent = value.getParent();
                if (parent instanceof XmlAttribute && "jsInBraces".equals(attrName = ((XmlAttribute)parent).getLocalName())) {
                    registrar.startInjecting(js);
                    String text = value.getText();
                    int index = 0;
                    while (text.indexOf(123, index) != -1) {
                        int lbrace = text.indexOf(123, index);
                        int rbrace = text.indexOf(125, index);
                        registrar.addPlace("", "", (PsiLanguageInjectionHost)value, new TextRange(lbrace + 1, rbrace));
                        index = rbrace + 1;
                    }
                    registrar.doneInjecting();
                }
            }

            @NotNull
            public List<? extends Class<? extends PsiElement>> elementsToInjectIn() {
                List<Class> list = Arrays.asList(XmlAttributeValue.class);
                if (list == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/tree/injected/MyTestInjector$5", "elementsToInjectIn"));
                }
                return list;
            }
        };
        InjectedLanguageManager.getInstance((Project)psiManager.getProject()).registerMultiHostInjector(myMultiHostInjector);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                boolean b = InjectedLanguageManager.getInstance((Project)psiManager.getProject()).unregisterMultiHostInjector(myMultiHostInjector);
                assert (b);
            }
        });
        final LanguageInjector myInjector = new LanguageInjector(){

            public void getLanguagesToInject(@NotNull PsiLanguageInjectionHost host, @NotNull InjectedLanguagePlaces placesToInject) {
                String text;
                String text2;
                XmlAttributeValue value;
                PsiElement parent;
                if (host == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/tree/injected/MyTestInjector$7", "getLanguagesToInject"));
                }
                if (placesToInject == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/tree/injected/MyTestInjector$7", "getLanguagesToInject"));
                }
                if (host instanceof XmlAttributeValue && (parent = (value = (XmlAttributeValue)host).getParent()) instanceof XmlAttribute) {
                    String attrName = ((XmlAttribute)parent).getLocalName();
                    if ("ql".equals(attrName)) {
                        MyTestInjector.inject(host, placesToInject, ql);
                        return;
                    }
                    if ("js".equals(attrName)) {
                        MyTestInjector.inject(host, placesToInject, js);
                        return;
                    }
                    if ("jsprefix".equals(attrName)) {
                        MyTestInjector.inject(host, placesToInject, js, "function foo(doc, window){", "}");
                        return;
                    }
                }
                if (host instanceof XmlText) {
                    int end;
                    int start;
                    XmlText xmlText = (XmlText)host;
                    XmlTag tag = xmlText.getParentTag();
                    if (tag == null) {
                        return;
                    }
                    if ("ql".equals(tag.getLocalName())) {
                        MyTestInjector.inject(host, placesToInject, ql);
                        return;
                    }
                    if ("js".equals(tag.getLocalName())) {
                        MyTestInjector.inject(host, placesToInject, js);
                        return;
                    }
                    if (ecma4 != null && "ecma4".equals(tag.getLocalName())) {
                        MyTestInjector.inject(host, placesToInject, ecma4);
                        return;
                    }
                    if ("jsprefix".equals(tag.getLocalName())) {
                        MyTestInjector.inject(host, placesToInject, js, "function foo(doc, window){", "}");
                        return;
                    }
                    if ("jsInHash".equals(tag.getLocalName()) && (text2 = xmlText.getText()).contains("#") && (start = text2.indexOf(35)) != (end = text2.lastIndexOf(35)) && start != -1) {
                        placesToInject.addPlace(js, new TextRange(start + 1, end), null, null);
                        return;
                    }
                }
                if (host instanceof PsiComment && ((PsiComment)host).getTokenType() == JavaTokenType.C_STYLE_COMMENT) {
                    text = host.getText();
                    String prefix = "/*\n * {{{\n";
                    String suffix = " }}}\n */";
                    if (text.startsWith(prefix) && text.endsWith(suffix)) {
                        String s = StringUtil.trimEnd((String)StringUtil.trimStart((String)text, (String)prefix), (String)suffix);
                        int off = 0;
                        while (!s.isEmpty()) {
                            String t = s.trim();
                            if (t.startsWith("*")) {
                                t = t.substring(1).trim();
                            }
                            int i = s.length() - t.length();
                            off += i;
                            int endOfLine = t.indexOf(10);
                            if (endOfLine == -1) {
                                endOfLine = t.length();
                            }
                            placesToInject.addPlace(js, TextRange.from((int)(prefix.length() + off), (int)endOfLine), "", "\n");
                            off += endOfLine;
                            s = s.substring(i + endOfLine);
                        }
                        return;
                    }
                }
                if (host instanceof PsiCommentImpl) {
                    text = host.getText();
                    if (text.startsWith("/*--{") && text.endsWith("}--*/")) {
                        TextRange textRange = new TextRange(4, text.length() - 4);
                        if (!(host.getParent() instanceof PsiMethod)) {
                            return;
                        }
                        PsiMethod method = (PsiMethod)host.getParent();
                        if (!method.hasModifierProperty("native") || !method.hasModifierProperty("public")) {
                            return;
                        }
                        String paramList = "";
                        for (PsiParameter parameter : method.getParameterList().getParameters()) {
                            if (!paramList.isEmpty()) {
                                paramList = paramList + ",";
                            }
                            paramList = paramList + parameter.getName();
                        }
                        String header = "function " + method.getName() + "(" + paramList + ") {";
                        Language gwt = Language.findLanguageByID((String)"GWT JavaScript");
                        placesToInject.addPlace(gwt, textRange, header, "}");
                        return;
                    }
                    parent = host.getParent();
                    if (parent instanceof PsiMethod && ((PsiMethod)parent).getName().equals("xml")) {
                        placesToInject.addPlace(StdLanguages.XML, new TextRange(2, host.getTextLength() - 2), null, null);
                        return;
                    }
                }
                if (host instanceof PsiLiteralExpression && ((PsiLiteralExpression)host).getValue() instanceof String) {
                    PsiVariable variable = (PsiVariable)PsiTreeUtil.getParentOfType((PsiElement)host, PsiVariable.class);
                    if (variable == null) {
                        return;
                    }
                    if (host.getParent() instanceof PsiPolyadicExpression) {
                        return;
                    }
                    if ("ql".equals(variable.getName())) {
                        placesToInject.addPlace(ql, MyTestInjector.textRangeToInject(host), null, null);
                    }
                    if ("xml".equals(variable.getName())) {
                        placesToInject.addPlace(StdLanguages.XML, MyTestInjector.textRangeToInject(host), null, null);
                    }
                    if ("js".equals(variable.getName())) {
                        placesToInject.addPlace(js, MyTestInjector.textRangeToInject(host), "function foo(doc,window) {", "}");
                    }
                    if ("lang".equals(variable.getName())) {
                        PsiClass aClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)variable, PsiClass.class);
                        text2 = (aClass = aClass.findInnerClassByName("Language", false)).getInitializers()[0].getBody().getFirstBodyElement().getNextSibling().getText().substring(2);
                        Language language = Language.findLanguageByID((String)text2);
                        if (language != null) {
                            placesToInject.addPlace(language, MyTestInjector.textRangeToInject(host), "", "");
                        }
                    }
                }
            }
        };
        final ExtensionPoint extensionPoint = Extensions.getRootArea().getExtensionPoint(LanguageInjector.EXTENSION_POINT_NAME);
        extensionPoint.registerExtension((Object)myInjector);
        Disposer.register((Disposable)parent, (Disposable)new Disposable(){

            public void dispose() {
                extensionPoint.unregisterExtension((Object)myInjector);
            }
        });
    }

    private static void inject(PsiLanguageInjectionHost host, InjectedLanguagePlaces placesToInject, Language language) {
        MyTestInjector.inject(host, placesToInject, language, null, null);
    }

    private static void inject(PsiLanguageInjectionHost host, InjectedLanguagePlaces placesToInject, Language language, @NonNls String prefix, String suffix) {
        TextRange insideQuotes = MyTestInjector.textRangeToInject(host);
        placesToInject.addPlace(language, insideQuotes, prefix, suffix);
    }

    public static TextRange textRangeToInject(PsiLanguageInjectionHost host) {
        ASTNode[] children = ((ASTNode)host).getChildren(null);
        ProperTextRange insideQuotes = new ProperTextRange(0, host.getTextLength());
        if (children.length > 1 && children[0].getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_START_DELIMITER) {
            insideQuotes = new ProperTextRange(children[1].getTextRange().getStartOffset() - host.getTextRange().getStartOffset(), insideQuotes.getEndOffset());
        }
        if (children.length > 1 && children[children.length - 1].getElementType() == XmlTokenType.XML_ATTRIBUTE_VALUE_END_DELIMITER) {
            insideQuotes = new ProperTextRange(insideQuotes.getStartOffset(), children[children.length - 2].getTextRange().getEndOffset() - host.getTextRange().getStartOffset());
        }
        if (host instanceof PsiLiteralExpression) {
            insideQuotes = new ProperTextRange(1, host.getTextLength() - 1);
        }
        return insideQuotes;
    }
}

