/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.providers;

import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiFileSystemItem;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.source.resolve.reference.impl.providers.FileReference;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class FileReferenceHelper {
    public static final ExtensionPointName<FileReferenceHelper> EP_NAME = new ExtensionPointName("com.intellij.psi.fileReferenceHelper");

    @NotNull
    public String trimUrl(@NotNull String url) {
        if (url == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper", "trimUrl"));
        }
        String string = url;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper", "trimUrl"));
        }
        return string;
    }

    @NotNull
    public List<? extends LocalQuickFix> registerFixes(FileReference reference) {
        List list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper", "registerFixes"));
        }
        return list;
    }

    @Nullable
    public PsiFileSystemItem getPsiFileSystemItem(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper", "getPsiFileSystemItem"));
        }
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        return FileReferenceHelper.getPsiFileSystemItem(psiManager, file);
    }

    public static PsiFileSystemItem getPsiFileSystemItem(PsiManager psiManager, VirtualFile file) {
        return file.isDirectory() ? psiManager.findDirectory(file) : psiManager.findFile(file);
    }

    @Nullable
    public PsiFileSystemItem findRoot(Project project, @NotNull VirtualFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper", "findRoot"));
        }
        return null;
    }

    @NotNull
    public Collection<PsiFileSystemItem> getRoots(@NotNull Module module) {
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper", "getRoots"));
        }
        List<PsiFileSystemItem> list = Collections.emptyList();
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/providers/FileReferenceHelper", "getRoots"));
        }
        return list;
    }

    @NotNull
    public abstract Collection<PsiFileSystemItem> getContexts(Project var1, @NotNull VirtualFile var2);

    public abstract boolean isMine(Project var1, @NotNull VirtualFile var2);

    public boolean isFallback() {
        return false;
    }
}

