/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl.manipulators;

import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.AbstractElementManipulator;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiDocTagValueManipulator
extends AbstractElementManipulator<PsiDocTag> {
    public PsiDocTag handleContentChange(@NotNull PsiDocTag tag, @NotNull TextRange range, String newContent) throws IncorrectOperationException {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiDocTagValueManipulator", "handleContentChange"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiDocTagValueManipulator", "handleContentChange"));
        }
        StringBuilder replacement = new StringBuilder(tag.getText());
        replacement.replace(range.getStartOffset(), range.getEndOffset(), newContent);
        return (PsiDocTag)tag.replace((PsiElement)JavaPsiFacade.getInstance((Project)tag.getProject()).getElementFactory().createDocTagFromText(replacement.toString()));
    }

    @NotNull
    public TextRange getRangeInElement(@NotNull PsiDocTag tag) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiDocTagValueManipulator", "getRangeInElement"));
        }
        PsiElement[] elements = tag.getDataElements();
        if (elements.length == 0) {
            PsiElement name = tag.getNameElement();
            int offset = name.getStartOffsetInParent() + name.getTextLength();
            TextRange textRange = new TextRange(offset, offset);
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiDocTagValueManipulator", "getRangeInElement"));
            }
            return textRange;
        }
        PsiElement first = elements[0];
        PsiElement last = elements[elements.length - 1];
        TextRange textRange = new TextRange(first.getStartOffsetInParent(), last.getStartOffsetInParent() + last.getTextLength());
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/manipulators/PsiDocTagValueManipulator", "getRangeInElement"));
        }
        return textRange;
    }
}

