/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.reference.impl;

import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementResolveResult;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.HashSet;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.LinkedHashSet;
import org.jetbrains.annotations.NotNull;

public class PsiMultiReference
implements PsiPolyVariantReference {
    public static final Comparator<PsiReference> COMPARATOR = new Comparator<PsiReference>(){

        @Override
        public int compare(PsiReference ref1, PsiReference ref2) {
            TextRange range2;
            if (ref1.isSoft() && !ref2.isSoft()) {
                return 1;
            }
            if (!ref1.isSoft() && ref2.isSoft()) {
                return -1;
            }
            boolean resolves1 = PsiMultiReference.resolves(ref1);
            boolean resolves2 = PsiMultiReference.resolves(ref2);
            if (resolves1 && !resolves2) {
                return -1;
            }
            if (!resolves1 && resolves2) {
                return 1;
            }
            TextRange range1 = ref1.getRangeInElement();
            if (TextRange.areSegmentsEqual((Segment)range1, (Segment)(range2 = ref2.getRangeInElement()))) {
                return 0;
            }
            if (range1.getStartOffset() >= range2.getStartOffset() && range1.getEndOffset() <= range2.getEndOffset()) {
                return -1;
            }
            if (range2.getStartOffset() >= range1.getStartOffset() && range2.getEndOffset() <= range1.getEndOffset()) {
                return 1;
            }
            return 0;
        }
    };
    private final PsiReference[] myReferences;
    private final PsiElement myElement;
    private boolean mySorted;

    private static boolean resolves(PsiReference ref1) {
        return ref1 instanceof PsiPolyVariantReference && ((PsiPolyVariantReference)ref1).multiResolve(false).length > 0 || ref1.resolve() != null;
    }

    public PsiMultiReference(@NotNull PsiReference[] references, PsiElement element) {
        if (references == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/reference/impl/PsiMultiReference", "<init>"));
        }
        assert (references.length > 0);
        this.myReferences = references;
        this.myElement = element;
    }

    public PsiReference[] getReferences() {
        return this.myReferences;
    }

    private synchronized PsiReference chooseReference() {
        if (!this.mySorted) {
            Arrays.sort(this.myReferences, COMPARATOR);
            this.mySorted = true;
        }
        return this.myReferences[0];
    }

    public PsiElement getElement() {
        return this.myElement;
    }

    public TextRange getRangeInElement() {
        PsiReference chosenRef = this.chooseReference();
        TextRange rangeInElement = chosenRef.getRangeInElement();
        PsiElement element = chosenRef.getElement();
        while (element != this.myElement) {
            rangeInElement = rangeInElement.shiftRight(element.getStartOffsetInParent());
            if (!((element = element.getParent()) instanceof PsiFile)) continue;
            break;
        }
        return rangeInElement;
    }

    public PsiElement resolve() {
        PsiReference reference = this.chooseReference();
        if (this.cannotChoose()) {
            ResolveResult[] results = this.multiResolve(false);
            return results.length == 1 ? results[0].getElement() : null;
        }
        return reference.resolve();
    }

    private boolean cannotChoose() {
        return this.myReferences.length > 1 && COMPARATOR.compare(this.myReferences[0], this.myReferences[1]) == 0;
    }

    @NotNull
    public String getCanonicalText() {
        String string = this.chooseReference().getCanonicalText();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/PsiMultiReference", "getCanonicalText"));
        }
        return string;
    }

    public PsiElement handleElementRename(String newElementName) throws IncorrectOperationException {
        return this.chooseReference().handleElementRename(newElementName);
    }

    public PsiElement bindToElement(@NotNull PsiElement element) throws IncorrectOperationException {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/reference/impl/PsiMultiReference", "bindToElement"));
        }
        return this.chooseReference().bindToElement(element);
    }

    public boolean isReferenceTo(PsiElement element) {
        for (PsiReference reference : this.myReferences) {
            if (!reference.isReferenceTo(element)) continue;
            return true;
        }
        return false;
    }

    @NotNull
    public Object[] getVariants() {
        HashSet variants = new HashSet();
        for (PsiReference ref : this.myReferences) {
            Object[] refVariants = ref.getVariants();
            ContainerUtil.addAll((Collection)variants, (Object[])refVariants);
        }
        Object[] objectArray = variants.toArray();
        if (objectArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/PsiMultiReference", "getVariants"));
        }
        return objectArray;
    }

    public boolean isSoft() {
        for (PsiReference reference : this.getReferences()) {
            if (reference.isSoft()) continue;
            return false;
        }
        return true;
    }

    @NotNull
    public ResolveResult[] multiResolve(boolean incompleteCode) {
        PsiReference[] refs = this.getReferences();
        LinkedHashSet<PsiElementResolveResult> result = new LinkedHashSet<PsiElementResolveResult>(refs.length);
        PsiElementResolveResult selfReference = null;
        for (PsiReference reference : refs) {
            if (reference instanceof PsiPolyVariantReference) {
                ContainerUtil.addAll(result, (Object[])((PsiPolyVariantReference)reference).multiResolve(incompleteCode));
                continue;
            }
            PsiElement resolved = reference.resolve();
            if (resolved == null) continue;
            PsiElementResolveResult rresult = new PsiElementResolveResult(resolved);
            if (this.getElement() == resolved) {
                selfReference = rresult;
                continue;
            }
            result.add(rresult);
        }
        if (result.isEmpty() && selfReference != null) {
            result.add(selfReference);
        }
        ResolveResult[] resolveResultArray = result.toArray(new ResolveResult[result.size()]);
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/reference/impl/PsiMultiReference", "multiResolve"));
        }
        return resolveResultArray;
    }

    public String toString() {
        return "PsiMultiReference{myReferences=" + Arrays.toString(this.myReferences) + '}';
    }
}

