/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve.graphInference;

import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceBound;
import com.intellij.psi.impl.source.resolve.graphInference.InferenceSession;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class InferenceVariable {
    private boolean myThrownBound = false;
    private final Map<InferenceBound, List<PsiType>> myBounds = new HashMap<InferenceBound, List<PsiType>>();
    private final PsiTypeParameter myParameter;
    private PsiType myInstantiation = PsiType.NULL;

    public PsiTypeParameter getParameter() {
        return this.myParameter;
    }

    public InferenceVariable(PsiTypeParameter parameter) {
        this.myParameter = parameter;
    }

    public PsiType getInstantiation() {
        return this.myInstantiation;
    }

    public void setInstantiation(PsiType instantiation) {
        this.myInstantiation = instantiation;
    }

    public boolean addBound(PsiType classType, InferenceBound inferenceBound) {
        int idx;
        List<PsiType> list = this.myBounds.get((Object)inferenceBound);
        if (list == null) {
            list = new ArrayList<PsiType>();
            this.myBounds.put(inferenceBound, list);
        }
        if ((idx = list.indexOf(classType)) < 0) {
            list.add(classType);
            return true;
        }
        return false;
    }

    public List<PsiType> getBounds(InferenceBound inferenceBound) {
        List<PsiType> bounds = this.myBounds.get((Object)inferenceBound);
        return bounds != null ? new ArrayList<PsiType>(bounds) : Collections.emptyList();
    }

    public Set<InferenceVariable> getDependencies(InferenceSession session) {
        LinkedHashSet<InferenceVariable> dependencies = new LinkedHashSet<InferenceVariable>();
        for (List<PsiType> boundTypes : this.myBounds.values()) {
            if (boundTypes == null) continue;
            for (PsiType psiType : boundTypes) {
                session.collectDependencies(psiType, dependencies);
            }
        }
        block2: for (InferenceVariable variable : session.getInferenceVariables()) {
            if (dependencies.contains(variable) || variable == this) continue;
            block3: for (List list : this.myBounds.values()) {
                if (list == null) continue;
                for (PsiType bound : list) {
                    HashSet<InferenceVariable> deps = new HashSet<InferenceVariable>();
                    session.collectDependencies(bound, deps);
                    if (deps.isEmpty()) continue block3;
                    if (!deps.contains(this)) continue;
                    dependencies.add(variable);
                    continue block2;
                }
            }
        }
        if (!session.hasCapture(this)) {
            return dependencies;
        }
        Iterator iterator = dependencies.iterator();
        while (iterator.hasNext()) {
            if (session.hasCapture((InferenceVariable)iterator.next())) continue;
            iterator.remove();
        }
        session.collectCaptureDependencies(this, dependencies);
        return dependencies;
    }

    public boolean isThrownBound() {
        return this.myThrownBound;
    }

    public void setThrownBound() {
        this.myThrownBound = true;
    }

    public void replaceBounds(InferenceBound boundType, LinkedHashSet<PsiType> bounds) {
    }

    public String toString() {
        return this.myParameter.toString();
    }
}

