/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.progress.ProgressIndicatorProvider;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Getter;
import com.intellij.openapi.util.RecursionGuard;
import com.intellij.openapi.util.RecursionManager;
import com.intellij.openapi.util.StaticGetter;
import com.intellij.openapi.util.Trinity;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiPolyVariantReference;
import com.intellij.psi.PsiReference;
import com.intellij.psi.ResolveResult;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.reference.SoftReference;
import com.intellij.util.containers.ConcurrentWeakHashMap;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.messages.MessageBus;
import java.util.concurrent.ConcurrentMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ResolveCache {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.source.resolve.ResolveCache");
    private final ConcurrentMap[] myMaps;
    private final RecursionGuard myGuard;
    private static final Getter<ResolveResult[]> EMPTY_POLY_RESULT = new StaticGetter((Object)ResolveResult.EMPTY_ARRAY);
    private static final Getter<Object> NULL_RESULT = new StaticGetter(null);

    public static ResolveCache getInstance(Project project) {
        ProgressIndicatorProvider.checkCanceled();
        return (ResolveCache)ServiceManager.getService((Project)project, ResolveCache.class);
    }

    public ResolveCache(@NotNull MessageBus messageBus) {
        if (messageBus == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/ResolveCache", "<init>"));
        }
        this.myMaps = new ConcurrentMap[8];
        this.myGuard = RecursionManager.createGuard((String)"resolveCache");
        for (int i = 0; i < this.myMaps.length; ++i) {
            this.myMaps[i] = ResolveCache.createWeakMap();
        }
        messageBus.connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, (Object)new AnyPsiChangeListener(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                ResolveCache.this.clearCache(isPhysical);
            }

            @Override
            public void afterPsiChanged(boolean isPhysical) {
            }
        });
    }

    private static <K, V> ConcurrentWeakHashMap<K, V> createWeakMap() {
        return new ConcurrentWeakHashMap(100, 0.75f, Runtime.getRuntime().availableProcessors(), ContainerUtil.canonicalStrategy());
    }

    public void clearCache(boolean isPhysical) {
        int startIndex;
        for (int i = startIndex = isPhysical ? 0 : 1; i < 2; ++i) {
            for (int j = 0; j < 2; ++j) {
                for (int k = 0; k < 2; ++k) {
                    this.myMaps[i * 4 + j * 2 + k].clear();
                }
            }
        }
    }

    @Nullable
    private <TRef extends PsiReference, TResult> TResult resolve(final @NotNull TRef ref, final @NotNull AbstractResolver<TRef, TResult> resolver, boolean needToPreventRecursion, final boolean incompleteCode, boolean isPoly, boolean isPhysical) {
        Object result;
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolve"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolve"));
        }
        ProgressIndicatorProvider.checkCanceled();
        ApplicationManager.getApplication().assertReadAccessAllowed();
        ConcurrentMap<TRef, Getter<TResult>> map = this.getMap(isPhysical, incompleteCode, isPoly);
        Getter reference = (Getter)map.get(ref);
        Object object = result = reference == null ? null : reference.get();
        if (result != null) {
            return (TResult)result;
        }
        RecursionGuard.StackStamp stamp = this.myGuard.markStack();
        result = needToPreventRecursion ? this.myGuard.doPreventingRecursion((Object)Trinity.create(ref, (Object)incompleteCode, (Object)isPoly), true, new Computable<TResult>(){

            public TResult compute() {
                return resolver.resolve(ref, incompleteCode);
            }
        }) : resolver.resolve(ref, incompleteCode);
        PsiElement element = result instanceof ResolveResult ? ((ResolveResult)result).getElement() : null;
        LOG.assertTrue(element == null || element.isValid(), result);
        if (stamp.mayCacheNow()) {
            ResolveCache.cache(ref, map, result, isPoly);
        }
        return (TResult)result;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        ResolveResult[] resolveResultArray = this.resolveWithCaching(ref, resolver, needToPreventRecursion, incompleteCode, ref.getElement().getContainingFile());
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        return resolveResultArray;
    }

    @NotNull
    public <T extends PsiPolyVariantReference> ResolveResult[] resolveWithCaching(@NotNull T ref, @NotNull PolyVariantResolver<T> resolver, boolean needToPreventRecursion, boolean incompleteCode, @NotNull PsiFile containingFile) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        ResolveResult[] result = (ResolveResult[])this.resolve((PsiReference)ref, (AbstractResolver)resolver, needToPreventRecursion, incompleteCode, true, containingFile.isPhysical());
        ResolveResult[] resolveResultArray = result == null ? ResolveResult.EMPTY_ARRAY : result;
        if (resolveResultArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        return resolveResultArray;
    }

    @Nullable
    public <T extends PsiPolyVariantReference> ResolveResult[] getCachedResults(@NotNull T ref, boolean physical, boolean incompleteCode, boolean isPoly) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/ResolveCache", "getCachedResults"));
        }
        ConcurrentMap map = this.getMap(physical, incompleteCode, isPoly);
        Getter reference = (Getter)map.get(ref);
        return reference == null ? null : (ResolveResult[])reference.get();
    }

    @Nullable
    public <TRef extends PsiReference, TResult> TResult resolveWithCaching(@NotNull TRef ref, @NotNull AbstractResolver<TRef, TResult> resolver, boolean needToPreventRecursion, boolean incompleteCode) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        if (resolver == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/ResolveCache", "resolveWithCaching"));
        }
        return this.resolve(ref, resolver, needToPreventRecursion, incompleteCode, false, ref.getElement().isPhysical());
    }

    private <TRef extends PsiReference, TResult> ConcurrentMap<TRef, Getter<TResult>> getMap(boolean physical, boolean incompleteCode, boolean isPoly) {
        return this.myMaps[(physical ? 0 : 1) * 4 + (incompleteCode ? 0 : 1) * 2 + (isPoly ? 0 : 1)];
    }

    private static <TRef extends PsiReference, TResult> void cache(@NotNull TRef ref, @NotNull ConcurrentMap<TRef, Getter<TResult>> map, TResult result, boolean isPoly) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/resolve/ResolveCache", "cache"));
        }
        if (map == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/resolve/ResolveCache", "cache"));
        }
        Object cached = (StaticGetter)map.get(ref);
        if (cached != null && cached.get() == result) {
            return;
        }
        cached = result == null ? NULL_RESULT : (isPoly && ((Object[])result).length == 0 ? (result.getClass() == ResolveResult[].class ? EMPTY_POLY_RESULT : new StaticGetter(result)) : new SoftGetter<TResult>(result));
        map.put(ref, (Getter<TResult>)cached);
    }

    private static class SoftGetter<T>
    extends SoftReference<T>
    implements Getter<T> {
        public SoftGetter(T referent) {
            super(referent);
        }
    }

    public static interface Resolver
    extends AbstractResolver<PsiReference, PsiElement> {
    }

    public static interface PolyVariantResolver<T extends PsiPolyVariantReference>
    extends AbstractResolver<T, ResolveResult[]> {
        @Override
        @NotNull
        public ResolveResult[] resolve(@NotNull T var1, boolean var2);
    }

    public static interface AbstractResolver<TRef extends PsiReference, TResult> {
        public TResult resolve(@NotNull TRef var1, boolean var2);
    }
}

