/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.codeStyle;

import com.intellij.lang.ASTNode;
import com.intellij.lang.Language;
import com.intellij.lang.java.JavaLanguage;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.codeStyle.CodeStyleSettingsManager;
import com.intellij.psi.codeStyle.CommonCodeStyleSettings;
import com.intellij.psi.impl.source.codeStyle.PreFormatProcessor;
import com.intellij.psi.impl.source.tree.ElementType;
import com.intellij.psi.impl.source.tree.JavaJspElementType;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class FieldInColumnsPreFormatProcessor
implements PreFormatProcessor {
    @Override
    @NotNull
    public TextRange process(@NotNull ASTNode element, @NotNull TextRange range) {
        ASTNode node;
        ASTNode node2;
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/codeStyle/FieldInColumnsPreFormatProcessor", "process"));
        }
        if (range == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/codeStyle/FieldInColumnsPreFormatProcessor", "process"));
        }
        PsiElement psi = element.getPsi();
        if (psi == null || !psi.isValid()) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/FieldInColumnsPreFormatProcessor", "process"));
            }
            return textRange;
        }
        PsiFile file = psi.getContainingFile();
        if (file == null) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/FieldInColumnsPreFormatProcessor", "process"));
            }
            return textRange;
        }
        Project project = psi.getProject();
        CommonCodeStyleSettings settings = CodeStyleSettingsManager.getInstance((Project)project).getCurrentSettings().getCommonSettings((Language)JavaLanguage.INSTANCE);
        if (!settings.ALIGN_GROUP_FIELD_DECLARATIONS) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/FieldInColumnsPreFormatProcessor", "process"));
            }
            return textRange;
        }
        PsiElement startElement = file.findElementAt(range.getStartOffset());
        if (startElement == null) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/FieldInColumnsPreFormatProcessor", "process"));
            }
            return textRange;
        }
        PsiField parent = (PsiField)PsiTreeUtil.getParentOfType((PsiElement)startElement, PsiField.class);
        if (parent == null) {
            TextRange textRange = range;
            if (textRange == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/FieldInColumnsPreFormatProcessor", "process"));
            }
            return textRange;
        }
        int startToUse = range.getStartOffset();
        for (PsiField f = parent; f != null && (node2 = f.getNode()) != null; f = f.getPrevSibling()) {
            if (JavaJspElementType.WHITE_SPACE_BIT_SET.contains(node2.getElementType()) || f instanceof PsiField) {
                startToUse = f.getTextRange().getStartOffset();
                continue;
            }
            if (!ElementType.JAVA_COMMENT_BIT_SET.contains(node2.getElementType())) break;
        }
        int endToUse = range.getEndOffset();
        for (PsiField f = parent; f != null && (node = f.getNode()) != null; f = f.getNextSibling()) {
            if (f instanceof PsiField) {
                endToUse = f.getTextRange().getEndOffset();
                continue;
            }
            if (!JavaJspElementType.WHITE_SPACE_BIT_SET.contains(node.getElementType()) && !ElementType.JAVA_COMMENT_BIT_SET.contains(node.getElementType())) break;
        }
        TextRange textRange = TextRange.from((int)startToUse, (int)endToUse);
        if (textRange == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/codeStyle/FieldInColumnsPreFormatProcessor", "process"));
        }
        return textRange;
    }
}

