/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source;

import com.intellij.lang.ASTNode;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiNameHelper;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiReferenceList;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeParameterList;
import com.intellij.psi.ResolveState;
import com.intellij.psi.impl.java.stubs.JavaStubElementTypes;
import com.intellij.psi.impl.java.stubs.PsiClassStub;
import com.intellij.psi.impl.source.PsiClassImpl;
import com.intellij.psi.impl.source.PsiJavaCodeReferenceElementImpl;
import com.intellij.psi.impl.source.tree.SharedImplUtil;
import com.intellij.psi.scope.PsiScopeProcessor;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.stubs.IStubElementType;
import com.intellij.reference.SoftReference;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class PsiAnonymousClassImpl
extends PsiClassImpl
implements PsiAnonymousClass {
    private SoftReference<PsiClassType> myCachedBaseType = null;

    public PsiAnonymousClassImpl(PsiClassStub stub) {
        super(stub, (IStubElementType)JavaStubElementTypes.ANONYMOUS_CLASS);
    }

    public PsiAnonymousClassImpl(ASTNode node) {
        super(node);
    }

    @Override
    protected Object clone() {
        PsiAnonymousClassImpl clone = (PsiAnonymousClassImpl)super.clone();
        clone.myCachedBaseType = null;
        return clone;
    }

    @Override
    public void subtreeChanged() {
        super.subtreeChanged();
        this.myCachedBaseType = null;
    }

    public PsiExpressionList getArgumentList() {
        return (PsiExpressionList)this.getNode().findChildByRoleAsPsiElement(73);
    }

    @NotNull
    public PsiJavaCodeReferenceElement getBaseClassReference() {
        PsiElement baseRef = this.getFirstChild();
        assert (baseRef instanceof PsiJavaCodeReferenceElement) : this.getText();
        PsiJavaCodeReferenceElement psiJavaCodeReferenceElement = (PsiJavaCodeReferenceElement)baseRef;
        if (psiJavaCodeReferenceElement == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "getBaseClassReference"));
        }
        return psiJavaCodeReferenceElement;
    }

    @NotNull
    public PsiClassType getBaseClassType() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub == null) {
            this.myCachedBaseType = null;
            PsiClassType psiClassType = this.getTypeByTree();
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "getBaseClassType"));
            }
            return psiClassType;
        }
        PsiClassType type = (PsiClassType)SoftReference.dereference(this.myCachedBaseType);
        if (type != null) {
            PsiClassType psiClassType = type;
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "getBaseClassType"));
            }
            return psiClassType;
        }
        if (!this.isInQualifiedNew()) {
            String refText = stub.getBaseClassReferenceText();
            assert (refText != null) : stub;
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory();
            PsiElement context = this.calcBasesResolveContext(PsiNameHelper.getShortClassName((String)refText), (PsiElement)this.getExtendsList());
            try {
                PsiJavaCodeReferenceElement ref = factory.createReferenceFromText(refText, context);
                ((PsiJavaCodeReferenceElementImpl)ref).setKindWhenDummy(1);
                type = factory.createType(ref);
            }
            catch (IncorrectOperationException e) {
                type = PsiType.getJavaLangObject((PsiManager)this.getManager(), (GlobalSearchScope)this.getResolveScope());
            }
            this.myCachedBaseType = new SoftReference((Object)type);
            PsiClassType psiClassType = type;
            if (psiClassType == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "getBaseClassType"));
            }
            return psiClassType;
        }
        PsiClassType psiClassType = this.getTypeByTree();
        if (psiClassType == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "getBaseClassType"));
        }
        return psiClassType;
    }

    private PsiClassType getTypeByTree() {
        return JavaPsiFacade.getInstance((Project)this.getProject()).getElementFactory().createType(this.getBaseClassReference());
    }

    @Override
    public PsiIdentifier getNameIdentifier() {
        return null;
    }

    @Override
    public String getQualifiedName() {
        return null;
    }

    @Override
    public PsiModifierList getModifierList() {
        return null;
    }

    @Override
    public boolean hasModifierProperty(@NotNull String name) {
        if (name == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "hasModifierProperty"));
        }
        return name.equals("final");
    }

    @Override
    public PsiReferenceList getExtendsList() {
        return null;
    }

    @Override
    public PsiReferenceList getImplementsList() {
        return null;
    }

    @Override
    public PsiClass getContainingClass() {
        return null;
    }

    @Override
    public boolean isInterface() {
        return false;
    }

    @Override
    public boolean isAnnotationType() {
        return false;
    }

    @Override
    public boolean isEnum() {
        return false;
    }

    @Override
    public PsiTypeParameterList getTypeParameterList() {
        return null;
    }

    @Override
    public PsiElement getOriginalElement() {
        return this;
    }

    @Override
    public void accept(@NotNull PsiElementVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "accept"));
        }
        if (visitor instanceof JavaElementVisitor) {
            ((JavaElementVisitor)visitor).visitAnonymousClass((PsiAnonymousClass)this);
        } else {
            visitor.visitElement((PsiElement)this);
        }
    }

    @Override
    public String toString() {
        return "PsiAnonymousClass";
    }

    @Override
    public boolean processDeclarations(@NotNull PsiScopeProcessor processor, @NotNull ResolveState state, PsiElement lastParent, @NotNull PsiElement place) {
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "processDeclarations"));
        }
        if (state == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "processDeclarations"));
        }
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/source/PsiAnonymousClassImpl", "processDeclarations"));
        }
        if (lastParent instanceof PsiExpressionList) {
            return true;
        }
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return true;
        }
        if (lastParent != null && lastParent.getParent() == this && lastParent == this.getBaseClassReference()) {
            return true;
        }
        return super.processDeclarations(processor, state, lastParent, place);
    }

    public boolean isInQualifiedNew() {
        PsiClassStub stub = (PsiClassStub)this.getStub();
        if (stub != null) {
            return stub.isAnonymousInQualifiedNew();
        }
        PsiElement parent = this.getParent();
        return parent instanceof PsiNewExpression && ((PsiNewExpression)parent).getQualifier() != null;
    }

    @Override
    public PsiElement getParent() {
        return SharedImplUtil.getParent(this.getNode());
    }
}

