/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.smartPointers;

import com.intellij.injected.editor.DocumentWindow;
import com.intellij.injected.editor.VirtualFileWindow;
import com.intellij.lang.Language;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.ProperTextRange;
import com.intellij.openapi.util.Segment;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.SmartPointerManager;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.SmartPsiFileRange;
import com.intellij.psi.impl.FreeThreadedFileViewProvider;
import com.intellij.psi.impl.smartPointers.SelfElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPointerElementInfo;
import com.intellij.psi.impl.smartPointers.SmartPsiElementPointerImpl;
import com.intellij.util.containers.ContainerUtil;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class InjectedSelfElementInfo
extends SelfElementInfo {
    private final SmartPsiFileRange myInjectedFileRangeInHostFile;
    private final Class<? extends PsiElement> anchorClass;
    private final Language anchorLanguage;

    InjectedSelfElementInfo(@NotNull Project project, @NotNull PsiElement injectedElement, @NotNull TextRange injectedRange, @NotNull PsiFile containingFile, @NotNull PsiElement hostContext) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        if (injectedElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        if (injectedRange == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        if (containingFile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        if (hostContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "<init>"));
        }
        super(project, hostContext);
        assert (containingFile.getViewProvider() instanceof FreeThreadedFileViewProvider) : "element parameter must be an injected element: " + injectedElement + "; " + containingFile;
        TextRange.assertProperRange((Segment)injectedRange);
        assert (containingFile.getTextRange().contains(injectedRange)) : "Injected range outside the file: " + injectedRange + "; file: " + containingFile.getTextRange();
        TextRange hostRange = InjectedLanguageManager.getInstance((Project)project).injectedToHost(injectedElement, injectedRange);
        PsiFile hostFile = hostContext.getContainingFile();
        assert (!(hostFile.getViewProvider() instanceof FreeThreadedFileViewProvider)) : "hostContext parameter must not be and injected element: " + hostContext;
        SmartPointerManager smartPointerManager = SmartPointerManager.getInstance((Project)project);
        this.myInjectedFileRangeInHostFile = smartPointerManager.createSmartPsiFileRangePointer(hostFile, hostRange);
        this.anchorLanguage = containingFile.getLanguage();
        this.anchorClass = injectedElement.getClass();
    }

    @Override
    public VirtualFile getVirtualFile() {
        PsiElement element = this.restoreElement();
        if (element == null) {
            return null;
        }
        return element.getContainingFile().getVirtualFile();
    }

    @Override
    public Segment getRange() {
        return this.getInjectedRange();
    }

    @Override
    public PsiElement restoreElement() {
        if (!this.mySyncMarkerIsValid) {
            return null;
        }
        PsiFile hostFile = InjectedSelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myLanguage);
        if (hostFile == null || !hostFile.isValid()) {
            return null;
        }
        PsiElement hostContext = this.restoreFromFile(hostFile);
        if (hostContext == null) {
            return null;
        }
        Segment segment = this.myInjectedFileRangeInHostFile.getRange();
        if (segment == null) {
            return null;
        }
        TextRange rangeInHostFile = TextRange.create((Segment)segment);
        PsiElement result = null;
        PsiFile injectedPsi = this.getInjectedFileIn(hostContext, hostFile, rangeInHostFile);
        if (injectedPsi != null) {
            Document document = PsiDocumentManager.getInstance((Project)this.getProject()).getDocument(injectedPsi);
            int start = ((DocumentWindow)document).hostToInjected(rangeInHostFile.getStartOffset());
            int end = ((DocumentWindow)document).hostToInjected(rangeInHostFile.getEndOffset());
            result = InjectedSelfElementInfo.findElementInside(injectedPsi, start, end, this.anchorClass, this.anchorLanguage);
        }
        return result;
    }

    private PsiFile getInjectedFileIn(@NotNull PsiElement hostContext, @NotNull PsiFile hostFile, final TextRange rangeInHostFile) {
        PsiFile[] result;
        block5: {
            PsiLanguageInjectionHost.InjectedPsiVisitor visitor;
            block4: {
                if (hostContext == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "getInjectedFileIn"));
                }
                if (hostFile == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "getInjectedFileIn"));
                }
                final InjectedLanguageManager manager = InjectedLanguageManager.getInstance((Project)this.getProject());
                result = new PsiFile[]{null};
                visitor = new PsiLanguageInjectionHost.InjectedPsiVisitor(){

                    public void visit(@NotNull PsiFile injectedPsi, @NotNull List<PsiLanguageInjectionHost.Shred> places) {
                        if (injectedPsi == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo$1", "visit"));
                        }
                        if (places == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo$1", "visit"));
                        }
                        TextRange hostRange = manager.injectedToHost((PsiElement)injectedPsi, new TextRange(0, injectedPsi.getTextLength()));
                        Document document = PsiDocumentManager.getInstance((Project)InjectedSelfElementInfo.this.getProject()).getDocument(injectedPsi);
                        if (hostRange.contains(rangeInHostFile) && document instanceof DocumentWindow) {
                            result[0] = injectedPsi;
                        }
                    }
                };
                PsiDocumentManager documentManager = PsiDocumentManager.getInstance((Project)this.getProject());
                Document document = documentManager.getDocument(hostFile);
                if (document == null || !documentManager.isUncommited(document)) break block4;
                for (DocumentWindow documentWindow : InjectedLanguageManager.getInstance((Project)this.getProject()).getCachedInjectedDocuments(hostFile)) {
                    PsiFile injected = documentManager.getPsiFile((Document)documentWindow);
                    if (injected == null) continue;
                    visitor.visit(injected, Collections.emptyList());
                }
                break block5;
            }
            List injected = InjectedLanguageManager.getInstance((Project)this.getProject()).getInjectedPsiFiles(hostContext);
            if (injected == null) break block5;
            for (Pair pair : injected) {
                PsiFile injectedFile = ((PsiElement)pair.first).getContainingFile();
                visitor.visit(injectedFile, ContainerUtil.emptyList());
            }
        }
        return result[0];
    }

    @Override
    public boolean pointsToTheSameElementAs(@NotNull SmartPointerElementInfo other) {
        if (other == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/smartPointers/InjectedSelfElementInfo", "pointsToTheSameElementAs"));
        }
        if (this.getClass() != other.getClass()) {
            return false;
        }
        if (!super.pointsToTheSameElementAs(other)) {
            return false;
        }
        SmartPointerElementInfo myElementInfo = ((SmartPsiElementPointerImpl)this.myInjectedFileRangeInHostFile).getElementInfo();
        SmartPointerElementInfo oElementInfo = ((SmartPsiElementPointerImpl)((InjectedSelfElementInfo)other).myInjectedFileRangeInHostFile).getElementInfo();
        return myElementInfo.pointsToTheSameElementAs(oElementInfo);
    }

    @Override
    public PsiFile restoreFile() {
        PsiFile hostFile = InjectedSelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myLanguage);
        if (hostFile == null || !hostFile.isValid()) {
            return null;
        }
        PsiElement hostContext = this.restoreFromFile(hostFile);
        if (hostContext == null) {
            return null;
        }
        Segment segment = this.myInjectedFileRangeInHostFile.getRange();
        if (segment == null) {
            return null;
        }
        TextRange rangeInHostFile = TextRange.create((Segment)segment);
        return this.getInjectedFileIn(hostContext, hostFile, rangeInHostFile);
    }

    public ProperTextRange getInjectedRange() {
        DocumentWindow documentWindow;
        PsiFile hostFile = InjectedSelfElementInfo.restoreFileFromVirtual(this.myVirtualFile, this.myProject, this.myLanguage);
        if (hostFile == null || !hostFile.isValid()) {
            return null;
        }
        PsiElement hostContext = this.restoreFromFile(hostFile);
        if (hostContext == null) {
            return null;
        }
        Segment hostElementRange = this.myInjectedFileRangeInHostFile.getRange();
        if (hostElementRange == null) {
            return null;
        }
        PsiFile injectedFile = this.restoreFile();
        if (injectedFile == null) {
            return null;
        }
        VirtualFile virtualFile = injectedFile.getVirtualFile();
        DocumentWindow documentWindow2 = documentWindow = virtualFile instanceof VirtualFileWindow ? ((VirtualFileWindow)virtualFile).getDocumentWindow() : null;
        if (documentWindow == null) {
            return null;
        }
        int start = documentWindow.hostToInjected(hostElementRange.getStartOffset());
        int end = documentWindow.hostToInjected(hostElementRange.getEndOffset());
        return ProperTextRange.create((int)start, (int)end);
    }

    @Override
    public void cleanup() {
        super.cleanup();
        SmartPointerManager.getInstance((Project)this.getProject()).removePointer((SmartPsiElementPointer)this.myInjectedFileRangeInHostFile);
    }
}

