/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.ide.todo.TodoConfiguration;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.impl.search.TodoItemImpl;
import com.intellij.psi.search.IndexPattern;
import com.intellij.psi.search.IndexPatternOccurrence;
import com.intellij.psi.search.TodoItem;
import com.intellij.psi.search.TodoPattern;
import org.jetbrains.annotations.NotNull;

public class TodoItemsCreator {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.psi.impl.search.TodoItemsCreator");
    private final TodoPattern[] myTodoPatterns = TodoConfiguration.getInstance().getTodoPatterns();

    public TodoItem createTodo(IndexPatternOccurrence occurrence) {
        TextRange occurrenceRange = occurrence.getTextRange();
        return new TodoItemImpl(occurrence.getFile(), occurrenceRange.getStartOffset(), occurrenceRange.getEndOffset(), this.mapPattern(occurrence.getPattern()));
    }

    @NotNull
    private TodoPattern mapPattern(@NotNull IndexPattern pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/TodoItemsCreator", "mapPattern"));
        }
        for (TodoPattern todoPattern : this.myTodoPatterns) {
            if (todoPattern.getIndexPattern() != pattern) continue;
            TodoPattern todoPattern2 = todoPattern;
            if (todoPattern2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/TodoItemsCreator", "mapPattern"));
            }
            return todoPattern2;
        }
        LOG.error("Could not find matching TODO pattern for index pattern " + pattern.getPatternString());
        if (null == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/psi/impl/search/TodoItemsCreator", "mapPattern"));
        }
        return null;
    }
}

