/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.search;

import com.intellij.lang.LanguageParserDefinitions;
import com.intellij.lang.ParserDefinition;
import com.intellij.lexer.Lexer;
import com.intellij.psi.JspPsiUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.impl.search.IndexPatternBuilder;
import com.intellij.psi.impl.search.JavaIndexPatternBuilder;
import com.intellij.psi.impl.search.LexerEditorHighlighterLexer;
import com.intellij.psi.impl.source.tree.StdTokenSets;
import com.intellij.psi.jsp.JspFile;
import com.intellij.psi.jsp.JspTokenType;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.tree.TokenSet;
import org.jetbrains.annotations.NotNull;

public class JspIndexPatternBuilder
implements IndexPatternBuilder {
    @Override
    public Lexer getIndexingLexer(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/JspIndexPatternBuilder", "getIndexingLexer"));
        }
        if (JspPsiUtil.isInJspFile((PsiElement)file)) {
            return LexerEditorHighlighterLexer.getLexerBasedOnLexerHighlighter(file.getText(), file.getVirtualFile(), file.getProject());
        }
        return null;
    }

    @Override
    public TokenSet getCommentTokenSet(@NotNull PsiFile file) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/psi/impl/search/JspIndexPatternBuilder", "getCommentTokenSet"));
        }
        JspFile jspFile = JspPsiUtil.getJspFile((PsiElement)file);
        TokenSet commentTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{JavaIndexPatternBuilder.XML_COMMENT_BIT_SET, StdTokenSets.COMMENT_BIT_SET});
        ParserDefinition parserDefinition = (ParserDefinition)LanguageParserDefinitions.INSTANCE.forLanguage(jspFile.getViewProvider().getTemplateDataLanguage());
        if (parserDefinition != null) {
            commentTokens = TokenSet.orSet((TokenSet[])new TokenSet[]{commentTokens, parserDefinition.getCommentTokens()});
        }
        return commentTokens;
    }

    @Override
    public int getCommentStartDelta(IElementType tokenType) {
        return tokenType == JspTokenType.JSP_COMMENT ? "<%--".length() : 0;
    }

    @Override
    public int getCommentEndDelta(IElementType tokenType) {
        return tokenType == JspTokenType.JSP_COMMENT ? "--%>".length() : 0;
    }
}

